"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _crypto = _interopRequireDefault(require("../../crypto"));
var _bcryptjs = _interopRequireDefault(require("bcryptjs"));
var _config = _interopRequireDefault(require("../../config"));
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, _req$body, email, meta, api_key, passwordHash, decryptedPassword, admin, employee, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, email = _req$body.email, meta = _req$body.meta;
          api_key = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          if (!(api_key !== _config["default"].adminCentral.api_key || !api_key)) {
            _context.next = 5;
            break;
          }
          throw new RequestError('Unauthorized User', 401);
        case 5:
          if (!meta) {
            _context.next = 22;
            break;
          }
          decryptedPassword = _crypto["default"].decrypt(meta, _config["default"].adminCentral.crypto_secret);
          if (decryptedPassword) {
            _context.next = 9;
            break;
          }
          throw new RequestError('Request from invalid source, meta decryption failed.', 409);
        case 9:
          passwordHash = _bcryptjs["default"].hashSync(decryptedPassword);
          _context.next = 12;
          return db.Admin.findOne({
            email: email,
            deletedAt: null
          });
        case 12:
          admin = _context.sent;
          if (!admin) {
            _context.next = 16;
            break;
          }
          _context.next = 16;
          return db.Admin.updateOne({
            email: email
          }, {
            $set: {
              password: passwordHash
            }
          });
        case 16:
          _context.next = 18;
          return db.Employee.findOne({
            email: email,
            deletedAt: null
          });
        case 18:
          employee = _context.sent;
          if (!employee) {
            _context.next = 22;
            break;
          }
          _context.next = 22;
          return db.Employee.updateOne({
            email: email
          }, {
            $set: {
              password: passwordHash
            }
          });
        case 22:
          return _context.abrupt("return", res.status(200).json({
            messages: meta ? "Password updated successfully" : "Meta not recieved, password not updated!"
          }));
        case 25:
          _context.prev = 25;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 32:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 25]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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