"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _syncDomains = require("../../service/syncDomains");
var _strategy = require("../../middlewares/strategy");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var company, syncDomains, _error$response, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return db.Company.findOne({
            _id: req.user.companyId
          });
        case 3:
          company = _context.sent;
          if (company) {
            _context.next = 6;
            break;
          }
          throw new RequestError("Company not found", 404);
        case 6:
          _context.next = 8;
          return (0, _syncDomains.syncDomainsFromTa)(company._id);
        case 8:
          syncDomains = _context.sent;
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "Domains fetched from Threatcop Admin and Created Successfully"
          }));
        case 12:
          _context.prev = 12;
          _context.t0 = _context["catch"](0);
          console.log("The error inside sync identity keys: ", _context.t0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0 === null || _context.t0 === void 0 ? void 0 : (_error$response = _context.t0.response) === null || _error$response === void 0 ? void 0 : _error$response.data);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 20:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 12]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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