"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, company, response, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _context.next = 4;
          return db.Company.findOne({
            _id: companyId,
            deletedAt: null
          });
        case 4:
          company = _context.sent;
          if (company) {
            _context.next = 7;
            break;
          }
          throw new RequestError("Company not found", 404);
        case 7:
          _context.next = 9;
          return axios.get("".concat(process.env.TAC_URL, "/api/sync-services/common/fetch-group-user-count"), _objectSpread({
            headers: {
              'Content-Type': 'application/json',
              'Authorization': "Bearer ".concat(company.tacLicenseKey)
            }
          }, config.proxy.enableForTA && {
            httpsAgent: config.proxy.proxyAgent,
            httpAgent: config.proxy.proxyAgent
          }));
        case 9:
          response = _context.sent;
          return _context.abrupt("return", res.status(200).send({
            success: true
          }));
        case 13:
          _context.prev = 13;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 20:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 13]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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