"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, api_key, _req$body, companyId, group, tacCompanyId, company, localCompanyId, i, g, groupId, groupIdentityKey, memberCount, groupName, offset, BATCH_LIMIT, currentLimit, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          api_key = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          if (!(!api_key || api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 4;
            break;
          }
          throw new RequestError('UnAuthorized User', 401);
        case 4:
          _req$body = req.body, companyId = _req$body.companyId, group = _req$body.group;
          tacCompanyId = companyId;
          _context.next = 8;
          return db.Company.findOne({
            tacCompanyId: tacCompanyId
          });
        case 8:
          company = _context.sent;
          if (company) {
            _context.next = 11;
            break;
          }
          throw new RequestError("Invalid CompanyId", 400);
        case 11:
          localCompanyId = company._id;
          i = 0;
        case 13:
          if (!(i < group.length)) {
            _context.next = 24;
            break;
          }
          g = group[i];
          groupId = g.groupId, groupIdentityKey = g.IdentityKey, memberCount = g.memberCount, groupName = g.groupName;
          _context.next = 18;
          return db.Group.updateOne({
            _id: groupId,
            localCompanyId: localCompanyId
          }, {
            $set: {
              tacIdentityKey: groupIdentityKey,
              groupName: groupName,
              lastSyncId: null,
              lastSyncIdMismatch: false
            }
          });
        case 18:
          // Main processing loop
          offset = 0;
          BATCH_LIMIT = 1000; // Process 1000 records at a time
          while (offset <= memberCount) {
            // Calculate the actual limit for this batch
            currentLimit = Math.min(BATCH_LIMIT, memberCount - offset);
            console.log({
              offset: offset,
              BATCH_LIMIT: BATCH_LIMIT,
              memberCount: memberCount,
              i: i,
              gLength: group.length - 1,
              check: offset + BATCH_LIMIT >= memberCount && i == group.length - 1
            });
            // Create queue job for processing this batch
            _kue.queue.create('sync-tac-users-identityKey', {
              tacCompanyId: tacCompanyId,
              groupIdentityKey: groupIdentityKey,
              appName: "TPIR",
              limit: currentLimit,
              offset: offset,
              isLastBatch: offset + BATCH_LIMIT >= memberCount && i == group.length - 1,
              companyId: localCompanyId
            }).removeOnComplete(true).save();

            // Increment offset for next batch
            offset += BATCH_LIMIT;
          }
        case 21:
          i++;
          _context.next = 13;
          break;
        case 24:
          if (!(group.length == 0)) {
            _context.next = 27;
            break;
          }
          _context.next = 27;
          return db.Company.updateOne({
            _id: localCompanyId
          }, {
            $set: {
              isTacEnabled: true,
              isTaConnectionInProgess: false
            }
          });
        case 27:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "Groups and its user's IdentityKey sync jobs created successfully"
          }));
        case 30:
          _context.prev = 30;
          _context.t0 = _context["catch"](0);
          console.log("The error inside sync identity keys: ", _context.t0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 38:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 30]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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