"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _axios = _interopRequireDefault(require("axios"));
var _fs = _interopRequireDefault(require("fs"));
var _path = _interopRequireDefault(require("path"));
var _strategy = require("../../middlewares/strategy");
var _config = _interopRequireDefault(require("../../config"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var logoDir = _path["default"].join(_path["default"].dirname(require.main.filename), 'public', 'logo');
function taConnected(_x, _x2, _x3) {
  return _taConnected.apply(this, arguments);
}
function _taConnected() {
  _taConnected = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var company;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _context2.next = 3;
          return db.Company.findById(req.user.companyId).select('isTacEnabled').lean();
        case 3:
          company = _context2.sent;
          if (!(company !== null && company !== void 0 && company.isTacEnabled)) {
            _context2.next = 6;
            break;
          }
          return _context2.abrupt("return", next());
        case 6:
          throw new RequestError('Threatcop Admin is not connected', 403);
        case 9:
          _context2.prev = 9;
          _context2.t0 = _context2["catch"](0);
          next(_context2.t0);
        case 12:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 9]]);
  }));
  return _taConnected.apply(this, arguments);
}
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _response$data, companyId, company, tacLicenseKey, response, _response$data$respon, companyDetails, rootUserDetails, remoteLogo, cleanPath, remoteBase, filename, imageUrl, axiosConfig, imageResp, localPath, statusCode, isClientError;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _context.next = 4;
          return db.Company.findById(companyId);
        case 4:
          company = _context.sent;
          if (company) {
            _context.next = 7;
            break;
          }
          throw new RequestError('Company not found', 404);
        case 7:
          tacLicenseKey = company.tacLicenseKey;
          if (tacLicenseKey) {
            _context.next = 10;
            break;
          }
          throw new RequestError('License key not found', 404);
        case 10:
          _context.next = 12;
          return _axios["default"].get("".concat(_config["default"].adminCentral.url, "/api/sync-services/common/fetch-organisation-details"), _objectSpread({
            headers: {
              'Content-Type': 'application/json',
              'Authorization': "Bearer ".concat(tacLicenseKey)
            }
          }, _config["default"].proxy.enableForTA && {
            httpsAgent: _config["default"].proxy.proxyAgent,
            httpAgent: _config["default"].proxy.proxyAgent
          }));
        case 12:
          response = _context.sent;
          if ((_response$data = response.data) !== null && _response$data !== void 0 && _response$data.response) {
            _context.next = 15;
            break;
          }
          throw new RequestError('Invalid response from external API', 502);
        case 15:
          console.log('fetchOrganisationDetails response:', response.data.response);
          _response$data$respon = response.data.response, companyDetails = _response$data$respon.companyDetails, rootUserDetails = _response$data$respon.rootUserDetails;
          _context.next = 19;
          return db.Admin.updateOne({
            companyId: companyId
          }, {
            firstName: rootUserDetails.firstName,
            lastName: rootUserDetails.lastName,
            phone: rootUserDetails.phoneNumber
          });
        case 19:
          remoteLogo = companyDetails.logo;
          console.log('remoteLogo:', remoteLogo);
          if (remoteLogo) {
            _context.next = 23;
            break;
          }
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: 'Org details synced; no logo provided.'
          }));
        case 23:
          cleanPath = remoteLogo.split('?')[0];
          remoteBase = _path["default"].basename(cleanPath);
          filename = "".concat(companyId, "_").concat(remoteBase);
          console.log('filename:', filename);
          if (!(company.logo === filename)) {
            _context.next = 30;
            break;
          }
          console.log('Logo already exists, skipping download.');
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: 'Org details synced; logo not changed.',
            logoPath: "".concat(_config["default"].app.url, "/api/static/logo/").concat(filename)
          }));
        case 30:
          console.log('Downloading logo...');
          imageUrl = "".concat(_config["default"].adminCentral.url, "/").concat(remoteLogo);
          axiosConfig = {
            responseType: 'stream'
          };
          if (_config["default"].proxy.enableForTA) {
            axiosConfig.httpsAgent = _config["default"].proxy.proxyAgent;
            axiosConfig.httpAgent = _config["default"].proxy.proxyAgent;
          }
          _context.next = 36;
          return _axios["default"].get(imageUrl, axiosConfig);
        case 36:
          imageResp = _context.sent;
          if (!(imageResp.status !== 200)) {
            _context.next = 39;
            break;
          }
          throw new RequestError('Failed to fetch logo', 502);
        case 39:
          console.log('Logo downloaded, saving to local storage...');
          localPath = _path["default"].join(logoDir, filename);
          _context.next = 43;
          return new Promise(function (resolve, reject) {
            var writer = _fs["default"].createWriteStream(localPath);
            imageResp.data.pipe(writer);
            writer.on('finish', resolve);
            writer.on('error', reject);
          });
        case 43:
          console.log('Logo saved to local storage.');
          company.logo = filename;
          _context.next = 47;
          return company.save();
        case 47:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: 'Org details synced; logo updated.',
            logoPath: "".concat(_config["default"].app.url, "/api/static/logo/").concat(filename)
          }));
        case 50:
          _context.prev = 50;
          _context.t0 = _context["catch"](0);
          console.error('fetchOrganisationDetails error:', _context.t0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          return _context.abrupt("return", res.status(statusCode).json(_objectSpread({
            success: false,
            message: isClientError ? _context.t0.message : 'Internal server error.'
          }, isClientError && {
            error: {
              code: _context.t0.code || 'UNEXPECTED_ERROR'
            }
          })));
        case 56:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 50]]);
  }));
  return function controller(_x4, _x5, _x6) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, taConnected, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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