"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _config = _interopRequireDefault(require("../../config"));
var _kue = require("../../kue");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$headers$authoriz, _req$headers, _req$headers$authoriz2, api_key, _req$body, userId, roleId, companyId, employee, employeeRoles, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          api_key = (_req$headers$authoriz = req === null || req === void 0 ? void 0 : (_req$headers = req.headers) === null || _req$headers === void 0 ? void 0 : (_req$headers$authoriz2 = _req$headers.authorization) === null || _req$headers$authoriz2 === void 0 ? void 0 : _req$headers$authoriz2.split(' ')[1]) !== null && _req$headers$authoriz !== void 0 ? _req$headers$authoriz : null;
          if (!(!api_key || api_key !== _config["default"].adminCentral.api_key)) {
            _context.next = 4;
            break;
          }
          throw new RequestError('Unauthorized User', 401);
        case 4:
          _req$body = req.body, userId = _req$body.userId, roleId = _req$body.roleId, companyId = _req$body.companyId;
          if (!(!userId || !roleId || !companyId)) {
            _context.next = 7;
            break;
          }
          throw new RequestError('Invalid Request: Missing Parameters', 400);
        case 7:
          _context.next = 9;
          return db.Employee.findOne({
            _id: userId,
            companyId: companyId,
            deletedAt: null
          });
        case 9:
          employee = _context.sent;
          if (employee) {
            _context.next = 12;
            break;
          }
          throw new RequestError("Employee not found!");
        case 12:
          _context.next = 14;
          return db.EmployeeRole.findOne({
            companyId: companyId,
            employeeId: userId,
            deletedAt: null
          });
        case 14:
          employeeRoles = _context.sent;
          if (employeeRoles) {
            _context.next = 20;
            break;
          }
          _context.next = 18;
          return db.EmployeeRole.create({
            roleIds: [roleId],
            employeeId: userId,
            companyId: companyId
          });
        case 18:
          _context.next = 22;
          break;
        case 20:
          _context.next = 22;
          return db.EmployeeRole.updateOne({
            companyId: companyId,
            employeeId: userId,
            deletedAt: null
          }, {
            $set: {
              roleIds: [roleId]
            }
          });
        case 22:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "IAM updated successfully."
          }));
        case 25:
          _context.prev = 25;
          _context.t0 = _context["catch"](0);
          statusCode = _context.t0.status || 500;
          isClientError = statusCode >= 400 && statusCode < 500;
          console.error('API Error:', _context.t0);
          responseMessage = isClientError ? _context.t0.message || 'The request could not be processed.' : 'An internal server error occurred.';
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            error: isClientError ? {
              code: _context.t0.code || 'UNEXPECTED_ERROR',
              description: _context.t0.description || null
            } : undefined
          });
        case 32:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 25]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJjb250cm9sbGVyIiwicmVxIiwicmVzIiwibmV4dCIsImFwaV9rZXkiLCJoZWFkZXJzIiwiYXV0aG9yaXphdGlvbiIsInNwbGl0IiwiY29uZmlnIiwiYWRtaW5DZW50cmFsIiwiUmVxdWVzdEVycm9yIiwiYm9keSIsInVzZXJJZCIsInJvbGVJZCIsImNvbXBhbnlJZCIsImRiIiwiRW1wbG95ZWUiLCJmaW5kT25lIiwiX2lkIiwiZGVsZXRlZEF0IiwiZW1wbG95ZWUiLCJFbXBsb3llZVJvbGUiLCJlbXBsb3llZUlkIiwiZW1wbG95ZWVSb2xlcyIsImNyZWF0ZSIsInJvbGVJZHMiLCJ1cGRhdGVPbmUiLCIkc2V0Iiwic3RhdHVzIiwianNvbiIsInN1Y2Nlc3MiLCJtZXNzYWdlIiwic3RhdHVzQ29kZSIsImlzQ2xpZW50RXJyb3IiLCJjb25zb2xlIiwiZXJyb3IiLCJyZXNwb25zZU1lc3NhZ2UiLCJjb2RlIiwiZGVzY3JpcHRpb24iLCJ1bmRlZmluZWQiLCJhcGlSb3V0ZXIiLCJleHByZXNzIiwiUm91dGVyIiwicm91dGUiLCJwb3N0Il0sInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2FwaS9hZG1pbkNlbnRyYWwvdXBkYXRlLWlhbS5qcyJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgZXhwcmVzcyBmcm9tICdleHByZXNzJztcbmltcG9ydCBjb25maWcgZnJvbSAnLi4vLi4vY29uZmlnJ1xuaW1wb3J0IHsgcXVldWUgfSBmcm9tICcuLi8uLi9rdWUnO1xuXG5cbmxldCBjb250cm9sbGVyID0gYXN5bmMgKHJlcSwgcmVzLCBuZXh0KSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgICAgY29uc3QgYXBpX2tleSA9IHJlcT8uaGVhZGVycz8uYXV0aG9yaXphdGlvbj8uc3BsaXQoJyAnKVsxXSA/PyBudWxsO1xuICAgICAgICAgICAgaWYgKCFhcGlfa2V5IHx8IGFwaV9rZXkgIT09IGNvbmZpZy5hZG1pbkNlbnRyYWwuYXBpX2tleSkge1xuICAgICAgICAgICAgICAgIHRocm93IG5ldyBSZXF1ZXN0RXJyb3IoJ1VuYXV0aG9yaXplZCBVc2VyJywgNDAxKTtcbiAgICAgICAgICAgIH1cbiAgICBcbiAgICAgICAgICAgIGxldCB7IHVzZXJJZCwgcm9sZUlkLCBjb21wYW55SWQgfSA9IHJlcS5ib2R5O1xuICAgICAgICAgICAgaWYgKCF1c2VySWQgfHwgIXJvbGVJZCB8fCAhY29tcGFueUlkKSB7XG4gICAgICAgICAgICAgICAgdGhyb3cgbmV3IFJlcXVlc3RFcnJvcignSW52YWxpZCBSZXF1ZXN0OiBNaXNzaW5nIFBhcmFtZXRlcnMnLCA0MDApO1xuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBjb25zdCBlbXBsb3llZSA9IGF3YWl0IGRiLkVtcGxveWVlLmZpbmRPbmUoe19pZDogdXNlcklkLCBjb21wYW55SWQsIGRlbGV0ZWRBdDogbnVsbH0pXG4gICAgICAgICAgICBpZighZW1wbG95ZWUpIHRocm93IG5ldyBSZXF1ZXN0RXJyb3IoXCJFbXBsb3llZSBub3QgZm91bmQhXCIpXG4gICAgICAgICAgICBcbiAgICAgICAgICAgIGNvbnN0IGVtcGxveWVlUm9sZXMgPSBhd2FpdCBkYi5FbXBsb3llZVJvbGUuZmluZE9uZSh7Y29tcGFueUlkLCBlbXBsb3llZUlkOiB1c2VySWQsIGRlbGV0ZWRBdDogbnVsbH0pXG4gICAgICAgICAgICBpZighZW1wbG95ZWVSb2xlcyl7XG4gICAgICAgICAgICAgICAgYXdhaXQgZGIuRW1wbG95ZWVSb2xlLmNyZWF0ZSh7cm9sZUlkczogW3JvbGVJZF0sIGVtcGxveWVlSWQ6IHVzZXJJZCwgY29tcGFueUlkfSlcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIGVsc2V7XG4gICAgICAgICAgICAgICAgYXdhaXQgZGIuRW1wbG95ZWVSb2xlLnVwZGF0ZU9uZSh7Y29tcGFueUlkLCBlbXBsb3llZUlkOiB1c2VySWQsIGRlbGV0ZWRBdDogbnVsbH0seyRzZXQ6e1xuICAgICAgICAgICAgICAgICAgICByb2xlSWRzOiBbcm9sZUlkXVxuICAgICAgICAgICAgICAgIH19KVxuICAgICAgICAgICAgfVxuICAgIFxuICAgICAgICAgICAgcmV0dXJuIHJlcy5zdGF0dXMoMjAwKS5qc29uKHsgc3VjY2VzczogdHJ1ZSwgbWVzc2FnZTogXCJJQU0gdXBkYXRlZCBzdWNjZXNzZnVsbHkuXCIgfSk7XG4gICAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICAgIGNvbnN0IHN0YXR1c0NvZGUgPSBlcnJvci5zdGF0dXMgfHwgNTAwO1xuICAgICAgICAgIGNvbnN0IGlzQ2xpZW50RXJyb3IgPSBzdGF0dXNDb2RlID49IDQwMCAmJiBzdGF0dXNDb2RlIDwgNTAwO1xuICAgICAgICAgIGNvbnNvbGUuZXJyb3IoJ0FQSSBFcnJvcjonLCBlcnJvcik7XG5cbiAgICAgICAgICBjb25zdCByZXNwb25zZU1lc3NhZ2UgPSBpc0NsaWVudEVycm9yXG4gICAgICAgICAgICAgID8gZXJyb3IubWVzc2FnZSB8fCAnVGhlIHJlcXVlc3QgY291bGQgbm90IGJlIHByb2Nlc3NlZC4nXG4gICAgICAgICAgICAgIDogJ0FuIGludGVybmFsIHNlcnZlciBlcnJvciBvY2N1cnJlZC4nO1xuXG4gICAgICAgICAgcmVzLnN0YXR1cyhzdGF0dXNDb2RlKS5qc29uKHtcbiAgICAgICAgICAgICAgc3VjY2VzczogZmFsc2UsXG4gICAgICAgICAgICAgIG1lc3NhZ2U6IHJlc3BvbnNlTWVzc2FnZSxcbiAgICAgICAgICAgICAgZXJyb3I6IGlzQ2xpZW50RXJyb3IgPyB7IGNvZGU6IGVycm9yLmNvZGUgfHwgJ1VORVhQRUNURURfRVJST1InLCBkZXNjcmlwdGlvbjogZXJyb3IuZGVzY3JpcHRpb24gfHwgbnVsbCB9IDogdW5kZWZpbmVkLFxuICAgICAgICAgIH0pO1xuICAgICAgfVxuICAgIH1cbmNvbnN0IGFwaVJvdXRlciA9IGV4cHJlc3MuUm91dGVyKCk7XG5hcGlSb3V0ZXIucm91dGUoJy8nKS5wb3N0KGNvbnRyb2xsZXIpO1xuZXhwb3J0IGRlZmF1bHQgYXBpUm91dGVyOyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBR0EsSUFBSUEsVUFBVTtFQUFBLHlGQUFHLGlCQUFPQyxHQUFHLEVBQUVDLEdBQUcsRUFBRUMsSUFBSTtJQUFBO0lBQUE7TUFBQTtRQUFBO1VBQUE7VUFFeEJDLE9BQU8sNEJBQUdILEdBQUcsYUFBSEEsR0FBRyx1Q0FBSEEsR0FBRyxDQUFFSSxPQUFPLDJFQUFaLGFBQWNDLGFBQWEsMkRBQTNCLHVCQUE2QkMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyx5RUFBSSxJQUFJO1VBQUEsTUFDMUQsQ0FBQ0gsT0FBTyxJQUFJQSxPQUFPLEtBQUtJLGtCQUFNLENBQUNDLFlBQVksQ0FBQ0wsT0FBTztZQUFBO1lBQUE7VUFBQTtVQUFBLE1BQzdDLElBQUlNLFlBQVksQ0FBQyxtQkFBbUIsRUFBRSxHQUFHLENBQUM7UUFBQTtVQUFBLFlBR2hCVCxHQUFHLENBQUNVLElBQUksRUFBdENDLE1BQU0sYUFBTkEsTUFBTSxFQUFFQyxNQUFNLGFBQU5BLE1BQU0sRUFBRUMsU0FBUyxhQUFUQSxTQUFTO1VBQUEsTUFDM0IsQ0FBQ0YsTUFBTSxJQUFJLENBQUNDLE1BQU0sSUFBSSxDQUFDQyxTQUFTO1lBQUE7WUFBQTtVQUFBO1VBQUEsTUFDMUIsSUFBSUosWUFBWSxDQUFDLHFDQUFxQyxFQUFFLEdBQUcsQ0FBQztRQUFBO1VBQUE7VUFBQSxPQUcvQ0ssRUFBRSxDQUFDQyxRQUFRLENBQUNDLE9BQU8sQ0FBQztZQUFDQyxHQUFHLEVBQUVOLE1BQU07WUFBRUUsU0FBUyxFQUFUQSxTQUFTO1lBQUVLLFNBQVMsRUFBRTtVQUFJLENBQUMsQ0FBQztRQUFBO1VBQS9FQyxRQUFRO1VBQUEsSUFDVkEsUUFBUTtZQUFBO1lBQUE7VUFBQTtVQUFBLE1BQVEsSUFBSVYsWUFBWSxDQUFDLHFCQUFxQixDQUFDO1FBQUE7VUFBQTtVQUFBLE9BRS9CSyxFQUFFLENBQUNNLFlBQVksQ0FBQ0osT0FBTyxDQUFDO1lBQUNILFNBQVMsRUFBVEEsU0FBUztZQUFFUSxVQUFVLEVBQUVWLE1BQU07WUFBRU8sU0FBUyxFQUFFO1VBQUksQ0FBQyxDQUFDO1FBQUE7VUFBL0ZJLGFBQWE7VUFBQSxJQUNmQSxhQUFhO1lBQUE7WUFBQTtVQUFBO1VBQUE7VUFBQSxPQUNQUixFQUFFLENBQUNNLFlBQVksQ0FBQ0csTUFBTSxDQUFDO1lBQUNDLE9BQU8sRUFBRSxDQUFDWixNQUFNLENBQUM7WUFBRVMsVUFBVSxFQUFFVixNQUFNO1lBQUVFLFNBQVMsRUFBVEE7VUFBUyxDQUFDLENBQUM7UUFBQTtVQUFBO1VBQUE7UUFBQTtVQUFBO1VBQUEsT0FHMUVDLEVBQUUsQ0FBQ00sWUFBWSxDQUFDSyxTQUFTLENBQUM7WUFBQ1osU0FBUyxFQUFUQSxTQUFTO1lBQUVRLFVBQVUsRUFBRVYsTUFBTTtZQUFFTyxTQUFTLEVBQUU7VUFBSSxDQUFDLEVBQUM7WUFBQ1EsSUFBSSxFQUFDO2NBQ25GRixPQUFPLEVBQUUsQ0FBQ1osTUFBTTtZQUNwQjtVQUFDLENBQUMsQ0FBQztRQUFBO1VBQUEsaUNBR0FYLEdBQUcsQ0FBQzBCLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQ0MsSUFBSSxDQUFDO1lBQUVDLE9BQU8sRUFBRSxJQUFJO1lBQUVDLE9BQU8sRUFBRTtVQUE0QixDQUFDLENBQUM7UUFBQTtVQUFBO1VBQUE7VUFFaEZDLFVBQVUsR0FBRyxZQUFNSixNQUFNLElBQUksR0FBRztVQUNoQ0ssYUFBYSxHQUFHRCxVQUFVLElBQUksR0FBRyxJQUFJQSxVQUFVLEdBQUcsR0FBRztVQUMzREUsT0FBTyxDQUFDQyxLQUFLLENBQUMsWUFBWSxjQUFRO1VBRTVCQyxlQUFlLEdBQUdILGFBQWEsR0FDL0IsWUFBTUYsT0FBTyxJQUFJLHFDQUFxQyxHQUN0RCxvQ0FBb0M7VUFFMUM3QixHQUFHLENBQUMwQixNQUFNLENBQUNJLFVBQVUsQ0FBQyxDQUFDSCxJQUFJLENBQUM7WUFDeEJDLE9BQU8sRUFBRSxLQUFLO1lBQ2RDLE9BQU8sRUFBRUssZUFBZTtZQUN4QkQsS0FBSyxFQUFFRixhQUFhLEdBQUc7Y0FBRUksSUFBSSxFQUFFLFlBQU1BLElBQUksSUFBSSxrQkFBa0I7Y0FBRUMsV0FBVyxFQUFFLFlBQU1BLFdBQVcsSUFBSTtZQUFLLENBQUMsR0FBR0M7VUFDaEgsQ0FBQyxDQUFDO1FBQUM7UUFBQTtVQUFBO01BQUE7SUFBQTtFQUFBLENBRVI7RUFBQSxnQkF6Q0R2QyxVQUFVO0lBQUE7RUFBQTtBQUFBLEdBeUNUO0FBQ0wsSUFBTXdDLFNBQVMsR0FBR0MsbUJBQU8sQ0FBQ0MsTUFBTSxFQUFFO0FBQ2xDRixTQUFTLENBQUNHLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQ0MsSUFBSSxDQUFDNUMsVUFBVSxDQUFDO0FBQUMsZUFDdkJ3QyxTQUFTO0FBQUEifQ==