"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _axios = _interopRequireDefault(require("axios"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var connectionStatus, company, individualUserGroup, activeUsersGroup, _individualUserGroup, allUsersGroup, updateFields, statusCode, isClientError, responseMessage;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          connectionStatus = req.body.connectionStatus;
          _context.prev = 1;
          _context.next = 4;
          return db.Company.findById(req.user.companyId);
        case 4:
          company = _context.sent;
          if (!(company !== null && company !== void 0 && company.isTaConnectionInProgess)) {
            _context.next = 7;
            break;
          }
          throw new RequestError("Integration with TA is in progress. Please Wait!");
        case 7:
          if (connectionStatus) {
            _context.next = 20;
            break;
          }
          _context.next = 10;
          return db.Group.findOne({
            groupName: "Individual-Users",
            type: "Admin",
            companyId: company === null || company === void 0 ? void 0 : company._id,
            deletedAt: null
          });
        case 10:
          individualUserGroup = _context.sent;
          _context.next = 13;
          return db.Group.updateMany({
            companyId: company._id,
            type: "Custom",
            deletedAt: null
          }, {
            $set: {
              type: "Admin"
            }
          });
        case 13:
          if (!individualUserGroup) {
            _context.next = 18;
            break;
          }
          _context.next = 16;
          return db.User.updateMany({
            companyId: company._id
          }, {
            $pull: {
              groups: individualUserGroup._id
            }
          });
        case 16:
          _context.next = 18;
          return db.Group.deleteOne({
            _id: individualUserGroup._id,
            companyId: company._id
          });
        case 18:
          _context.next = 34;
          break;
        case 20:
          _context.next = 22;
          return db.Group.findOne({
            groupName: 'Active Users',
            type: 'Admin',
            companyId: company._id,
            deletedAt: null
          });
        case 22:
          activeUsersGroup = _context.sent;
          _context.next = 25;
          return db.Group.create({
            groupName: 'Individual-Users',
            companyId: company._id,
            type: "Admin"
          });
        case 25:
          _individualUserGroup = _context.sent;
          _context.next = 28;
          return db.Group.findOne({
            groupName: 'all-users-tpir',
            type: 'Admin',
            isDefaultGroup: true,
            companyId: company._id,
            deletedAt: null
          });
        case 28:
          allUsersGroup = _context.sent;
          console.log({
            allUsersGroup: allUsersGroup
          });
          _context.next = 32;
          return db.Group.updateOne({
            _id: allUsersGroup._id
          }, {
            $set: {
              type: "Custom"
            }
          });
        case 32:
          _context.next = 34;
          return db.User.updateMany({
            groups: {
              $all: [allUsersGroup._id],
              $size: 1
            },
            companyId: company._id
          }, {
            $addToSet: {
              groups: _individualUserGroup._id
            }
          });
        case 34:
          _context.next = 36;
          return _axios["default"].post("".concat(process.env.TAC_URL, "/api/sync-services/common/admin-central-connect"), {
            connectionStatus: connectionStatus
          }, _objectSpread({
            headers: {
              Authorization: "Bearer ".concat(company.tacLicenseKey)
            }
          }, config.proxy.enableForTA && {
            httpsAgent: config.proxy.proxyAgent,
            httpAgent: config.proxy.proxyAgent
          }));
        case 36:
          updateFields = connectionStatus ? {
            isTaConnectionInProgess: true,
            isTacEnabled: false
          } : {
            isTacEnabled: false,
            isTaConnectionInProgess: false
          };
          _context.next = 39;
          return db.Company.updateOne({
            _id: company._id
          }, {
            $set: updateFields
          });
        case 39:
          console.log("Operation completed successfully.");
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: connectionStatus ? "Connecting Threatcop Admin" : "Threatcop Admin Disconnected Successfully",
            connectionStatus: connectionStatus
          }));
        case 43:
          _context.prev = 43;
          _context.t0 = _context["catch"](1);
          statusCode = _context.t0.status || 500; // Use a default of 500 if no specific error status is defined
          isClientError = statusCode >= 400 && statusCode < 500; // Log the error internally
          console.error('API Error:', _context.t0);

          // Respond with a generic error message for server errors to avoid exposing details
          responseMessage = isClientError ? _context.t0.message || "The request could not be processed." : "An internal server error occurred.";
          res.status(statusCode).json({
            success: false,
            message: responseMessage,
            // Include more specific error details only if it's safe to expose them
            error: isClientError ? {
              code: _context.t0.code || "UNEXPECTED_ERROR",
              // Custom or generic error code
              description: _context.t0.description || null // Optional additional info
            } : undefined
          });
        case 50:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[1, 43]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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