"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _permission = require("../../middlewares/permission");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  page: _joi["default"].number().min(0).required(),
  limit: _joi["default"].number().min(1).required(),
  search: _joi["default"].string().optional().allow(null).empty(''),
  advanceSearchId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {get} /api/v1/advance-search/emails?page=1&limit=10&advanceSearchId=63b281595e8160f2ed081806 emails
 * @apiName emails
 * @apiGroup Advance Search
 * @apiDescription Fetch Record For Particular Search
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery {String}          advanceSearchId      Particular Advance Search id.
 * @apiQuery {Number}          page                 Takes page number to fetch
 * @apiQuery {Number}          limit                Takes number of records to show in a page
 * 
 * @apiSuccess {Boolean} Success   true
 * @apiSuccess {String}  results   list of found emails for search.
 * @apiSuccess {Boolean} count     number of results returned
 *  
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *      {
 *        "Success":true,
 *        "results":[{
 *                       "_id": "63ca962c6e4d31196150f6c4",
 *                       "from": "vikas@kratikal.co",
 *                       "fromName": "vikas kumar",
 *                       "to": [
 *                           {
 *                               "emailAddress": {
 *                                   "name": "Himanshu Bisht",
 *                                   "address": "Himanshu@kdmarc.com"
 *                               }
 *                           },
 *                           {
 *                               "emailAddress": {
 *                                   "name": "vikas",
 *                                   "address": "vikas@kdmarc.com"
 *                               }
 *                           }
 *                               ],
 *                       "cc": [
 *                           {
 *                               "emailAddress": {
 *                                   "name": "Gaurav Pandey",
 *                                   "address": "gaurav@kdmarc.com"
 *                               }
 *                           },
 *                           {
 *                               "emailAddress": {
 *                                   "name": "Arpit Rao",
 *                                   "address": "arpit@kdmarc.com"
 *                               }
 *                           },
 *                           {
 *                               "emailAddress": {
 *                                   "name": "Pavan Kushwaha",
 *                                   "address": "pavan@kdmarc.com"
 *                               }
 *                           }
 *                               ],
 *                           "mailRecievedTime": "2023-01-19T05:21:53.000Z",
 *                           "body": "<html><head>\r\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"></head><body><div dir=\"ltr\"><div class=\"gmail_default\" style=\"font-family:verdana,sans-serif\">Hello Team,</div><div class=\"gmail_default\" style=\"font-family:verdana,sans-serif\"><br></div><div class=\"gmail_default\" style=\"font-family:verdana,sans-serif\">Hope everyone is doing well!!</div><div class=\"gmail_default\" style=\"font-family:verdana,sans-serif\"><br></div><div class=\"gmail_default\" style=\"font-family:verdana,sans-serif\">As you all are aware, we are in the process of getting complied with GDPR standards.</div><div class=\"gmail_default\" style=\"font-family:verdana,sans-serif\">GDPR dedicatedly talks about the Data security of the Data subjects.</div><div class=\"gmail_default\" style=\"font-family:verdana,sans-serif\"><br></div><div class=\"gmail_default\" style=\"font-family:verdana,sans-serif\"><br></div><div class=\"gmail_default\" style=\"font-family:verdana,sans-serif\"><div class=\"gmail_default\"><a href=\"https://www.google.com/\" target=\"_blank\">https://www.google.com/</a></div><div class=\"gmail_default\"><br></div><div class=\"gmail_default\"><a href=\"https://www.color-name.com/\" target=\"_blank\">https://www.color-name.com/</a><br></div><div class=\"gmail_default\"><br></div><div class=\"gmail_default\"><a href=\"https://icolorpalette.com/\" target=\"_blank\">https://icolorpalette.com/</a></div><div class=\"gmail_default\"><br></div><div class=\"gmail_default\"><a href=\"https://kratikal.com/\" target=\"_blank\">https://kratikal.com/</a></div></div></div></body></html>",
 *                           "subject": "New Specifications",
 *                           "messageId": "AAMkADg4N2I3ODU1LTg5MzgtNGJlOS05MDdmLTdkODQzY2UxODJlMABGAAAAAAAEeu5jAGlBSIzFYD0Uf00rBwDYeUh9annVS4gyZQy0RznfAAAAAAEMAADYeUh9annVS4gyZQy0RznfAABeS4CmAAA=",
 *                           "isTrashed": false,
 *                           "userId": "63b677a644ed3b8a723865b0",
 *                           "domainId": "63b676c744ed3b8a72386597",
 *                           "companyId": "63ad46cf6b429daa7aa9b697",
 *                           "advanceSearchId": "63ca962b6e4d31196150f6c0",
 *                           "deletedAt": null,
 *                           "__v": 0,
 *                           "createdAt": "2023-01-20T13:25:00.761Z",
 *                           "updatedAt": "2023-01-20T13:25:00.761Z"
 *                   }],
 *              "count": 1
 *       }
 * 
 *      @apiError (400)  {String} success-1    false
 *      @apiError (400)  {Array}  messages-1  "advanceSearchId length must be 24 characters long"
 *      @apiError (400)  {String} success-2    false
 *      @apiError (400)  {Array}  messages-2  "advanceSearchId must only contain hexadecimal characters"
 * 
 *      @apiErrorExample Error-Response:
 *         HTTP/1.1 400 Not Found
 *         {
 *          "success":false,
 *          "messages":["\"advanceSearchId\" length must be 24 characters long"]
 *          }
*      @apiErrorExample Error-Response:
 *         HTTP/1.1 400 Not Found
 *         {
 *          "success":false,
 *          "messages":["\"advanceSearchId\" must only contain hexadecimal characters"]
 *          }
 *
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$query, advanceSearchId, _req$query$page, page, _req$query$limit, limit, _req$query$search, search, condition, regex, count, results;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$query = req.query, advanceSearchId = _req$query.advanceSearchId, _req$query$page = _req$query.page, page = _req$query$page === void 0 ? 1 : _req$query$page, _req$query$limit = _req$query.limit, limit = _req$query$limit === void 0 ? 10 : _req$query$limit, _req$query$search = _req$query.search, search = _req$query$search === void 0 ? '' : _req$query$search;
          condition = {
            advanceSearchId: advanceSearchId,
            deletedAt: null
          };
          if (search && search.length) {
            regex = new RegExp(search, "i");
            condition['$or'] = [{
              to: regex
            }, {
              from: regex
            }, {
              subject: regex
            }];
          }
          _context.next = 6;
          return db.AdvanceSearchEmail.countDocuments(condition);
        case 6:
          count = _context.sent;
          _context.next = 9;
          return db.AdvanceSearchEmail.find(condition).skip((page - 1) * limit).limit(limit);
        case 9:
          results = _context.sent;
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            results: results,
            count: count
          }));
        case 13:
          _context.prev = 13;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 17:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 13]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-ADVS"), (0, _permission.permission)('AdvancedSearch', 'Read'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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