"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _permission = require("../../middlewares/permission");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var validator = _joi["default"].object().keys({
  page: _joi["default"].number().min(0).required(),
  limit: _joi["default"].number().min(1).required(),
  domainId: _joi["default"].string().hex().length(24).optional(),
  search: _joi["default"].string().optional().allow(null).empty('')
});

/**
 * @api {get} /api/v1/advance-search/list?page=1&limit=10&domainId=63a2b5df5f536ee8fb0b2093 list
 * @apiName list
 * @apiGroup Advance Search
 * @apiDescription Fetch all advance searches
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery {String}          domainId             Particular Domain id.
 * @apiQuery {Number}          [page]                 Takes page number to fetch
 * @apiQuery {Number}          [limit]                Takes number of records to show in a page
 * @apiQuery {String}          [search]             Takes a string to search a particular record
 * 
 * @apiSuccess {Boolean} Success   true
 * @apiSuccess {String}  results   list of all advance search(s).
 * @apiSuccess {Boolean} count     number of results returned
 *  
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *      {  "Success":true,
 *         "results":[
 *                  "_id": "63cfa68cfa94cabd3e6a596f",
 *                  "from": "adads@gmail.com",
 *                  "to": "",
 *                  "subject": "a",
 *                  "fromDate": "2023-01-23T00:00:00.000Z",
 *                  "toDate": "2023-01-24T23:59:59.000Z",
 *                  "filter": "&$filter=from/emailAddress/address eq 'adads@gmail.com' and subject eq 'a' and receivedDateTime ge 2023-01-23T00:00:00Z and receivedDateTime le 2023-01-24T23:59:59Z",
 *                  "isError": false,
 *                  "isErrorMessage": "",
 *                  "isProcessing": false,
 *                  "syncStartAt": "2023-01-24T09:36:12.537Z",
 *                  "domainId": "63b676c744ed3b8a72386597",
 *                  "companyId": "63ad46cf6b429daa7aa9b697",
 *                  "deletedAt": null,
 *                  "createdAt": "2023-01-24T09:36:12.539Z",
 *                  "updatedAt": "2023-01-24T09:36:30.789Z",
 *                  "__v": 0,
 *                  "syncEndAt": "2023-01-24T09:36:30.788Z",
 *                  "emailCount": 0
 *              ],
 *          "count":10
 *      }
 * 
 *      @apiError (400)  {String} success   false
 *      @apiError (400)  {Array}  messages "domainId length must be 24 characters long"
 * 
 *      @apiErrorExample Error-Response:
 *         HTTP/1.1 400 Not Found
 *         {
 *           "success": false,
 *           "messages": [
 *               "\"domainId\" length must be 24 characters long"
 *           ]
 *         }
 *
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$query, domainId, _req$query$page, page, _req$query$limit, limit, _req$query$search, search, companyId, condition, regex, count, results, i, emailCount;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$query = req.query, domainId = _req$query.domainId, _req$query$page = _req$query.page, page = _req$query$page === void 0 ? 1 : _req$query$page, _req$query$limit = _req$query.limit, limit = _req$query$limit === void 0 ? 10 : _req$query$limit, _req$query$search = _req$query.search, search = _req$query$search === void 0 ? '' : _req$query$search;
          companyId = req.user.companyId;
          condition = {
            companyId: companyId,
            deletedAt: null
          };
          if (domainId) condition['domainId'] = domainId;
          if (search && search.length) {
            regex = new RegExp(search, "i");
            condition['$or'] = [{
              to: regex
            }, {
              from: regex
            }, {
              subject: regex
            }];
          }
          _context.next = 8;
          return db.AdvanceSearch.countDocuments(condition);
        case 8:
          count = _context.sent;
          _context.next = 11;
          return db.AdvanceSearch.find(condition).sort({
            'createdAt': -1
          }).skip((page - 1) * limit).limit(limit);
        case 11:
          results = _context.sent;
          i = 0;
        case 13:
          if (!(i < results.length)) {
            _context.next = 21;
            break;
          }
          _context.next = 16;
          return db.AdvanceSearchEmail.countDocuments({
            advanceSearchId: results[i]._doc._id
          });
        case 16:
          emailCount = _context.sent;
          results[i] = _objectSpread(_objectSpread({}, results[i]._doc), {}, {
            emailCount: emailCount
          });
        case 18:
          i++;
          _context.next = 13;
          break;
        case 21:
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            results: results,
            count: count
          }));
        case 24:
          _context.prev = 24;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 28:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 24]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-ADVS"), (0, _permission.permission)('AdvancedSearch', 'Read'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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