"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _credentials = _interopRequireDefault(require("../../service/credentials"));
var _moveEmailOutlook = _interopRequireDefault(require("../../service/move-email-outlook"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
// Validator for the request body
var validator = _joi["default"].object().keys({
  emails: _joi["default"].array().items(_joi["default"].object({
    email: _joi["default"].string().email().required(),
    messageId: _joi["default"].string().required()
  })).required(),
  domainId: _joi["default"].string().required()
});

/**
 * @api {post} /api/v1/advance-search/move-to-deleted Move Outlook Mails to DeletedItems
 * @apiName move-to-deleted
 * @apiGroup AdvanceSearch
 * @apiDescription Move Outlook mails to DeletedItems folder (Trash)
 *
 * @apiBody {Array} emails Array of objects with user email and messageId
 *
 * @apiSuccess {Boolean} success true
 * @apiSuccess {String} message Success message
 *
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *     {
 *         "success": true,
 *         "message": "Mails moved to DeletedItems successfully!"
 *     }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, emails, domainId, companyId, emailMap, _iterator, _step, item, allBatches, _yield$Credentials$ge, token, email, _iterator2, _step2, messageId, responses, i, batch, result;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, emails = _req$body.emails, domainId = _req$body.domainId;
          console.log('Move to deleted emails:', emails, 'for domain:', domainId);
          companyId = req.user.companyId;
          console.log("Company ID:", companyId);
          if (!(!emails || !emails.length)) {
            _context.next = 7;
            break;
          }
          return _context.abrupt("return", res.status(400).json({
            success: false,
            message: 'No emails provided.'
          }));
        case 7:
          // Group by user email for batching tokens
          emailMap = {};
          _iterator = _createForOfIteratorHelper(emails);
          try {
            for (_iterator.s(); !(_step = _iterator.n()).done;) {
              item = _step.value;
              if (!emailMap[item.email]) emailMap[item.email] = [];
              emailMap[item.email].push(item.messageId);
            }
          } catch (err) {
            _iterator.e(err);
          } finally {
            _iterator.f();
          }
          allBatches = []; // Get token for domain first to fail early if credentials are invalid
          _context.next = 13;
          return _credentials["default"].getCredentials(companyId, domainId);
        case 13:
          _yield$Credentials$ge = _context.sent;
          token = _yield$Credentials$ge.token;
          console.log(token);
          for (email in emailMap) {
            // Prepare batches for this user
            _iterator2 = _createForOfIteratorHelper(emailMap[email]);
            try {
              for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
                messageId = _step2.value;
                allBatches.push({
                  id: "".concat(email, "_").concat(messageId),
                  email: email,
                  token: token.access_token,
                  messageId: messageId
                });
              }
            } catch (err) {
              _iterator2.e(err);
            } finally {
              _iterator2.f();
            }
          }

          // Batch in groups of 20 for Outlook API
          responses = [];
          i = 0;
        case 19:
          if (!(i < allBatches.length)) {
            _context.next = 28;
            break;
          }
          batch = allBatches.slice(i, i + 20);
          _context.next = 23;
          return _moveEmailOutlook["default"].processMoveEmailTrash(batch);
        case 23:
          result = _context.sent;
          responses.push(result);
        case 25:
          i += 20;
          _context.next = 19;
          break;
        case 28:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: 'Mails moved to DeletedItems successfully!'
          }));
        case 31:
          _context.prev = 31;
          _context.t0 = _context["catch"](0);
          console.log('Move to deleted error:', _context.t0);
          next(_context.t0);
        case 35:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 31]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, _strategy.checkLicenseStrategy, (0, _permission.permission)('Emails', 'Delete'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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