"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _kue = require("../../kue");
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _sanitizer = require("../../middlewares/sanitizer");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  from: _joi["default"].string().email().required(),
  to: _joi["default"].string().email().optional().allow(null).empty(''),
  subject: _joi["default"].string().optional().allow(null).empty(''),
  fromDate: _joi["default"].date().iso().required(),
  toDate: _joi["default"].date().iso().required(),
  domainId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/advance-search/search search
 * @apiName search
 * @apiGroup Advance Search
 * @apiDescription Make a search for mail by someone between two dates with a particular subject
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String}  from        Email of sender
 * @apiBody {String}  [to]        Email of reciever
 * @apiBody {String}  subject     Subject of mail
 * @apiBody {String}  fromDate    Start date of search
 * @apiBody {String}  toDate      End date of search
 * @apiBody {String}  domainId    Domain id in which search is to be done
 *
 * 
 * @apiSuccess {Boolean} Success   true
 * @apiSuccess {String}  message   Searching start successfully
 *  
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "message": "Searching start successfully"
 *       }
 * 
 *  @apiError (400)  {Boolean} success-1    false
 *  @apiError (400)  {Array}  messages-1   invalid domain recieved
 *  @apiError (400)  {Boolean} success-2    false
 *  @apiError (400)  {Array}  messages-2   "subject" is not allowed to be empty
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 400 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *               "invalid domain recieved"
 *           ]
 *       }
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 400 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *              "\"subject\" is not allowed to be empty"
 *           ]
 *       }
 */

var getFilter = function getFilter(body, type) {
  var fromDate = body.fromDate,
    toDate = body.toDate,
    from = body.from,
    subject = body.subject,
    _body$filter = body.filter,
    filter = _body$filter === void 0 ? "" : _body$filter;
  if (type == 'Outlook') {
    fromDate = new Date(fromDate);
    fromDate.setDate(fromDate.getDate());
    fromDate = fromDate.toISOString().split('T')[0] + "T00:00:00Z";
    toDate = new Date(toDate);
    toDate.setDate(toDate.getDate());
    toDate = toDate.toISOString().split('T')[0] + "T23:59:59Z";
    if (from) {
      filter += " and from/emailAddress/address eq '".concat(from, "'");
    }
    if (subject) {
      filter += " and subject eq '".concat(subject, "'");
    }
    if (fromDate) {
      filter += " and receivedDateTime ge ".concat(fromDate);
    }
    if (toDate) {
      filter += " and receivedDateTime le ".concat(toDate);
    }
    filter = "&$filter=" + filter.slice(5);
    return filter;
  } else {
    if (from) {
      filter += "from:".concat(from, " ");
    }
    if (subject) {
      filter += "subject:".concat(subject, " ");
    }
    fromDate = new Date(fromDate);
    fromDate.setDate(fromDate.getDate());
    fromDate = fromDate.toISOString().split('T')[0];
    toDate = new Date(toDate);
    toDate.setDate(toDate.getDate() + 1);
    toDate = toDate.toISOString().split('T')[0];
    filter += "after:".concat(fromDate, " ");
    filter += "before:".concat(toDate);
    return filter;
  }
};
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, _req$body, domainId, from, to, subject, fromDate, toDate, domain, filter, advanceSearch;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _req$body = req.body, domainId = _req$body.domainId, from = _req$body.from, to = _req$body.to, subject = _req$body.subject, fromDate = _req$body.fromDate, toDate = _req$body.toDate;
          _context.next = 5;
          return db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
        case 5:
          domain = _context.sent;
          if (domain) {
            _context.next = 8;
            break;
          }
          throw new RequestError('invalid domain recieved');
        case 8:
          if (!(domain.domainType == 'Gsuite' || domain.domainType == 'Outlook')) {
            _context.next = 20;
            break;
          }
          if (!domain.isCredential) {
            _context.next = 17;
            break;
          }
          filter = getFilter(req.body, domain.domainType);
          _context.next = 13;
          return db.AdvanceSearch.create({
            domainId: domainId,
            companyId: companyId,
            from: from,
            to: to,
            subject: subject,
            filter: filter,
            fromDate: fromDate,
            toDate: toDate,
            syncStartAt: new Date()
          });
        case 13:
          advanceSearch = _context.sent;
          if (domain.domainType == 'Gsuite') {
            _kue.queue.create('process-advanced-search-gsuite', {
              domainId: domainId,
              companyId: companyId,
              from: from,
              to: to,
              subject: subject,
              filter: filter,
              advanceSearchId: advanceSearch._id,
              fromDate: fromDate,
              toDate: toDate
            }).removeOnComplete(true).priority('high').save();
          } else {
            _kue.queue.create('process-advanced-search-outlook', {
              domainId: domainId,
              companyId: companyId,
              from: from,
              to: to,
              subject: subject,
              filter: filter,
              advanceSearchId: advanceSearch._id,
              fromDate: fromDate,
              toDate: toDate
            }).removeOnComplete(true).priority('high').save();
          }
          _context.next = 18;
          break;
        case 17:
          throw new RequestError('Domain Credentials not uploaded properly please upload and try again.');
        case 18:
          _context.next = 21;
          break;
        case 20:
          throw new RequestError('Domain type not define');
        case 21:
          _auditLog["default"].create(req, 'Advanced Search', "from: ".concat(from, ", subject: ").concat(subject));
          logger.info("User ".concat(req.user.email, " proceed Advanced Search"), {
            client: req.user.companyId,
            request: req,
            event: 'Advanced Search'
          });
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: 'Searching start successfully'
          }));
        case 26:
          _context.prev = 26;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 30:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 26]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-ADVS"), _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('AdvancedSearch', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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