"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var validator = _joi["default"].object().keys({
  page: _joi["default"].number().min(0).required(),
  limit: _joi["default"].number().min(1).required()
});

/**
 * @api {post} /api/v1/hack-record/get get
 * @apiName get-hackrecord
 * @apiGroup Hack Record
 * @apiDescription Get hack records
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}  email   Required Email whose hack records are to be fetched 
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  message    []
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "results": "[]"
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    results    []
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "Request failed with status code 500"
 *          ]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, _req$query, _req$query$page, page, _req$query$limit, limit, count, results;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          companyId = req.user.companyId;
          _req$query = req.query, _req$query$page = _req$query.page, page = _req$query$page === void 0 ? 1 : _req$query$page, _req$query$limit = _req$query.limit, limit = _req$query$limit === void 0 ? 10 : _req$query$limit;
          _context.next = 4;
          return db.AuditLog.countDocuments({
            companyId: companyId
          });
        case 4:
          count = _context.sent;
          _context.next = 7;
          return db.AuditLog.find({
            companyId: companyId
          }).sort({
            'createdAt': -1
          }).skip((page - 1) * limit).limit(limit);
        case 7:
          results = _context.sent;
          return _context.abrupt("return", res.status(200).send({
            Success: true,
            results: results,
            count: count
          }));
        case 9:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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