"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _permission = require("../../middlewares/permission");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _scheduler = _interopRequireDefault(require("../../utils/scheduler"));
var validator = _joi["default"].object({
  isActive: _joi["default"]["boolean"]().required(),
  domainId: _joi["default"].string().hex().length(24).required(),
  days: _joi["default"].alternatives().conditional('isActive', {
    is: true,
    then: _joi["default"].array().items(_joi["default"].string()).required(),
    otherwise: _joi["default"].any().strip()
  }),
  hour: _joi["default"].alternatives().conditional('isActive', {
    is: true,
    then: _joi["default"].string().required(),
    otherwise: _joi["default"].any().strip()
  }),
  minute: _joi["default"].alternatives().conditional('isActive', {
    is: true,
    then: _joi["default"].string().required(),
    otherwise: _joi["default"].any().strip()
  }),
  timeZone: _joi["default"].alternatives().conditional('isActive', {
    is: true,
    then: _joi["default"].string().required(),
    otherwise: _joi["default"].any().strip()
  }),
  syncType: _joi["default"].alternatives().conditional('isActive', {
    is: true,
    then: _joi["default"].string().valid('allUsers', 'specificGroups').required(),
    otherwise: _joi["default"].any().strip()
  }),
  groupIds: _joi["default"].alternatives().conditional('isActive', {
    is: true,
    then: _joi["default"].array().allow(null),
    otherwise: _joi["default"].any().strip()
  }),
  isUserSyncMirrored: _joi["default"].alternatives().conditional('isActive', {
    is: true,
    then: _joi["default"]["boolean"]().required(),
    otherwise: _joi["default"].any().strip()
  })
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, isActive, domainId, _req$body$days, days, hour, minute, timeZone, syncType, _req$body$groupIds, groupIds, isUserSyncMirrored, companyId;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _req$body = req.body, isActive = _req$body.isActive, domainId = _req$body.domainId, _req$body$days = _req$body.days, days = _req$body$days === void 0 ? [] : _req$body$days, hour = _req$body.hour, minute = _req$body.minute, timeZone = _req$body.timeZone, syncType = _req$body.syncType, _req$body$groupIds = _req$body.groupIds, groupIds = _req$body$groupIds === void 0 ? [] : _req$body$groupIds, isUserSyncMirrored = _req$body.isUserSyncMirrored;
          companyId = req.user.companyId;
          _context.prev = 2;
          _context.next = 5;
          return db.Domain.updateOne({
            _id: domainId,
            companyId: companyId
          }, {
            isScheduledSyncing: {
              isActive: isActive,
              daysOfWeek: days,
              hour: hour,
              minute: minute,
              syncType: syncType,
              timeZone: timeZone,
              groupIds: groupIds,
              lastSync: null,
              isUserSyncMirrored: isUserSyncMirrored
            }
          });
        case 5:
          if (isActive) {
            _context.next = 8;
            break;
          }
          _scheduler["default"].cancelScheduledJob(domainId);
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: 'Scheduled syncing disabled!'
          }));
        case 8:
          _context.next = 10;
          return _scheduler["default"].scheduleDomainAutoSyncSetting({
            domainId: domainId,
            companyId: companyId,
            days: days,
            hour: hour,
            minute: minute,
            timeZone: timeZone,
            syncType: syncType,
            groupIds: groupIds,
            isUserSyncMirrored: isUserSyncMirrored
          });
        case 10:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: 'Auto Sync scheduled successfully'
          }));
        case 13:
          _context.prev = 13;
          _context.t0 = _context["catch"](2);
          next(_context.t0);
        case 16:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[2, 13]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, _strategy.checkTaConnectionStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Users', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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