"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _awsSdk = require("aws-sdk");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  page: _joi["default"].number().min(0).required(),
  limit: _joi["default"].number().min(1).required(),
  domainId: _joi["default"].string().hex().length(24).optional(),
  search: _joi["default"].string().optional().allow(null).empty(''),
  isTrashedEmail: _joi["default"]["boolean"]().required(),
  isRecoveredEmail: _joi["default"]["boolean"]().required(),
  isDeletedEmail: _joi["default"]["boolean"]().required(),
  last15: _joi["default"].required(),
  last30: _joi["default"].required(),
  custom: _joi["default"]["boolean"]().required(),
  toDate: _joi["default"].date().required(),
  fromDate: _joi["default"].date().required(),
  mailType: _joi["default"].string().optional().allow(null).empty('')
});

/**
 * @api {post} /api/reported-email/list list
 * @apiName list
 * @apiGroup Report
 * @apiDescription list of all reported mails of a particular domain or all domains
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {Boolean}    success                 true
 * @apiSuccess {Object}     reportedEmails          Object of all reported mails
 * @apiSuccess {Number}     countReportedEmails     count of reported mails returned
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * 
 *   {
 *     "success":true,
 *     "reportedEmail":
 *      {"_id":"63d0f16c78b9830aa47b3024",
 *      "from":"sarvesh.patel@kratikal.com",
 *      "fromName":"Sarvesh Patel",
 *      "to":"arpit@kdmarc.com",
 *      "toName":"",
 *      "otherTo":[{"address":"arpit@kdmarc.com","name":""}]} .....
 *  }

 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$query, domainId, _req$query$page, page, _req$query$limit, limit, _req$query$search, search, _req$query$isRecovere, isRecoveredEmail, _req$query$isTrashedE, isTrashedEmail, _req$query$isDeletedE, isDeletedEmail, mailType, last15, last30, custom, toDate, fromDate, companyId, domainsOfCurrentCompany, company, uniqueDomains, idOfOutlookOrGsuite, idOfExchange, broadcastThreshold, reporterExpression, condition, regex, countReportedEmails, reportedEmails;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$query = req.query, domainId = _req$query.domainId, _req$query$page = _req$query.page, page = _req$query$page === void 0 ? 1 : _req$query$page, _req$query$limit = _req$query.limit, limit = _req$query$limit === void 0 ? 10 : _req$query$limit, _req$query$search = _req$query.search, search = _req$query$search === void 0 ? '' : _req$query$search, _req$query$isRecovere = _req$query.isRecoveredEmail, isRecoveredEmail = _req$query$isRecovere === void 0 ? false : _req$query$isRecovere, _req$query$isTrashedE = _req$query.isTrashedEmail, isTrashedEmail = _req$query$isTrashedE === void 0 ? false : _req$query$isTrashedE, _req$query$isDeletedE = _req$query.isDeletedEmail, isDeletedEmail = _req$query$isDeletedE === void 0 ? false : _req$query$isDeletedE, mailType = _req$query.mailType, last15 = _req$query.last15, last30 = _req$query.last30, custom = _req$query.custom, toDate = _req$query.toDate, fromDate = _req$query.fromDate;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.Domain.find({
            companyId: companyId,
            deletedAt: null
          }).select("domainName domainType domainTypeForOutlook");
        case 5:
          domainsOfCurrentCompany = _context.sent;
          _context.next = 8;
          return db.Company.findById(companyId);
        case 8:
          company = _context.sent;
          uniqueDomains = new Set();
          domainsOfCurrentCompany.map(function (currentDomain) {
            uniqueDomains.add(currentDomain);
          });
          idOfOutlookOrGsuite = [];
          idOfExchange = [];
          domainsOfCurrentCompany.map(function (value) {
            if (value.domainType === "Gsuite") {
              idOfOutlookOrGsuite.push(value._id);
            } else if (value.domainType === "Outlook") {
              if (value.domainTypeForOutlook === "EXCHANGE") {
                idOfExchange.push(value._id);
              } else {
                idOfOutlookOrGsuite.push(value._id);
              }
            }
          });
          domainsOfCurrentCompany = (0, _toConsumableArray2["default"])(uniqueDomains);
          domainsOfCurrentCompany = domainsOfCurrentCompany.map(function (value) {
            return value._id;
          });
          if (!(company.broadcastThreshold == 0)) {
            _context.next = 18;
            break;
          }
          return _context.abrupt("return", res.status(200).json({
            success: true,
            reportedEmails: [],
            countReportedEmails: 0
          }));
        case 18:
          broadcastThreshold = company.broadcastThreshold != 0 ? company.broadcastThreshold - 1 : 0;
          reporterExpression = broadcastThreshold == 0 ? {} : {
            $gte: [{
              $size: {
                $ifNull: ["$reporters", []]
              }
            }, broadcastThreshold]
          };
          condition = {
            companyId: companyId,
            isRecoveredEmail: false,
            isTrashedEmail: {
              $in: ["true", "false"]
            },
            isDeletedEmail: {
              $in: ["true", "false"]
            },
            mailType: {
              $in: ["Outlook", "Gsuite", "Exchange"]
            },
            domainId: {
              $in: [].concat(idOfExchange, idOfOutlookOrGsuite)
            },
            $expr: reporterExpression,
            deletedAt: null,
            isBroadcastMail: false
          };
          if (domainId) {
            condition['domainId'] = domainId;
          }
          if (mailType) {
            condition['mailType'] = mailType;
          }
          if (last15 !== 'false') {
            condition['createdAt'] = {
              $gte: new Date(+last15)
            };
          }
          if (last30 !== 'false') {
            condition['createdAt'] = {
              $gte: new Date(+last30)
            };
          }
          if (custom !== 'false') {
            condition['createdAt'] = {
              $gte: new Date(fromDate),
              $lte: new Date(toDate)
            };
          }
          if (search && search.length) {
            regex = new RegExp(search, "i");
            condition['$or'] = [{
              to: regex
            }, {
              from: regex
            }, {
              subject: regex
            }];
          }
          console.log({
            condition: condition
          });
          _context.next = 30;
          return db.ReportedMail.countDocuments(condition);
        case 30:
          countReportedEmails = _context.sent;
          _context.next = 33;
          return db.ReportedMail.find(condition).select('-header -body -messageId -mailId').sort({
            'createdAt': -1
          }).skip((page - 1) * limit).limit(limit);
        case 33:
          reportedEmails = _context.sent;
          console.log({
            countReportedEmails: countReportedEmails
          });
          res.status(200).json({
            success: true,
            reportedEmails: reportedEmails,
            countReportedEmails: countReportedEmails,
            broadcastThreshold: company.broadcastThreshold
          });
          _context.next = 42;
          break;
        case 38:
          _context.prev = 38;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 42:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 38]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-EB"), (0, _permission.permission)('Emails', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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