"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _kue = require("../../kue");
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
var validator = _joi["default"].object().keys({
  mailIds: _joi["default"].array().required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var mailIds, companyId, isAlreadyBroadcasted, singleMailId, MailAlreadySent;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          mailIds = req.body.mailIds;
          companyId = req.user.companyId;
          _context.prev = 3;
          if (!(mailIds.length == 1)) {
            _context.next = 10;
            break;
          }
          singleMailId = mailIds[0];
          _context.next = 8;
          return db.ReportedMail.findOne({
            _id: singleMailId
          });
        case 8:
          MailAlreadySent = _context.sent;
          isAlreadyBroadcasted = MailAlreadySent.isBroadcastMail;
        case 10:
          mailIds.map(function (id) {
            _kue.queue.create('broadcast-reported-mails', {
              mailIds: [id],
              companyId: companyId
            }).removeOnComplete(true).priority('high').save();
          });
          res.status(200).send({
            isAlreadyBroadcasted: isAlreadyBroadcasted,
            message: 'Broadcast emails sent successfully.'
          });
          _context.next = 18;
          break;
        case 14:
          _context.prev = 14;
          _context.t0 = _context["catch"](3);
          console.error("Error in sending broadcast emails: ".concat(_context.t0));
          res.status(500).send({
            error: 'Internal server error'
          });
        case 18:
          _context.next = 24;
          break;
        case 20:
          _context.prev = 20;
          _context.t1 = _context["catch"](0);
          console.log(_context.t1);
          next(_context.t1);
        case 24:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 20], [3, 14]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, (0, _featureBlocker["default"])("TPIR-EB"), (0, _permission.permission)('Emails', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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