"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var validator = _joi["default"].object().keys({
  domainId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/domain/domain-delete?domainId=63b676c744ed3b8a72386597 domain-delete
 * @apiName domain-delete
 * @apiGroup Domains
 * @apiDescription Delete a domain
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {String}  domainId   id of the domain
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  message    Credentials deleted successfully.
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "message": "Credentials deleted successfully."
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    messages   Invalid domain recieved
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *                "Invalid domain recieved"
 *           ]
 *       }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var domainId, companyId, domain;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          domainId = req.query;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
        case 5:
          domain = _context.sent;
          if (domain) {
            _context.next = 8;
            break;
          }
          throw new RequestError('Invalid domain recieved');
        case 8:
          _context.next = 10;
          return db.Domain.findOneAndUpdate({
            _id: domainId,
            companyId: companyId
          }, {
            isCredential: false
          });
        case 10:
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: 'Credentials deleted successfully.'
          }));
        case 13:
          _context.prev = 13;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(new RequestError(_context.t0));
        case 17:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 13]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/')["delete"](_strategy.jwtStrategy, _strategy.checkTaConnectionStrategy, (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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