"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _functions = require("../../functions");
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  domainName: _joi["default"].string().regex(/^[a-zA-Z0-9][a-zA-Z0-9-]{1,61}[a-zA-Z0-9](?:\.[a-zA-Z]{2,})+$/).required(),
  domainType: _joi["default"].any().valid('Gsuite', 'Outlook'),
  domainTypeForOutlook: _joi["default"].any().valid('OFFICE365', 'EXCHANGE', 'null'),
  groups: _joi["default"].array()
});

/**
 * @api {post} /api/v1/domain/domain-create domain-create
 * @apiName domain-create
 * @apiGroup Domains
 * @apiDescription create a new domain
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody {String}                  domainName        Name of domain
 * @apiBody {String= Gsuite,Outlook}  domainType        Type of domain
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  txtRecord  txtRecord to be added in dns for verification
 * @apiSuccess {String}  domainId   id of domain created
 * @apiSuccess {String}  message    domain added successfully
  
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "message": "Searching start successfully"
 *       }
 * 
 *  @apiError (400)  {Boolean} success-1     false
 *  @apiError (400)  {Array}   messages-1    same domain already exists try with different domain name
 *  @apiError (500)  {Boolean} success-2     false
 *  @apiError (500)  {Array}   messages-2    domainType must be one of [Gsuite, Outlook]
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 400 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *               "same domain already exists try with different domain name"
 *           ]
 *       }
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *                "\"domainType\" must be one of [Gsuite, Outlook]"
 *           ]
 *       }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(req, res, next) {
    var _req$body, domainType, domainName, domainTypeForOutlook, groups, companyId, domain, txtRecord, isDeletedDomain;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          _context3.prev = 0;
          _req$body = req.body, domainType = _req$body.domainType, domainName = _req$body.domainName, domainTypeForOutlook = _req$body.domainTypeForOutlook, groups = _req$body.groups;
          companyId = req.user.companyId;
          _context3.next = 5;
          return db.Domain.findOne({
            domainName: domainName.toLowerCase(),
            domainType: domainType,
            domainTypeForOutlook: domainTypeForOutlook == 'null' || null ? "null" : domainTypeForOutlook,
            deletedAt: null
          });
        case 5:
          domain = _context3.sent;
          if (!(domainType == 'Outlook')) {
            _context3.next = 11;
            break;
          }
          if (!(domain && domainTypeForOutlook == domain.domainTypeForOutlook)) {
            _context3.next = 9;
            break;
          }
          throw new RequestError('same domain already exists try with different domain name');
        case 9:
          _context3.next = 13;
          break;
        case 11:
          if (!(domain && domainType == domain.domainType)) {
            _context3.next = 13;
            break;
          }
          throw new RequestError('same domain already exists try with different domain name');
        case 13:
          // if(domain){
          //     throw new RequestError('same domain already exists try with different domain name');
          // }
          // const addedDomains = await db.Domain.countDocuments({ companyId, deletedAt: null });
          // const domainLimit = await db.MetaData.findOne({ companyId, name: "domainLimit" })
          // if(!domainLimit) throw new RequestError('License Key not updated, Check License Key!');
          // if(!(+domainLimit.value > addedDomains)) throw new RequestError(`Domain Limit Exceeded! Only ${+domainLimit.value} domain(s) are granted as per your license!` ); 
          txtRecord = "tab-site-verification=".concat((0, _functions.randomString)(40));
          _context3.next = 16;
          return db.Domain.findOne({
            domainName: domainName,
            deletedAt: {
              $ne: null
            }
          }, {
            _id: 1
          });
        case 16:
          isDeletedDomain = _context3.sent;
          if (!(isDeletedDomain !== null)) {
            _context3.next = 25;
            break;
          }
          _context3.next = 20;
          return db.Domain.updateOne({
            _id: isDeletedDomain._id
          }, {
            domainType: domainType,
            deletedAt: null,
            isVerified: true,
            domainTypeForOutlook: domainTypeForOutlook,
            isCredential: false,
            credential: null,
            companyId: companyId
          });
        case 20:
          domain = _context3.sent;
          if (groups && groups.length >= 1) groups.forEach( /*#__PURE__*/function () {
            var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(group) {
              return _regenerator["default"].wrap(function _callee$(_context) {
                while (1) switch (_context.prev = _context.next) {
                  case 0:
                    _context.next = 2;
                    return db.SubDomainGroup.create({
                      groupName: group,
                      companyId: companyId,
                      domainId: isDeletedDomain._id
                    });
                  case 2:
                    return _context.abrupt("return", _context.sent);
                  case 3:
                  case "end":
                    return _context.stop();
                }
              }, _callee);
            }));
            return function (_x4) {
              return _ref2.apply(this, arguments);
            };
          }());
          domain._id = isDeletedDomain._id;
          _context3.next = 35;
          break;
        case 25:
          if (!(domainType == 'Gsuite')) {
            _context3.next = 31;
            break;
          }
          _context3.next = 28;
          return db.Domain.create({
            domainName: domainName,
            companyId: companyId,
            txtRecord: txtRecord,
            domainType: domainType,
            isVerified: true,
            domainTypeForOutlook: null
          });
        case 28:
          domain = _context3.sent;
          _context3.next = 34;
          break;
        case 31:
          _context3.next = 33;
          return db.Domain.create({
            domainName: domainName,
            companyId: companyId,
            txtRecord: txtRecord,
            domainType: domainType,
            isVerified: true,
            domainTypeForOutlook: domainTypeForOutlook,
            isCredential: false
          });
        case 33:
          domain = _context3.sent;
        case 34:
          if (groups && groups.length >= 1) groups.forEach( /*#__PURE__*/function () {
            var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(group) {
              return _regenerator["default"].wrap(function _callee2$(_context2) {
                while (1) switch (_context2.prev = _context2.next) {
                  case 0:
                    _context2.next = 2;
                    return db.SubDomainGroup.create({
                      groupName: group,
                      companyId: companyId,
                      domainId: domain._id
                    });
                  case 2:
                    return _context2.abrupt("return", _context2.sent);
                  case 3:
                  case "end":
                    return _context2.stop();
                }
              }, _callee2);
            }));
            return function (_x5) {
              return _ref3.apply(this, arguments);
            };
          }());
        case 35:
          _auditLog["default"].create(req, 'Create Domain', domainName);
          logger.info("User ".concat(req.user.email, " proceed Create Domain"), {
            client: req.user.companyId,
            request: req,
            event: 'Create Domain'
          });
          res.status(200).json({
            success: true,
            txtRecord: txtRecord,
            domainId: domain._id,
            message: 'domain added successfully'
          });
          _context3.next = 44;
          break;
        case 40:
          _context3.prev = 40;
          _context3.t0 = _context3["catch"](0);
          console.log(_context3.t0);
          next(_context3.t0);
        case 44:
        case "end":
          return _context3.stop();
      }
    }, _callee3, null, [[0, 40]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Domain', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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