"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _path = _interopRequireDefault(require("path"));
var _multer = _interopRequireDefault(require("multer"));
var _express = _interopRequireDefault(require("express"));
var _credentials = require("../../service/credentials");
var _permission = require("../../middlewares/permission");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _scanAndUploadFile = require("../../middlewares/scanAndUploadFile");
var credentialFilePath = _path["default"].join(_path["default"].dirname(require.main.filename), 'Content', 'Credentials');
var storage = _multer["default"].diskStorage({
  destination: function destination(req, file, cb) {
    cb(null, credentialFilePath);
  },
  filename: function filename(req, file, cb) {
    cb(null, Date.now() + _path["default"].extname(file.originalname));
  }
});
var uploadAttachment = (0, _multer["default"])({
  storage: storage,
  limits: {
    fileSize: 10485760
  }
});
var validator = _joi["default"].object().keys({
  domainId: _joi["default"].string().hex().length(24).required(),
  adminEmail: _joi["default"].string().email().required(),
  file: _joi["default"].string().optional().allow(null).empty('')
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, domainId, adminEmail, fileName, domain, credential, _yield$fromGsuite, service, _fileName;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, domainId = _req$body.domainId, adminEmail = _req$body.adminEmail;
          fileName = req.file ? req.file.filename : null;
          _context.next = 5;
          return db.Domain.findOne({
            _id: domainId,
            companyId: req.user.companyId,
            deletedAt: null
          });
        case 5:
          domain = _context.sent;
          if (domain) {
            _context.next = 8;
            break;
          }
          throw new RequestError('Domain does not exist or wrong domain id passed!', 404);
        case 8:
          if (fileName) {
            _context.next = 10;
            break;
          }
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: "No File Uploaded. Credentials not updated!"
          }));
        case 10:
          if (domain.isVerified) {
            _context.next = 12;
            break;
          }
          throw new RequestError('Please verify the domain first', 400);
        case 12:
          credential = {
            adminEmail: adminEmail,
            fileName: fileName ? fileName : domain.fileName
          };
          _context.prev = 13;
          _context.next = 16;
          return (0, _credentials.fromGsuite)(credential);
        case 16:
          _yield$fromGsuite = _context.sent;
          service = _yield$fromGsuite.service;
          _fileName = _yield$fromGsuite.fileName;
          if (!(!service && !_fileName)) {
            _context.next = 21;
            break;
          }
          throw new RequestError('Invalid Credentials - Unable to authorize', 400);
        case 21:
          _context.next = 26;
          break;
        case 23:
          _context.prev = 23;
          _context.t0 = _context["catch"](13);
          throw new RequestError('Invalid Credentials - Unable to authorize', 400);
        case 26:
          _context.next = 28;
          return db.Domain.findOneAndUpdate({
            _id: domainId,
            companyId: req.user.companyId
          }, {
            credential: credential,
            isCredential: true
          });
        case 28:
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: "Credentials updated successfully"
          }));
        case 31:
          _context.prev = 31;
          _context.t1 = _context["catch"](0);
          console.log(_context.t1);
          next(_context.t1);
        case 35:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 31], [13, 23]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Domain', 'Write'), uploadAttachment.single('file'), _scanAndUploadFile.scanFile, (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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