"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _crypto = _interopRequireDefault(require("../../crypto"));
var _permission = require("../../middlewares/permission");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _getOutlookToken = _interopRequireDefault(require("../../service/get-outlook-token"));
var validator = _joi["default"].object().keys({
  tenantId: _joi["default"].string().required(),
  clientId: _joi["default"].string().required(),
  clientSecret: _joi["default"].string().required(),
  domainId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/domain/domain-credential-outlook
 * @apiName domain-credential-outlook
 * @apiGroup Domains
 * @apiDescription Upload Outlook Credentials
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}  domainId         id of the domain
 * @apiBody   {String}  tenantId         tenantId of the domain
 * @apiBody   {String}  clientId         clientId of the domain
 * @apiBody   {String}  clientSecret     clientSecret of the domain
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  message    Credentials updated successfully
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "message": "Credentials updated successfully"
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    messages   Invalid domain recieved
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *                "Invalid domain recieved"
 *           ]
 *       }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, domainId, clientId, clientSecret, tenantId, companyId, domain, credential, accessToken;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, domainId = _req$body.domainId, clientId = _req$body.clientId, clientSecret = _req$body.clientSecret, tenantId = _req$body.tenantId;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
        case 5:
          domain = _context.sent;
          if (domain) {
            _context.next = 8;
            break;
          }
          throw new RequestError('Domain does not exist or wrong domain id passed!', 404);
        case 8:
          if (domain.isVerified) {
            _context.next = 10;
            break;
          }
          throw new RequestError('Please verify the domain first', 400);
        case 10:
          credential = {
            clientId: _crypto["default"].encrypt(clientId),
            tenantId: _crypto["default"].encrypt(tenantId),
            clientSecret: _crypto["default"].encrypt(clientSecret)
          }; // validate credentials by trying to get access token
          _context.prev = 11;
          _context.next = 14;
          return _getOutlookToken["default"].getOutlookAuthToken(tenantId, clientId, clientSecret);
        case 14:
          accessToken = _context.sent;
          if (!(!accessToken || !accessToken.access_token)) {
            _context.next = 17;
            break;
          }
          throw new RequestError('Invalid Credentials - Unable to authorize', 400);
        case 17:
          _context.next = 22;
          break;
        case 19:
          _context.prev = 19;
          _context.t0 = _context["catch"](11);
          throw new RequestError('Invalid Credentials - Unable to authorize', 400);
        case 22:
          _context.next = 24;
          return db.Domain.findOneAndUpdate({
            _id: domainId,
            companyId: companyId
          }, {
            credential: credential,
            isCredential: true
          });
        case 24:
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: "Credentials updated successfully"
          }));
        case 27:
          _context.prev = 27;
          _context.t1 = _context["catch"](0);
          console.log(_context.t1);
          next(_context.t1);
        case 31:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 27], [11, 19]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Domain', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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