"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _nodeSchedule = _interopRequireDefault(require("node-schedule"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var validator = _joi["default"].object().keys({
  domainId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/domain/domain-delete?domainId=63b676c744ed3b8a72386597 domain-delete
 * @apiName domain-delete
 * @apiGroup Domains
 * @apiDescription Delete a domain
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {String}  domainId   id of the domain
 * 
 * @apiSuccess {Boolean} Success  true
 * @apiSuccess {String}  message  Domain Deleted Successfully.
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "message": "Domain Deleted successfully"
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    messages   Domain Does not Exists
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *                "Domain Does not Exists"
 *           ]
 *       }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var domainId, companyId, domain, removeAutoSync, groupsOfCompany, groupIds, userCounts, userCountMap, groupsToDelete;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          domainId = req.query.domainId;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
        case 5:
          domain = _context.sent;
          if (domain) {
            _context.next = 8;
            break;
          }
          throw new RequestError('Domain Does not Exists');
        case 8:
          // removing already scheduled job
          removeAutoSync = _nodeSchedule["default"].cancelJob(domainId);
          if (removeAutoSync) {
            console.log("Job with ID ".concat(domainId, " cancelled successfully."));
          } else {
            console.log("No job found with ID ".concat(domainId, "."));
          }
          domain.deletedAt = new Date();
          domain.isSyncingUser = false;
          domain.isSyncingUserError = false;
          domain.isSyncingUserErrorFile = null;
          domain.isGroupSyncEnabled = false;
          domain.groups = [];
          domain.subDomaingroups = [];
          domain.isScheduledSyncing = {
            isActive: false,
            daysOfWeek: [],
            hour: null,
            minute: null,
            syncType: "All Users",
            timeZone: null,
            groupIds: [],
            lastSync: null
          };
          domain.lastAllUsersSyncAt = null;
          _context.next = 21;
          return domain.save();
        case 21:
          _context.next = 23;
          return db.SubDomainGroup.deleteMany({
            domainId: domainId,
            companyId: companyId
          });
        case 23:
          _context.next = 25;
          return db.UserGroup.deleteMany({
            domainId: domainId,
            companyId: companyId
          });
        case 25:
          _context.next = 27;
          return db.User.deleteMany({
            domainId: domainId,
            deletedAt: null
          });
        case 27:
          _context.next = 29;
          return db.Group.find({
            deletedAt: null,
            companyId: companyId,
            isDefaultGroup: false,
            groupName: {
              $ne: "Individual-Users"
            }
          });
        case 29:
          groupsOfCompany = _context.sent;
          if (!(groupsOfCompany.length > 0)) {
            _context.next = 40;
            break;
          }
          // Getting all group IDs
          groupIds = groupsOfCompany.map(function (group) {
            return group._id;
          }); // Getting user counts for each group in a single query
          _context.next = 34;
          return db.User.aggregate([{
            $match: {
              companyId: companyId,
              deletedAt: null,
              groups: {
                $in: groupIds
              }
            }
          }, {
            $unwind: "$groups"
          }, {
            $match: {
              groups: {
                $in: groupIds
              }
            }
          }, {
            $group: {
              _id: "$groups",
              count: {
                $sum: 1
              }
            }
          }]);
        case 34:
          userCounts = _context.sent;
          // Creating a map of group ID to user count
          userCountMap = userCounts.reduce(function (acc, curr) {
            acc[curr._id.toString()] = curr.count;
            return acc;
          }, {}); // Finding groups with zero users and delete them
          groupsToDelete = groupsOfCompany.filter(function (group) {
            return !userCountMap[group._id.toString()];
          }).map(function (group) {
            return group._id;
          });
          if (!(groupsToDelete.length > 0)) {
            _context.next = 40;
            break;
          }
          _context.next = 40;
          return db.Group.deleteMany({
            _id: {
              $in: groupsToDelete
            },
            companyId: companyId
          });
        case 40:
          return _context.abrupt("return", res.status(200).send({
            succees: true,
            message: "Domain Deleted Successfully."
          }));
        case 43:
          _context.prev = 43;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 47:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 43]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/')["delete"](_strategy.jwtStrategy, _strategy.checkTaConnectionStrategy, (0, _permission.permission)('Domain', 'Delete'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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