"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var validator = _joi["default"].object().keys({
  domainId: _joi["default"].string().hex().length(24).required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var domainId, companyId, domain, subDomainGroups, groups;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          domainId = req.query.domainId;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
        case 5:
          domain = _context.sent;
          _context.next = 8;
          return db.SubDomainGroup.find({
            domainId: domain._id,
            companyId: companyId
          }, {
            _id: 0,
            groupName: 1
          });
        case 8:
          subDomainGroups = _context.sent;
          domain = _objectSpread(_objectSpread({}, domain.toObject()), {}, {
            subDomainGroups: subDomainGroups && subDomainGroups.length ? subDomainGroups.map(function (group) {
              return group.groupName;
            }) : []
          });
          _context.next = 12;
          return db.UserGroup.find({
            domainId: domain._id,
            companyId: companyId
          }, {
            label: 1,
            value: 1,
            _id: 0
          });
        case 12:
          groups = _context.sent;
          domain = _objectSpread(_objectSpread({}, domain), {}, {
            groups: groups
          });
          res.status(200).json({
            success: true,
            domain: domain
          });
          _context.next = 21;
          break;
        case 17:
          _context.prev = 17;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 21:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 17]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, (0, _permission.permission)('Domain', 'Read'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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