"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
/**
 * @api {get} /api/v1/domain/domain-list domain-list
 * @apiName domain-list
 * @apiGroup Domains
 * @apiDescription Returns a list of all domains of a user's company without active and total users for dropdown in different pages
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {Array}   domains    list of all domains
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {    
 *         "success": true,
 *         "domains": [
 *             {
 *                 "_id": "63d0eaaa032f943fc31e4ea2",
 *                 "domainName": "kdmarc.com",
 *                 "txtRecord": "tab-site-verification=W7CIoMg0Bitq6hahLZ4pW8aL6h4I23DLTHV88cFj",
 *                 "isVerified": true,
 *                 "companyId": "63d0ea61032f943fc31e4e80",
 *                 "domainType": "Outlook",
 *                 "isCredential": true,
 *                 "isSyncingUser": false,
 *                 "deletedAt": null,
 *                 "createdAt": "2023-01-25T08:39:06.842Z",
 *                 "updatedAt": "2023-01-25T09:00:27.078Z",
 *                 "__v": 0,
 *                 "syncStartAt": "2023-01-25T09:00:25.226Z",
 *                 "syncEndAt": "2023-01-25T09:00:27.077Z",
 *             },
 *             {
 *                 "_id": "63d0f49e4b01a8cf9308bf00",
 *                 "domainName": "kratikal.com",
 *                 "txtRecord": "tab-site-verification=J6oFlCGhQzEWZKVgHqQGywiru4gslcxDgCBEWWrQ",
 *                 "isVerified": false,
 *                 "companyId": "63d0ea61032f943fc31e4e80",
 *                 "domainType": "Outlook",
 *                 "isCredential": false,
 *                 "isSyncingUser": false,
 *                 "deletedAt": null,
 *                 "createdAt": "2023-01-25T09:21:34.965Z",
 *                 "updatedAt": "2023-01-25T09:21:34.965Z",
 *                 "__v": 0,
 *             }
 *         ]
 *      }
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, domains;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _context.next = 4;
          return db.Domain.find({
            companyId: companyId,
            deletedAt: null
          }).select('-credential');
        case 4:
          domains = _context.sent;
          res.status(200).json({
            success: true,
            domains: domains
          });
          _context.next = 12;
          break;
        case 8:
          _context.prev = 8;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 12:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 8]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, (0, _permission.permission)('Domain', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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