"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _nodeDns = _interopRequireDefault(require("node:dns"));
var _express = _interopRequireDefault(require("express"));
var _permission = require("../../middlewares/permission");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var validator = _joi["default"].object().keys({
  domainId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/domain/domain-verify?domainId=63b676c744ed3b8a72386597 domain-verify
 * @apiName domain-verify
 * @apiGroup Domains
 * @apiDescription verify a new domain
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery {String}    domainId   id of the domain
 * 
 * @apiSuccess {Boolean} Success-1                        true
 * @apiSuccess {String}  message-1                        Domain Verified successfully
 * @apiSuccess {Boolean} Success-2                        true
 * @apiSuccess {String}  message-2                        Domain already Verified!
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "message": "Domain Verified successfully"
 *       }
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "message": "Domain already Verified!"
 *       }
 *  
 *  @apiError (400)  {Boolean}  success    false
 *  @apiError (400)  {Array}    messages   TXT record not updated on DNS, Please update TXT record!
 *  @apiError (404)  {Boolean}  success    false
 *  @apiError (404)  {Array}    messages   Domain does not exist or wrong domain id passed!
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 400 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *               "TXT record not updated on DNS, Please update TXT record!"
 *           ]
 *       }
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *                "Domain does not exist or wrong domain id passed!"
 *           ]
 *       }
 */

var checkDnsRecord = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(domain, txtRecord) {
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          return _context.abrupt("return", new Promise(function (resolve, reject) {
            _nodeDns["default"].resolveTxt(domain, function (err, record) {
              if (err) {
                resolve(false);
              } else {
                var status = false;
                for (var i = 0; i < record.length; i++) {
                  if (record[i][0] == txtRecord) {
                    status = true;
                  }
                }
                resolve(status);
              }
            });
          }));
        case 1:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function checkDnsRecord(_x, _x2) {
    return _ref.apply(this, arguments);
  };
}();
var controller = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var domainId, companyId, domain, checkTxt;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          domainId = req.query.domainId;
          companyId = req.user.companyId;
          _context2.next = 5;
          return db.Domain.findOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          });
        case 5:
          domain = _context2.sent;
          if (domain) {
            _context2.next = 8;
            break;
          }
          throw new RequestError('Domain does not exist or wrong domain id passed!', 404);
        case 8:
          if (!(domain && !domain.isVerified)) {
            _context2.next = 17;
            break;
          }
          _context2.next = 11;
          return checkDnsRecord(domain.domainName, domain.txtRecord);
        case 11:
          checkTxt = _context2.sent;
          if (checkTxt) {
            _context2.next = 14;
            break;
          }
          throw new RequestError('TXT record not updated on DNS, Please update TXT record!');
        case 14:
          _context2.next = 16;
          return db.Domain.findOneAndUpdate({
            _id: domainId,
            companyId: companyId
          }, {
            isVerified: true
          });
        case 16:
          return _context2.abrupt("return", res.status(200).send({
            success: true,
            message: "Domain Verified successfully"
          }));
        case 17:
          return _context2.abrupt("return", res.status(200).send({
            success: true,
            message: "Domain already Verified!"
          }));
        case 20:
          _context2.prev = 20;
          _context2.t0 = _context2["catch"](0);
          console.log(_context2.t0);
          next(_context2.t0);
        case 24:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 20]]);
  }));
  return function controller(_x3, _x4, _x5) {
    return _ref2.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Domain', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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