"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
/**
 * @api {get} /api/v1/domain/domain-list domain-list
 * @apiName list
 * @apiGroup Domains
 * @apiDescription Returns a list of all domains of a user's company with active and total users for domain's page
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {Array}   domains    list of all domains
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {    
 *         "success": true,
 *         "domains": [
 *             {
 *                 "_id": "63d0eaaa032f943fc31e4ea2",
 *                 "domainName": "kdmarc.com",
 *                 "txtRecord": "tab-site-verification=W7CIoMg0Bitq6hahLZ4pW8aL6h4I23DLTHV88cFj",
 *                 "isVerified": true,
 *                 "companyId": "63d0ea61032f943fc31e4e80",
 *                 "domainType": "Outlook",
 *                 "isCredential": true,
 *                 "isSyncingUser": false,
 *                 "deletedAt": null,
 *                 "createdAt": "2023-01-25T08:39:06.842Z",
 *                 "updatedAt": "2023-01-25T09:00:27.078Z",
 *                 "__v": 0,
 *                 "syncStartAt": "2023-01-25T09:00:25.226Z",
 *                 "syncEndAt": "2023-01-25T09:00:27.077Z",
 *                 "totalUser": 46,
 *                 "activeUser": 46
 *             },
 *             {
 *                 "_id": "63d0f49e4b01a8cf9308bf00",
 *                 "domainName": "kratikal.com",
 *                 "txtRecord": "tab-site-verification=J6oFlCGhQzEWZKVgHqQGywiru4gslcxDgCBEWWrQ",
 *                 "isVerified": false,
 *                 "companyId": "63d0ea61032f943fc31e4e80",
 *                 "domainType": "Outlook",
 *                 "isCredential": false,
 *                 "isSyncingUser": false,
 *                 "deletedAt": null,
 *                 "createdAt": "2023-01-25T09:21:34.965Z",
 *                 "updatedAt": "2023-01-25T09:21:34.965Z",
 *                 "__v": 0,
 *                 "totalUser": 0,
 *                 "activeUser": 0
 *             }
 *         ]
 *      }
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, domains, i, totalUser, activeUser, subDomainGroups, userGroups, set, groupsHavingUsers, groupIds, groups;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _context.next = 4;
          return db.Domain.find({
            companyId: companyId,
            deletedAt: null
          }).select('-credential');
        case 4:
          domains = _context.sent;
          i = 0;
        case 6:
          if (!(i < domains.length)) {
            _context.next = 17;
            break;
          }
          _context.next = 9;
          return db.User.countDocuments({
            domainId: domains[i]._doc._id,
            deletedAt: null
          });
        case 9:
          totalUser = _context.sent;
          _context.next = 12;
          return db.User.countDocuments({
            domainId: domains[i]._doc._id,
            isActive: true,
            deletedAt: null
          });
        case 12:
          activeUser = _context.sent;
          domains[i] = _objectSpread(_objectSpread({}, domains[i]._doc), {}, {
            totalUser: totalUser,
            activeUser: activeUser
          });
        case 14:
          i++;
          _context.next = 6;
          break;
        case 17:
          _context.next = 19;
          return db.SubDomainGroup.find({
            companyId: companyId
          });
        case 19:
          subDomainGroups = _context.sent;
          _context.next = 22;
          return db.UserGroup.find({
            companyId: companyId
          }, {
            _id: 0,
            value: 1
          });
        case 22:
          userGroups = _context.sent;
          set = new Set();
          _context.next = 26;
          return db.User.find({
            groupId: {
              $in: userGroups.map(function (userGroup) {
                return userGroup.value;
              })
            },
            deletedAt: null
          }, {
            _id: 0,
            groupId: 1
          });
        case 26:
          groupsHavingUsers = _context.sent;
          groupIds = groupsHavingUsers.forEach(function (group) {
            if (set.has(group.groupId)) return;else set.add(group.groupId);
          });
          _context.next = 30;
          return db.UserGroup.find({
            value: {
              $in: Array.from(set)
            }
          }, {
            _id: 0,
            label: 1,
            value: 1,
            domainId: 1
          });
        case 30:
          groups = _context.sent;
          res.status(200).json({
            success: true,
            domains: domains,
            subDomainGroups: subDomainGroups,
            groups: groups
          });
          _context.next = 38;
          break;
        case 34:
          _context.prev = 34;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 38:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 34]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, (0, _permission.permission)('Domain', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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