"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
/**
 * @api {get} /api/v1/domain/domain-list domain-list
 * @apiName list
 * @apiGroup Domains
 * @apiDescription Returns a list of all domains of a user's company with active and total users for domain's page
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {Array}   domains    list of all domains
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {    
 *         "success": true,
 *         "domains": [
 *             {
 *                 "_id": "63d0eaaa032f943fc31e4ea2",
 *                 "domainName": "kdmarc.com",
 *                 "txtRecord": "tab-site-verification=W7CIoMg0Bitq6hahLZ4pW8aL6h4I23DLTHV88cFj",
 *                 "isVerified": true,
 *                 "companyId": "63d0ea61032f943fc31e4e80",
 *                 "domainType": "Outlook",
 *                 "isCredential": true,
 *                 "isSyncingUser": false,
 *                 "deletedAt": null,
 *                 "createdAt": "2023-01-25T08:39:06.842Z",
 *                 "updatedAt": "2023-01-25T09:00:27.078Z",
 *                 "__v": 0,
 *                 "syncStartAt": "2023-01-25T09:00:25.226Z",
 *                 "syncEndAt": "2023-01-25T09:00:27.077Z",
 *                 "totalUser": 46,
 *                 "activeUser": 46
 *             },
 *             {
 *                 "_id": "63d0f49e4b01a8cf9308bf00",
 *                 "domainName": "kratikal.com",
 *                 "txtRecord": "tab-site-verification=J6oFlCGhQzEWZKVgHqQGywiru4gslcxDgCBEWWrQ",
 *                 "isVerified": false,
 *                 "companyId": "63d0ea61032f943fc31e4e80",
 *                 "domainType": "Outlook",
 *                 "isCredential": false,
 *                 "isSyncingUser": false,
 *                 "deletedAt": null,
 *                 "createdAt": "2023-01-25T09:21:34.965Z",
 *                 "updatedAt": "2023-01-25T09:21:34.965Z",
 *                 "__v": 0,
 *                 "totalUser": 0,
 *                 "activeUser": 0
 *             }
 *         ]
 *      }
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, domains, i, totalUser, activeUser, subDomainGroups, userGroups;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _context.next = 4;
          return db.Domain.find({
            companyId: companyId,
            deletedAt: null
          }).select('-credential');
        case 4:
          domains = _context.sent;
          i = 0;
        case 6:
          if (!(i < domains.length)) {
            _context.next = 23;
            break;
          }
          _context.next = 9;
          return db.User.countDocuments({
            domainId: domains[i]._doc._id,
            deletedAt: null
          });
        case 9:
          totalUser = _context.sent;
          _context.next = 12;
          return db.User.countDocuments({
            domainId: domains[i]._doc._id,
            isActive: true,
            deletedAt: null
          });
        case 12:
          activeUser = _context.sent;
          _context.next = 15;
          return db.SubDomainGroup.find({
            companyId: companyId,
            domainId: domains[i]._doc._id
          });
        case 15:
          subDomainGroups = _context.sent;
          _context.next = 18;
          return db.UserGroup.find({
            companyId: companyId,
            domainId: domains[i]._doc._id
          }, {
            _id: 0,
            label: 1,
            value: 1
          });
        case 18:
          userGroups = _context.sent;
          domains[i] = _objectSpread(_objectSpread({}, domains[i]._doc), {}, {
            totalUser: totalUser,
            activeUser: activeUser,
            subDomainGroups: subDomainGroups,
            userGroups: userGroups
          });
        case 20:
          i++;
          _context.next = 6;
          break;
        case 23:
          res.status(200).json({
            success: true,
            domains: domains
          });
          _context.next = 30;
          break;
        case 26:
          _context.prev = 26;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 30:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 26]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, (0, _permission.permission)('Domain', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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