"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _axios = _interopRequireDefault(require("axios"));
var _joi = _interopRequireDefault(require("joi"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _credentials = _interopRequireDefault(require("../../service/credentials"));
var _subscriptionService = require("../../service/subscriptionService");
var validator = _joi["default"].object().keys({
  domainId: _joi["default"].string().hex().length(24).required(),
  email: _joi["default"].string().email().required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, _req$body, domainId, email, subscriptionCreated;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _req$body = req.body, domainId = _req$body.domainId, email = _req$body.email;
          _context.next = 5;
          return (0, _subscriptionService.createSubscription)(companyId, domainId, email);
        case 5:
          subscriptionCreated = _context.sent;
          if (subscriptionCreated.success) {
            _context.next = 8;
            break;
          }
          throw new RequestError("Failed to configure reporting subscription.");
        case 8:
          _context.next = 10;
          return db.Domain.updateOne({
            _id: domainId,
            companyId: companyId,
            deletedAt: null
          }, {
            webhookEmail: email,
            webhookAccessKey: "".concat(companyId, "-").concat(domainId, "-").concat(email)
          });
        case 10:
          return _context.abrupt("return", res.status(200).json({
            success: true,
            message: "Reporting via client configured successfully!"
          }));
        case 13:
          _context.prev = 13;
          _context.t0 = _context["catch"](0);
          next(_context.t0);
        case 16:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 13]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy, (0, _validator.validateBody)(validator), (0, _permission.permission)('Domain', 'Write'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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