"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _mailer = _interopRequireDefault(require("../../mailer"));
var _crypto = _interopRequireDefault(require("../../crypto"));
var _sanitizeHtml = _interopRequireDefault(require("sanitize-html"));
var _functions = require("../../functions");
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml2 = require("../../middlewares/sanitizeHtml");
var _expressRateLimit = _interopRequireDefault(require("express-rate-limit"));
var validator = _joi["default"].object().keys({
  firstName: _joi["default"].string().required(),
  lastName: _joi["default"].string().allow(null, '').required(),
  email: _joi["default"].string().email().required()
});
var strictLimiter = (0, _expressRateLimit["default"])({
  windowMs: 1 * 60 * 1000,
  // 1 minute
  max: 5,
  // 5 requests per minute
  message: "Too many requests to this endpoint, please try again later."
});

/**
 * @api {post} /api/v1/employee/add add
 * @apiName add
 * @apiGroup Employee
 * @apiDescription Add an IAM Employee
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}  email        email of the employee
 * @apiBody   {String}  name         name of the employee
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  message    IAM user added successfully and set password link has been send to the IAM user email
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 201 OK
 *       {
 *           "success": true,
 *           "message": "IAM user added successfully and set password link has been send to the IAM user email"
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    messages   Same email already exists please try with another email!
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *                "Same email already exists please try with another email!"
 *           ]
 *       }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, email, firstName, lastName, isHyperLink, companyId, verfKey, checkEmployee, encryptEmail, newEmployee;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, email = _req$body.email, firstName = _req$body.firstName, lastName = _req$body.lastName;
          email = (0, _sanitizeHtml["default"])(email);
          firstName = (0, _sanitizeHtml["default"])(firstName);
          lastName = (0, _sanitizeHtml["default"])(lastName);
          if (email.length) {
            _context.next = 9;
            break;
          }
          throw new RequestError("Email is empty after sanitizing!");
        case 9:
          if (firstName.length) {
            _context.next = 11;
            break;
          }
          throw new RequestError("First Name is empty after sanitizing!");
        case 11:
          isHyperLink = /^[a-zA-Z]+$/;
          if (isHyperLink.test(firstName)) {
            _context.next = 14;
            break;
          }
          throw new RequestError("First name cannot be a hyperlink!");
        case 14:
          companyId = req.user.companyId;
          verfKey = (0, _functions.randomString)(10);
          _context.next = 18;
          return db.Employee.findOne({
            email: email,
            companyId: companyId,
            deletedAt: null
          });
        case 18:
          checkEmployee = _context.sent;
          if (!checkEmployee) {
            _context.next = 21;
            break;
          }
          throw new RequestError("Same email already exists please try with another email!");
        case 21:
          _context.next = 23;
          return _crypto["default"].encrypt(email);
        case 23:
          encryptEmail = _context.sent;
          encryptEmail = encodeURIComponent(encryptEmail);
          _context.next = 27;
          return db.Employee.create({
            email: email,
            firstName: firstName,
            lastName: lastName,
            companyId: companyId,
            verfKey: verfKey,
            verfKeyExpiry: new Date()
          });
        case 27:
          newEmployee = _context.sent;
          _auditLog["default"].create(req, 'Add IAM User', email);
          logger.info("User ".concat(req.user.email, " Add IAM User"), {
            client: req.user.companyId,
            request: req,
            event: 'Add IAM User'
          });
          _context.next = 32;
          return _mailer["default"].sendEmployeePassword(firstName, email, encryptEmail, verfKey, companyId);
        case 32:
          return _context.abrupt("return", res.status(201).send({
            success: true,
            message: "IAM user added successfully and set password link has been send to the IAM user email",
            employeeId: newEmployee._id
          }));
        case 35:
          _context.prev = 35;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 39:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 35]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(strictLimiter, (0, _sanitizeHtml2.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, _strategy.checkTaConnectionStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('IAM', 'Write'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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