"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _permission = require("../../middlewares/permission");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _auditLog = _interopRequireDefault(require("../../service/audit-log"));
var validator = _joi["default"].object().keys({
  employeeId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {delete} /api/v1/employee/delete?employeeId=63b676c744ed3b8a72386597 delete
 * @apiName deltete
 * @apiGroup Employee
 * @apiDescription Delete an IAM Employee
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {String}  employeeId   id of the employee
 * 
 * @apiSuccess {Boolean} Success      true
 * @apiSuccess {String}  message      IAM User deleted successfully
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 201 OK
 *       {
 *           "success": true,
 *           "message": "IAM User deleted successfully"
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    messages   Same email already exists please try with another email!
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *       {
 *           "success": false,
 *           "messages": [
 *                "Same email already exists please try with another email!"
 *           ]
 *       }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var employeeId, companyId, employee;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          employeeId = req.query.employeeId;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.Employee.findOne({
            _id: employeeId,
            deletedAt: null,
            companyId: companyId
          });
        case 5:
          employee = _context.sent;
          if (employee) {
            _context.next = 8;
            break;
          }
          throw new RequestError('Employee not Found', 404);
        case 8:
          _context.next = 10;
          return employee.deleteOne({
            _id: employee._id
          });
        case 10:
          _context.next = 12;
          return db.EmployeeRole.deleteOne({
            employeeId: employeeId
          });
        case 12:
          _auditLog["default"].create(req, 'Delete IAM User', employee.email);
          logger.info("User ".concat(req.user.email, " Delete IAM User"), {
            client: req.user.companyId,
            request: req,
            event: 'Delete IAM User'
          });
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: 'IAM User deleted successfully'
          }));
        case 17:
          _context.prev = 17;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          return _context.abrupt("return", next(_context.t0));
        case 21:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 17]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/')["delete"](_strategy.jwtStrategy, _strategy.checkTaConnectionStrategy, (0, _permission.permission)('IAM', 'Delete'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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