"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _permission = require("../../middlewares/permission");
var _strategy = require("../../middlewares/strategy");
/**
 * @api {get} /api/v1/employee/list list
 * @apiName list
 * @apiGroup Employee
 * @apiDescription List all IAM Employees
 * 
 * @apiVersion 1.0.0
 * 
 * @apiSuccess {Boolean}  Success      true
 * @apiSuccess {Array}    employees    list of all employees
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 201 OK
 *      {
 *    "success": true,
 *    "employees": [
 *        {
 *            "_id": "63d0f1c078b9830aa47b3052",
 *            "name": "Arpit Rao",
 *            "email": "arpit.rao@kratikal.com",
 *            "isActive": false,
 *            "isVerify": false
 *        },
 *        {
 *            "_id": "63d75011f111d4088dd478e2",
 *            "name": "sarvesh.patel",
 *            "email": "sarvesh.patel@kratikal.com",
 *            "isActive": false,
 *            "isVerify": false
 *        }
 *  
 *  
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, employees, employeeIds, employeeRoles;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          console.log({
            companyId: companyId
          });

          // Step 1: Find employees for the given company
          _context.next = 5;
          return db.Employee.find({
            companyId: companyId,
            deletedAt: null
          }).select('firstName lastName email isActive isVerify');
        case 5:
          employees = _context.sent;
          // Step 2: Get employee IDs
          employeeIds = employees.map(function (employee) {
            return employee._id;
          }); // Step 3: Find employee roles for the given employee IDs and company
          _context.next = 9;
          return db.EmployeeRole.find({
            employeeId: {
              $in: employeeIds
            },
            companyId: companyId,
            deletedAt: null
          }).populate({
            path: 'employeeId',
            match: {
              deletedAt: null
            },
            select: 'firstName lastName email isActive isVerify'
          }).populate({
            path: 'roleIds',
            populate: {
              path: 'policyIds',
              select: 'name'
            }
          });
        case 9:
          employeeRoles = _context.sent;
          return _context.abrupt("return", res.status(200).send({
            success: true,
            employees: employeeRoles
          }));
        case 13:
          _context.prev = 13;
          _context.t0 = _context["catch"](0);
          return _context.abrupt("return", next(new RequestError(_context.t0)));
        case 16:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 13]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, (0, _permission.permission)('IAM', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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