"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var user, companyId, company, policies, employeeRoles;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          user = req.user;
          if (user) {
            _context.next = 4;
            break;
          }
          return _context.abrupt("return", next(new RequestError("User not found!")));
        case 4:
          companyId = user.companyId;
          if (companyId) {
            _context.next = 7;
            break;
          }
          return _context.abrupt("return", next(new RequestError("User is not associated with any company!")));
        case 7:
          _context.next = 9;
          return db.Company.findOne({
            _id: companyId
          }).lean();
        case 9:
          company = _context.sent;
          if (company) {
            _context.next = 12;
            break;
          }
          return _context.abrupt("return", next(new RequestError("Company not found!")));
        case 12:
          policies = [];
          if (!(user.type === "root")) {
            _context.next = 20;
            break;
          }
          _context.next = 16;
          return db.Policy.find().select("name").lean();
        case 16:
          policies = _context.sent;
          policies = policies.map(function (policy) {
            return policy.name;
          });
          _context.next = 26;
          break;
        case 20:
          _context.next = 22;
          return db.EmployeeRole.find({
            employeeId: user._id,
            companyId: companyId,
            deletedAt: null
          }).populate({
            path: 'roleIds',
            populate: {
              path: 'policyIds',
              select: 'name'
            }
          }).lean();
        case 22:
          employeeRoles = _context.sent;
          policies = employeeRoles.flatMap(function (role) {
            return role.roleIds || [];
          }).flatMap(function (role) {
            return role.policyIds || [];
          }).map(function (policy) {
            return policy.name;
          }).filter(Boolean);
          console.log({
            policies: policies
          });
          policies = (0, _toConsumableArray2["default"])(new Set(policies));
        case 26:
          return _context.abrupt("return", res.status(200).json({
            policies: policies
          }));
        case 29:
          _context.prev = 29;
          _context.t0 = _context["catch"](0);
          return _context.abrupt("return", next(_context.t0));
        case 32:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 29]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(_strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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