"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _crypto = _interopRequireDefault(require("../../crypto"));
var _mailer = _interopRequireDefault(require("../../mailer"));
var _permission = require("../../middlewares/permission");
var _functions = require("../../functions");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _expressRateLimit = _interopRequireDefault(require("express-rate-limit"));
var strictLimiter = (0, _expressRateLimit["default"])({
  windowMs: 1 * 60 * 1000,
  // 1 minute
  max: 5,
  // 5 requests per minute
  message: "Too many requests to this endpoint, please try again later."
});
var validator = _joi["default"].object().keys({
  employeeId: _joi["default"].string().hex().length(24).required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var employeeId, token, companyId, employee, encryptEmail;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          employeeId = req.query.employeeId;
          token = (0, _functions.randomString)(20);
          companyId = req.user.companyId;
          _context.next = 6;
          return db.Employee.findOne({
            _id: employeeId,
            companyId: companyId,
            deletedAt: null
          });
        case 6:
          employee = _context.sent;
          if (employee) {
            _context.next = 9;
            break;
          }
          throw new RequestError('Employee not Found', 404);
        case 9:
          employee['verfKey'] = token;
          employee['verfKeyExpiry'] = new Date();
          _context.next = 13;
          return employee.save();
        case 13:
          _context.next = 15;
          return _crypto["default"].encrypt(employee.email);
        case 15:
          encryptEmail = _context.sent;
          encryptEmail = encodeURIComponent(encryptEmail);
          _context.next = 19;
          return _mailer["default"].sendResetLink(employee.firstName, employee.email, encryptEmail, token, companyId);
        case 19:
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: 'Reset password link has been sent successfully'
          }));
        case 22:
          _context.prev = 22;
          _context.t0 = _context["catch"](0);
          return _context.abrupt("return", next(new RequestError(_context.t0)));
        case 25:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 22]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get(strictLimiter, _strategy.jwtStrategy, _strategy.checkTaConnectionStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('IAM', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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