"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _expressRateLimit = _interopRequireDefault(require("express-rate-limit"));
var strictLimiter = (0, _expressRateLimit["default"])({
  windowMs: 1 * 60 * 1000,
  // 1 minute
  max: 5,
  // 5 requests per minute
  message: "Too many requests to this endpoint, please try again later."
});
var validator = _joi["default"].object().keys({
  firstName: _joi["default"].string().required(),
  lastName: _joi["default"].string().allow(null, '').required(),
  email: _joi["default"].string().required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, _req$body, email, firstName, _req$body$lastName, lastName, employee;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _req$body = req.body, email = _req$body.email, firstName = _req$body.firstName, _req$body$lastName = _req$body.lastName, lastName = _req$body$lastName === void 0 ? " " : _req$body$lastName;
          _context.next = 5;
          return db.Employee.findOne({
            email: email,
            companyId: companyId
          });
        case 5:
          employee = _context.sent;
          if (employee) {
            _context.next = 8;
            break;
          }
          throw new RequestError("Employee not found");
        case 8:
          employee.firstName = firstName;
          employee.lastName = lastName;
          _context.next = 12;
          return employee.save();
        case 12:
          res.status(201).send({
            success: true,
            message: "Details updted sucessfuly",
            employeeId: employee._id
          });
          _context.next = 19;
          break;
        case 15:
          _context.prev = 15;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 19:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 15]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").post(strictLimiter, (0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), _strategy.jwtStrategy, _strategy.checkTaConnectionStrategy, _strategy.checkCompanyValidityStrategy, (0, _permission.permission)("IAM", "Write"), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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