"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _upload_file = _interopRequireDefault(require("../../Content/upload_file"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _config = _interopRequireDefault(require("../../config"));
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
// import fs from 'fs';
// import Joi from 'joi';
// import path from 'path';
// import express from 'express';

// import { sanitize } from '../../middlewares/sanitizer';
// import { jwtStrategy } from '../../middlewares/strategy';
// import { validateBody } from '../../middlewares/validator';
// import { permission } from '../../middlewares/permission'

// let validator = Joi.object().keys({
//     attachmentId: Joi.string().hex().length(24).required()
// });

// let controller = async (req, res, next) => {
// 	try {

// 		const { attachmentId } = req.query;
// 		const attachment = await db.Attachment.findOne({ _id: attachmentId }).select('fileName').populate('fileName')
// 		if (!attachment) {
// 			throw new RequestError('invalid attachmentId');
// 		}
// 		const fileName = attachment.fileName;
// 		const filePath = path.join(appRoot, 'Content', 'MailAttachments', fileName);

// 		try {
// 			res.writeHead(200, {
// 				"Content-Type": "application/octet-stream",
// 				"Content-Disposition": "attachment; filename=" + fileName
// 			});
// 			fs.createReadStream(filePath).pipe(res);
// 		} catch (error) {
// 			throw new RequestError('file not exists');
// 		}

// 	} catch (error) {
// 		console.log(error);
// 		next(error)
// 	}
// }

// const apiRouter = express.Router();
// apiRouter.route('/').get(sanitize(), validateBody(validator), jwtStrategy, permission('Users','Write'), controller);
// export default apiRouter;

// import { validateBody } from '../../middlewares/validator';

// let validator = Joi.object().keys({
//     urlIds: Joi.array().items(
//         Joi.string().hex().length(24).required()
//     ).required(),
//     reportedMailId: Joi.string().hex().length(24).required()
// });

/**
 * @api {post} /api/v1/scan/scan-url scan-url
 * @apiName scan-url
 * @apiGroup scan
 * @apiDescription Scan a url
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}   urlId        		 urlId of the reported mail
 * @apiBody   {String}   reportedMailId      Id of the reported mail
 * 
 * @apiSuccess {Boolean} Success             true
 * @apiSuccess {String}  Message             Scan now in processing, Result Will be Updated Soon!
 * 
 * @apiSuccessExample Success-Response:
 *      HTTP/1.1 200 OK 
 * {
 *           "Success": true,
 *           "Message": "Scan now in processing, Result Will be Updated Soon!"
 * }
 * 
 * @apiError {Boolean} Success             false
 * @apiError {Array}   messages            "\"reportedMailId\" is not allowed to be empty"
 * 
 * @apiSuccessExample Error-Response:
 *       HTTP/1.1 400 Not Found
 * 
 *      "success":   false,
 *      "messages" : "\"reportedMailId\" is not allowed to be empty"
 * 
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var attachmentId, attachment, file;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          attachmentId = req.query.attachmentId;
          _context.next = 4;
          return db.Attachment.findById(attachmentId);
        case 4:
          attachment = _context.sent;
          _context.next = 7;
          return _upload_file["default"].fetchReportedMailAttachments(JSON.parse(JSON.stringify(attachment.reportedMailId)), attachment.fileName);
        case 7:
          file = _context.sent;
          if (!file) {
            _context.next = 12;
            break;
          }
          if (_config["default"].s3.isSASS) {
            res.setHeader('Content-Disposition', "attachment; filename=\"".concat(attachment.fileName, "\""));
            res.setHeader("Content-Type", "application/octet-stream");
            res.send(file);
          } else {
            res.writeHead(200, {
              "Content-Type": "application/octet-stream",
              "Content-Disposition": "attachment; filename=" + attachment.fileName
            });
            file.pipe(res);
          }
          _context.next = 13;
          break;
        case 12:
          throw new RequestError('File Not Found!');
        case 13:
          _context.next = 19;
          break;
        case 15:
          _context.prev = 15;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 19:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 15]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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