"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var _updateActivationStatusUsers = require("../../service/update-activation-status-users");
var validator = _joi["default"].object().keys({
  groupName: _joi["default"].string().required(),
  users: _joi["default"].array().required(),
  groupId: _joi["default"].string().hex().length(24).optional(),
  isCreatingGroupBeforeUploadingUser: _joi["default"]["boolean"]().required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee7(req, res, next) {
    var _req$body, users, groupId, groupName, isCreatingGroupBeforeUploadingUser, companyId, isTacEnabled, query, groupWithSameNameExists, group, showRemainingLimitError, newGroup, updateUsers, activeGroupsOfCompany, usrs, usersThatDontBelongToAnyGroupInCompanyWithEmailAccess, userCountForGroupsWhichHaveEmailAccess, userLimit, remainingLimit, usersThatAlreadyBelongToAnyGroupInCompanyWithEmailAccess, usersToBeAdded, _updateUsers, _updateUsers2, _activeGroupsOfCompany, _usrs, usersThatDontBelongToAnyGroupInCompanyWithMessengerAccess, userCountForGroupsWhichHaveMessengerAccess, _userLimit, _remainingLimit, usersThatAlreadyBelongToAnyGroupInCompanyWithMessengerAccess, _usersToBeAdded, _updateUsers3, _updateUsers4, activeGroupsOfCompanyWithEmailAccess, activeGroupsOfCompanyWithMessengerAccess, _usrs2, usersThatDontBelongToAnyRelevantGroup, userLimitEmail, userLimitMessenger, userCountWithEmailAccess, userCountWithMessengerAccess, remainingLimitEmail, remainingLimitMessenger, _remainingLimit2, _usersToBeAdded2, usersThatAlreadyBelongToRelevantGroups, _updateUsers5, userIds, _updateUsers6;
    return _regenerator["default"].wrap(function _callee7$(_context7) {
      while (1) switch (_context7.prev = _context7.next) {
        case 0:
          _context7.prev = 0;
          _req$body = req.body, users = _req$body.users, groupId = _req$body.groupId, groupName = _req$body.groupName, isCreatingGroupBeforeUploadingUser = _req$body.isCreatingGroupBeforeUploadingUser;
          companyId = req.user.companyId;
          _context7.next = 5;
          return db.Company.findById(companyId);
        case 5:
          isTacEnabled = _context7.sent.isTacEnabled;
          // if (!users.length) throw new RequestError("Please select users to add to group!")
          query = {
            groupName: {
              $regex: new RegExp("^".concat(groupName, "$"), 'i')
            },
            companyId: companyId,
            deletedAt: null
          };
          if (groupId) {
            query._id = {
              $ne: groupId
            };
          }
          _context7.next = 10;
          return db.Group.findOne(query);
        case 10:
          groupWithSameNameExists = _context7.sent;
          console.log({
            groupWithSameNameExists: groupWithSameNameExists
          });
          if (!groupWithSameNameExists) {
            _context7.next = 14;
            break;
          }
          throw new RequestError("A group named ".concat(groupName, " already exists!"));
        case 14:
          _context7.next = 16;
          return db.Group.findOne({
            _id: groupId,
            companyId: companyId,
            deletedAt: null
          });
        case 16:
          group = _context7.sent;
          showRemainingLimitError = {
            error: false,
            message: ''
          };
          if (group) {
            _context7.next = 29;
            break;
          }
          _context7.next = 21;
          return db.Group.create({
            companyId: companyId,
            groupName: groupName,
            type: isTacEnabled ? 'Custom' : 'Admin'
          });
        case 21:
          newGroup = _context7.sent;
          if (users.length) {
            updateUsers = Promise.all(users.map( /*#__PURE__*/function () {
              var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(user) {
                var update;
                return _regenerator["default"].wrap(function _callee$(_context) {
                  while (1) switch (_context.prev = _context.next) {
                    case 0:
                      _context.next = 2;
                      return db.User.updateOne({
                        _id: user._id,
                        companyId: companyId,
                        deletedAt: null
                      }, {
                        $addToSet: {
                          groups: newGroup._id
                        }
                      });
                    case 2:
                      update = _context.sent;
                      return _context.abrupt("return", true);
                    case 4:
                    case "end":
                      return _context.stop();
                  }
                }, _callee);
              }));
              return function (_x4) {
                return _ref2.apply(this, arguments);
              };
            }()));
          }
          if (!(!isCreatingGroupBeforeUploadingUser && !users.length)) {
            _context7.next = 27;
            break;
          }
          _context7.next = 26;
          return db.Group.deleteOne({
            _id: newGroup._id,
            companyId: companyId
          });
        case 26:
          throw new RequestError("Please select users to add to group!");
        case 27:
          _context7.next = 147;
          break;
        case 29:
          if (!group.isDefaultGroup) {
            _context7.next = 31;
            break;
          }
          throw new RequestError("all-users-tpir group's details can only be viewed.");
        case 31:
          _context7.next = 33;
          return db.Group.updateOne({
            _id: groupId,
            companyId: companyId
          }, {
            $set: {
              groupName: groupName
            }
          });
        case 33:
          if (!(group.emailAccess && !group.messengerAccess)) {
            _context7.next = 62;
            break;
          }
          _context7.next = 36;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            emailAccess: true
          }).select("_id");
        case 36:
          activeGroupsOfCompany = _context7.sent;
          usrs = users.map(function (user) {
            return user._id;
          });
          if (!(activeGroupsOfCompany.length > 0)) {
            _context7.next = 42;
            break;
          }
          _context7.next = 41;
          return db.User.find({
            companyId: companyId,
            _id: {
              $in: usrs
            },
            groups: {
              $nin: activeGroupsOfCompany
            }
          });
        case 41:
          usersThatDontBelongToAnyGroupInCompanyWithEmailAccess = _context7.sent;
        case 42:
          userCountForGroupsWhichHaveEmailAccess = 0;
          if (!(activeGroupsOfCompany.length > 0)) {
            _context7.next = 47;
            break;
          }
          _context7.next = 46;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: activeGroupsOfCompany
            }
          });
        case 46:
          userCountForGroupsWhichHaveEmailAccess = _context7.sent;
        case 47:
          console.log({
            userCountForGroupsWhichHaveEmailAccess: userCountForGroupsWhichHaveEmailAccess
          });
          _context7.next = 50;
          return db.MetaData.findOne({
            name: "userLimit",
            deletedAt: null,
            companyId: companyId
          });
        case 50:
          userLimit = _context7.sent.value;
          remainingLimit = Math.max(0, userLimit - userCountForGroupsWhichHaveEmailAccess);
          console.log({
            remainingLimit: remainingLimit
          });
          _context7.next = 55;
          return db.User.find({
            companyId: companyId,
            _id: {
              $in: usrs
            },
            groups: {
              $in: activeGroupsOfCompany
            }
          });
        case 55:
          usersThatAlreadyBelongToAnyGroupInCompanyWithEmailAccess = _context7.sent;
          if (remainingLimit > 0) {
            usersToBeAdded = usersThatDontBelongToAnyGroupInCompanyWithEmailAccess.slice(0, remainingLimit);
            _updateUsers = Promise.all([].concat((0, _toConsumableArray2["default"])(usersThatAlreadyBelongToAnyGroupInCompanyWithEmailAccess), (0, _toConsumableArray2["default"])(usersToBeAdded)).map( /*#__PURE__*/function () {
              var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(user) {
                var update;
                return _regenerator["default"].wrap(function _callee2$(_context2) {
                  while (1) switch (_context2.prev = _context2.next) {
                    case 0:
                      _context2.next = 2;
                      return db.User.updateOne({
                        _id: user._id,
                        companyId: companyId,
                        deletedAt: null
                      }, {
                        $addToSet: {
                          groups: groupId
                        }
                      });
                    case 2:
                      update = _context2.sent;
                      return _context2.abrupt("return", true);
                    case 4:
                    case "end":
                      return _context2.stop();
                  }
                }, _callee2);
              }));
              return function (_x5) {
                return _ref3.apply(this, arguments);
              };
            }()));
          } else {
            _updateUsers2 = Promise.all(usersThatAlreadyBelongToAnyGroupInCompanyWithEmailAccess.map( /*#__PURE__*/function () {
              var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(user) {
                var update;
                return _regenerator["default"].wrap(function _callee3$(_context3) {
                  while (1) switch (_context3.prev = _context3.next) {
                    case 0:
                      _context3.next = 2;
                      return db.User.updateOne({
                        _id: user._id,
                        companyId: companyId,
                        deletedAt: null
                      }, {
                        $addToSet: {
                          groups: groupId
                        }
                      });
                    case 2:
                      update = _context3.sent;
                      return _context3.abrupt("return", true);
                    case 4:
                    case "end":
                      return _context3.stop();
                  }
                }, _callee3);
              }));
              return function (_x6) {
                return _ref4.apply(this, arguments);
              };
            }()));
          }
          if (usersThatDontBelongToAnyGroupInCompanyWithEmailAccess.length > remainingLimit) {
            showRemainingLimitError = {
              error: true,
              message: "Number of users selected exceeds remaining limit of users that can be granted email access so only users that already belong to group with email access will be added to group!"
            };
          }
          _context7.next = 60;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            _id: {
              $nin: usrs
            }
          }, {
            $pull: {
              groups: groupId
            }
          });
        case 60:
          _context7.next = 62;
          return (0, _updateActivationStatusUsers.updateActivationStautsOfUsers)(companyId);
        case 62:
          if (!(group.messengerAccess && !group.emailAccess)) {
            _context7.next = 91;
            break;
          }
          _context7.next = 65;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            messengerAccess: true
          }).select("_id");
        case 65:
          _activeGroupsOfCompany = _context7.sent;
          _usrs = users.map(function (user) {
            return user._id;
          });
          if (!(_activeGroupsOfCompany.length > 0)) {
            _context7.next = 71;
            break;
          }
          _context7.next = 70;
          return db.User.find({
            companyId: companyId,
            _id: {
              $in: _usrs
            },
            groups: {
              $nin: _activeGroupsOfCompany
            }
          });
        case 70:
          usersThatDontBelongToAnyGroupInCompanyWithMessengerAccess = _context7.sent;
        case 71:
          userCountForGroupsWhichHaveMessengerAccess = 0;
          if (!(_activeGroupsOfCompany.length > 0)) {
            _context7.next = 76;
            break;
          }
          _context7.next = 75;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: _activeGroupsOfCompany
            }
          });
        case 75:
          userCountForGroupsWhichHaveMessengerAccess = _context7.sent;
        case 76:
          console.log({
            userCountForGroupsWhichHaveMessengerAccess: userCountForGroupsWhichHaveMessengerAccess
          });
          _context7.next = 79;
          return db.MetaData.findOne({
            name: "userLimitMessenger",
            deletedAt: null,
            companyId: companyId
          });
        case 79:
          _userLimit = _context7.sent.value;
          _remainingLimit = Math.max(0, _userLimit - userCountForGroupsWhichHaveMessengerAccess);
          console.log({
            remainingLimit: _remainingLimit
          });
          _context7.next = 84;
          return db.User.find({
            companyId: companyId,
            _id: {
              $in: _usrs
            },
            groups: {
              $in: _activeGroupsOfCompany
            }
          });
        case 84:
          usersThatAlreadyBelongToAnyGroupInCompanyWithMessengerAccess = _context7.sent;
          if (_remainingLimit > 0) {
            _usersToBeAdded = usersThatDontBelongToAnyGroupInCompanyWithMessengerAccess.slice(0, _remainingLimit);
            _updateUsers3 = Promise.all([].concat((0, _toConsumableArray2["default"])(usersThatAlreadyBelongToAnyGroupInCompanyWithMessengerAccess), (0, _toConsumableArray2["default"])(_usersToBeAdded)).map( /*#__PURE__*/function () {
              var _ref5 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(user) {
                var update;
                return _regenerator["default"].wrap(function _callee4$(_context4) {
                  while (1) switch (_context4.prev = _context4.next) {
                    case 0:
                      _context4.next = 2;
                      return db.User.updateOne({
                        _id: user._id,
                        companyId: companyId,
                        deletedAt: null
                      }, {
                        $addToSet: {
                          groups: groupId
                        }
                      });
                    case 2:
                      update = _context4.sent;
                      return _context4.abrupt("return", true);
                    case 4:
                    case "end":
                      return _context4.stop();
                  }
                }, _callee4);
              }));
              return function (_x7) {
                return _ref5.apply(this, arguments);
              };
            }()));
          } else {
            _updateUsers4 = Promise.all(usersThatAlreadyBelongToAnyGroupInCompanyWithMessengerAccess.map( /*#__PURE__*/function () {
              var _ref6 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(user) {
                var update;
                return _regenerator["default"].wrap(function _callee5$(_context5) {
                  while (1) switch (_context5.prev = _context5.next) {
                    case 0:
                      _context5.next = 2;
                      return db.User.updateOne({
                        _id: user._id,
                        companyId: companyId,
                        deletedAt: null
                      }, {
                        $addToSet: {
                          groups: groupId
                        }
                      });
                    case 2:
                      update = _context5.sent;
                      return _context5.abrupt("return", true);
                    case 4:
                    case "end":
                      return _context5.stop();
                  }
                }, _callee5);
              }));
              return function (_x8) {
                return _ref6.apply(this, arguments);
              };
            }()));
          }
          if (usersThatDontBelongToAnyGroupInCompanyWithMessengerAccess.length > _remainingLimit) {
            showRemainingLimitError = {
              error: true,
              message: "Number of users selected exceeds remaining limit of users that can be granted whatsapp access so only users that already belong to group with whatsapp access will be added to group!"
            };
          }
          _context7.next = 89;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            _id: {
              $nin: _usrs
            }
          }, {
            $pull: {
              groups: groupId
            }
          });
        case 89:
          _context7.next = 91;
          return (0, _updateActivationStatusUsers.updateActivationStautsOfUsers)(companyId);
        case 91:
          if (!(group.emailAccess && group.messengerAccess)) {
            _context7.next = 133;
            break;
          }
          _context7.next = 94;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            emailAccess: true
          }).select("_id");
        case 94:
          activeGroupsOfCompanyWithEmailAccess = _context7.sent;
          _context7.next = 97;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            messengerAccess: true
          }).select("_id");
        case 97:
          activeGroupsOfCompanyWithMessengerAccess = _context7.sent;
          _usrs2 = users.map(function (user) {
            return user._id;
          });
          if (!(activeGroupsOfCompanyWithEmailAccess.length > 0 && activeGroupsOfCompanyWithMessengerAccess.length > 0)) {
            _context7.next = 103;
            break;
          }
          _context7.next = 102;
          return db.User.find({
            companyId: companyId,
            _id: {
              $in: _usrs2
            },
            groups: {
              $nin: [].concat((0, _toConsumableArray2["default"])(activeGroupsOfCompanyWithEmailAccess), (0, _toConsumableArray2["default"])(activeGroupsOfCompanyWithMessengerAccess))
            }
          });
        case 102:
          usersThatDontBelongToAnyRelevantGroup = _context7.sent;
        case 103:
          _context7.next = 105;
          return db.MetaData.findOne({
            name: "userLimit",
            deletedAt: null,
            companyId: companyId
          });
        case 105:
          userLimitEmail = _context7.sent.value;
          _context7.next = 108;
          return db.MetaData.findOne({
            name: "userLimitMessenger",
            deletedAt: null,
            companyId: companyId
          });
        case 108:
          userLimitMessenger = _context7.sent.value;
          userCountWithEmailAccess = 0;
          if (!(activeGroupsOfCompanyWithEmailAccess.length > 0)) {
            _context7.next = 114;
            break;
          }
          _context7.next = 113;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: activeGroupsOfCompanyWithEmailAccess
            }
          });
        case 113:
          userCountWithEmailAccess = _context7.sent;
        case 114:
          userCountWithMessengerAccess = 0;
          if (!(activeGroupsOfCompanyWithMessengerAccess.length > 0)) {
            _context7.next = 119;
            break;
          }
          _context7.next = 118;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: activeGroupsOfCompanyWithMessengerAccess
            }
          });
        case 118:
          userCountWithMessengerAccess = _context7.sent;
        case 119:
          remainingLimitEmail = Math.max(0, userLimitEmail - userCountWithEmailAccess);
          remainingLimitMessenger = Math.max(0, userLimitMessenger - userCountWithMessengerAccess);
          _remainingLimit2 = Math.min(remainingLimitEmail, remainingLimitMessenger);
          _usersToBeAdded2 = [];
          if (_remainingLimit2 > 0 && usersThatDontBelongToAnyRelevantGroup) {
            _usersToBeAdded2 = usersThatDontBelongToAnyRelevantGroup.slice(0, _remainingLimit2);
          }
          _context7.next = 126;
          return db.User.find({
            companyId: companyId,
            _id: {
              $in: _usrs2
            },
            groups: {
              $in: [].concat((0, _toConsumableArray2["default"])(activeGroupsOfCompanyWithEmailAccess), (0, _toConsumableArray2["default"])(activeGroupsOfCompanyWithMessengerAccess))
            }
          });
        case 126:
          usersThatAlreadyBelongToRelevantGroups = _context7.sent;
          _updateUsers5 = Promise.all([].concat((0, _toConsumableArray2["default"])(usersThatAlreadyBelongToRelevantGroups), (0, _toConsumableArray2["default"])(_usersToBeAdded2)).map( /*#__PURE__*/function () {
            var _ref7 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee6(user) {
              return _regenerator["default"].wrap(function _callee6$(_context6) {
                while (1) switch (_context6.prev = _context6.next) {
                  case 0:
                    _context6.next = 2;
                    return db.User.updateOne({
                      _id: user._id,
                      companyId: companyId,
                      deletedAt: null
                    }, {
                      $addToSet: {
                        groups: groupId
                      }
                    });
                  case 2:
                    return _context6.abrupt("return", true);
                  case 3:
                  case "end":
                    return _context6.stop();
                }
              }, _callee6);
            }));
            return function (_x9) {
              return _ref7.apply(this, arguments);
            };
          }()));
          if (usersThatDontBelongToAnyRelevantGroup.length > _remainingLimit2) {
            showRemainingLimitError = {
              error: true,
              message: "Number of users selected exceeds remaining limit of users that can be granted email access and whatsapp access so only users that already belong to group with both access will be added to group!"
            };
          }
          _context7.next = 131;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            _id: {
              $nin: _usrs2
            }
          }, {
            $pull: {
              groups: groupId
            }
          });
        case 131:
          _context7.next = 133;
          return (0, _updateActivationStatusUsers.updateActivationStautsOfUsers)(companyId);
        case 133:
          if (!(!group.emailAccess && !group.messengerAccess)) {
            _context7.next = 144;
            break;
          }
          console.log({
            users: users
          });
          userIds = users.map(function (user) {
            return user._id.toString();
          });
          userIds = (0, _toConsumableArray2["default"])(new Set(userIds));
          _context7.next = 139;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            _id: {
              $in: userIds
            }
          }, {
            $addToSet: {
              groups: groupId
            }
          });
        case 139:
          _updateUsers6 = _context7.sent;
          _context7.next = 142;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            _id: {
              $nin: userIds
            }
          }, {
            $pull: {
              groups: groupId
            }
          });
        case 142:
          _context7.next = 144;
          return (0, _updateActivationStatusUsers.updateActivationStautsOfUsers)(companyId);
        case 144:
          if (!(users.length == 0 && !isCreatingGroupBeforeUploadingUser)) {
            _context7.next = 147;
            break;
          }
          _context7.next = 147;
          return db.Group.deleteOne({
            _id: groupId,
            companyId: companyId,
            isDefaultGroup: false
          });
        case 147:
          return _context7.abrupt("return", res.status(200).send({
            success: true,
            message:
            // (users.length == 0 && !isCreatingGroupBeforeUploadingUser) ? "Please select users to add to group!" : 
            "Group details successfully updated!",
            groupId: newGroup === null || newGroup === void 0 ? void 0 : newGroup._id,
            showRemainingLimitError: showRemainingLimitError
          }));
        case 150:
          _context7.prev = 150;
          _context7.t0 = _context7["catch"](0);
          console.log('error', _context7.t0);
          next(_context7.t0);
        case 154:
        case "end":
          return _context7.stop();
      }
    }, _callee7, null, [[0, 150]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy,
// checkTaConnectionStrategy,
_strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Users', 'Read'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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