"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _mongoose = _interopRequireDefault(require("mongoose"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var validator = _joi["default"].object().keys({
  groupId: _joi["default"].string().hex().length(24).required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var groupId, companyId, isTacEnabled, group, groupsWithAccess, groupsWithEmailAccess, groupsWithMessengerAccess;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          groupId = req.body.groupId;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.Company.findById(companyId);
        case 5:
          isTacEnabled = _context.sent.isTacEnabled;
          _context.next = 8;
          return db.Group.findOne({
            _id: groupId,
            companyId: companyId,
            deletedAt: null
          });
        case 8:
          group = _context.sent;
          if (group) {
            _context.next = 11;
            break;
          }
          throw new RequestError("Group not found!");
        case 11:
          if (!group.isSyncingUsers) {
            _context.next = 13;
            break;
          }
          throw new RequestError("Syncing in progress kindly wait until syncing is complete!");
        case 13:
          if (!(group.groupName == 'all-users-tpir' && group.defaultGroup)) {
            _context.next = 15;
            break;
          }
          throw new RequestError("Default group cannot be deleted!");
        case 15:
          if (!(isTacEnabled && group.type == 'Admin')) {
            _context.next = 17;
            break;
          }
          throw new RequestError("Admin group can only be deleted from TA!");
        case 17:
          _context.next = 19;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            $or: [{
              emailAccess: true
            }, {
              messengerAccess: true
            }]
          }).select('_id emailAccess messengerAccess');
        case 19:
          groupsWithAccess = _context.sent;
          groupsWithEmailAccess = new Set();
          groupsWithMessengerAccess = new Set(); // Separating groups by access type
          groupsWithAccess.forEach(function (group) {
            if (group.emailAccess) groupsWithEmailAccess.add(group._id.toString());
            if (group.messengerAccess) groupsWithMessengerAccess.add(group._id.toString());
          });
          if (!(isTacEnabled && group.type === "Custom" || !isTacEnabled && group.type === 'Admin')) {
            _context.next = 32;
            break;
          }
          _context.next = 26;
          return db.User.updateMany({
            companyId: companyId,
            groups: group._id,
            deletedAt: null
          }, {
            $pull: {
              groups: group._id
            }
          });
        case 26:
          _context.next = 28;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $nin: Array.from(groupsWithEmailAccess)
            }
          }, {
            $set: {
              isActive: false
            }
          });
        case 28:
          _context.next = 30;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $nin: Array.from(groupsWithMessengerAccess)
            }
          }, {
            $set: {
              isActiveMessenger: false
            }
          });
        case 30:
          _context.next = 32;
          return db.Group.deleteOne({
            _id: group._id,
            companyId: companyId
          });
        case 32:
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: "Group successfully removed!"
          }));
        case 35:
          _context.prev = 35;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 39:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 35]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy,
//  checkTaConnectionStrategy,
(0, _permission.permission)('Users', 'Read'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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