"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var validator = _joi["default"].object().keys({
  status: _joi["default"]["boolean"]().required(),
  accessType: _joi["default"].string().required(),
  groupId: _joi["default"].string().hex().length(24).required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, accessType, groupId, status, companyId, group, activeGroupsOfCompany, usersCountInGroup, userLimit, userCountForGroupsWhichHaveEmailAccess, remainingLimit, userIds, countOfUserswhichAlreadyBelongToGroupWithEmailAccess, countOfNewUsersThatNeedToBeAdded, _activeGroupsOfCompany, _activeGroupsOfCompany2, _usersCountInGroup, _userLimit, userCountForGroupsWhichHaveMessengerAccess, _remainingLimit, _userIds, countOfUserswhichAlreadyBelongToGroupWithMessengerAccess, _countOfNewUsersThatNeedToBeAdded, _activeGroupsOfCompany3;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, accessType = _req$body.accessType, groupId = _req$body.groupId, status = _req$body.status;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.Group.findOne({
            _id: groupId,
            companyId: companyId,
            deletedAt: null
          });
        case 5:
          group = _context.sent;
          if (group) {
            _context.next = 8;
            break;
          }
          throw new RequestError("Group not found", 404);
        case 8:
          if (!(accessType == "email")) {
            _context.next = 65;
            break;
          }
          if (status) {
            _context.next = 51;
            break;
          }
          _context.next = 12;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            emailAccess: true
          }).select("_id");
        case 12:
          activeGroupsOfCompany = _context.sent;
          _context.next = 15;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [groupId]
            }
          });
        case 15:
          usersCountInGroup = _context.sent;
          console.log({
            usersCountInGroup: usersCountInGroup
          });
          _context.next = 19;
          return db.MetaData.findOne({
            name: "userLimit",
            deletedAt: null,
            companyId: companyId
          });
        case 19:
          userLimit = _context.sent.value;
          console.log({
            userLimit: userLimit
          });
          userCountForGroupsWhichHaveEmailAccess = 0;
          if (!(activeGroupsOfCompany.length > 0)) {
            _context.next = 26;
            break;
          }
          _context.next = 25;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: activeGroupsOfCompany
            }
          });
        case 25:
          userCountForGroupsWhichHaveEmailAccess = _context.sent;
        case 26:
          console.log({
            userCountForGroupsWhichHaveEmailAccess: userCountForGroupsWhichHaveEmailAccess
          });
          remainingLimit = Math.max(0, userLimit - userCountForGroupsWhichHaveEmailAccess);
          console.log({
            remainingLimit: remainingLimit
          });
          _context.next = 31;
          return db.User.find({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [groupId]
            }
          }).select('_id');
        case 31:
          userIds = _context.sent;
          console.log({
            userIds: userIds
          });
          countOfUserswhichAlreadyBelongToGroupWithEmailAccess = 0;
          if (!(activeGroupsOfCompany.length > 0)) {
            _context.next = 38;
            break;
          }
          _context.next = 37;
          return db.User.countDocuments({
            _id: {
              $in: userIds
            },
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: activeGroupsOfCompany
            }
          });
        case 37:
          countOfUserswhichAlreadyBelongToGroupWithEmailAccess = _context.sent;
        case 38:
          console.log({
            countOfUserswhichAlreadyBelongToGroupWithEmailAccess: countOfUserswhichAlreadyBelongToGroupWithEmailAccess
          });
          countOfNewUsersThatNeedToBeAdded = Math.max(0, usersCountInGroup - countOfUserswhichAlreadyBelongToGroupWithEmailAccess);
          console.log({
            countOfNewUsersThatNeedToBeAdded: countOfNewUsersThatNeedToBeAdded
          });
          if (!(countOfNewUsersThatNeedToBeAdded > remainingLimit)) {
            _context.next = 45;
            break;
          }
          throw new RequestError("User Limit Exceeded!");
        case 45:
          _context.next = 47;
          return db.Group.updateOne({
            _id: groupId,
            companyId: companyId
          }, {
            $set: {
              emailAccess: !status
            }
          });
        case 47:
          _context.next = 49;
          return db.User.updateMany({
            groups: {
              $in: [groupId]
            },
            companyId: companyId,
            deletedAt: null
          }, {
            $set: {
              isActive: true
            }
          });
        case 49:
          _context.next = 63;
          break;
        case 51:
          _context.next = 53;
          return db.Group.updateOne({
            _id: groupId,
            companyId: companyId
          }, {
            $set: {
              emailAccess: !status
            }
          });
        case 53:
          _context.next = 55;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            emailAccess: true
          }).select("_id");
        case 55:
          _activeGroupsOfCompany = _context.sent;
          if (!_activeGroupsOfCompany.length) {
            _context.next = 61;
            break;
          }
          _context.next = 59;
          return db.User.updateMany({
            groups: {
              $nin: _activeGroupsOfCompany
            },
            companyId: companyId,
            deletedAt: null
          }, {
            $set: {
              isActive: false
            }
          });
        case 59:
          _context.next = 63;
          break;
        case 61:
          _context.next = 63;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null
          }, {
            $set: {
              isActive: false
            }
          });
        case 63:
          _context.next = 114;
          break;
        case 65:
          if (status) {
            _context.next = 102;
            break;
          }
          _context.next = 68;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            messengerAccess: true
          }).select("_id");
        case 68:
          _activeGroupsOfCompany2 = _context.sent;
          console.log({
            activeGroupsOfCompany: _activeGroupsOfCompany2
          });
          _context.next = 72;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [groupId]
            }
          });
        case 72:
          _usersCountInGroup = _context.sent;
          _context.next = 75;
          return db.MetaData.findOne({
            name: "userLimitMessenger",
            companyId: companyId,
            deletedAt: null
          });
        case 75:
          _userLimit = _context.sent.value;
          userCountForGroupsWhichHaveMessengerAccess = 0;
          if (!(_activeGroupsOfCompany2.length > 0)) {
            _context.next = 81;
            break;
          }
          _context.next = 80;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: _activeGroupsOfCompany2
            }
          });
        case 80:
          userCountForGroupsWhichHaveMessengerAccess = _context.sent;
        case 81:
          _remainingLimit = Math.max(0, _userLimit - userCountForGroupsWhichHaveMessengerAccess);
          _context.next = 84;
          return db.User.find({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: groupId
            }
          }).select('_id');
        case 84:
          _userIds = _context.sent;
          countOfUserswhichAlreadyBelongToGroupWithMessengerAccess = 0;
          if (!(_activeGroupsOfCompany2.length > 0)) {
            _context.next = 90;
            break;
          }
          _context.next = 89;
          return db.User.countDocuments({
            _id: {
              $in: _userIds
            },
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: _activeGroupsOfCompany2
            }
          });
        case 89:
          countOfUserswhichAlreadyBelongToGroupWithMessengerAccess = _context.sent;
        case 90:
          _countOfNewUsersThatNeedToBeAdded = Math.max(0, _usersCountInGroup - countOfUserswhichAlreadyBelongToGroupWithMessengerAccess);
          console.log({
            countOfNewUsersThatNeedToBeAdded: _countOfNewUsersThatNeedToBeAdded,
            remainingLimit: _remainingLimit
          });
          if (!(_countOfNewUsersThatNeedToBeAdded > _remainingLimit)) {
            _context.next = 96;
            break;
          }
          throw new RequestError("User Limit Exceeded!");
        case 96:
          _context.next = 98;
          return db.Group.updateOne({
            _id: groupId,
            companyId: companyId
          }, {
            $set: {
              messengerAccess: !status
            }
          });
        case 98:
          _context.next = 100;
          return db.User.updateMany({
            groups: {
              $in: groupId
            },
            companyId: companyId,
            deletedAt: null
          }, {
            $set: {
              isActiveMessenger: true
            }
          });
        case 100:
          _context.next = 114;
          break;
        case 102:
          _context.next = 104;
          return db.Group.updateOne({
            _id: groupId,
            companyId: companyId
          }, {
            $set: {
              messengerAccess: !status
            }
          });
        case 104:
          _context.next = 106;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            messengerAccess: true
          }).select("_id");
        case 106:
          _activeGroupsOfCompany3 = _context.sent;
          if (!_activeGroupsOfCompany3.length) {
            _context.next = 112;
            break;
          }
          _context.next = 110;
          return db.User.updateMany({
            groups: {
              $nin: _activeGroupsOfCompany3
            },
            companyId: companyId,
            deletedAt: null
          }, {
            $set: {
              isActiveMessenger: false
            }
          });
        case 110:
          _context.next = 114;
          break;
        case 112:
          _context.next = 114;
          return db.User.updateMany({
            companyId: companyId,
            deletedAt: null
          }, {
            $set: {
              isActiveMessenger: false
            }
          });
        case 114:
          return _context.abrupt("return", res.status(200).send({
            success: true,
            message: "Access for ".concat(accessType, " reporting for ").concat(group.groupName, " group has been successfully ").concat(!status ? 'enabled' : 'disabled', "!")
          }));
        case 117:
          _context.prev = 117;
          _context.t0 = _context["catch"](0);
          console.log('error', _context.t0);
          next(_context.t0);
        case 121:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 117]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy, (0, _permission.permission)('Users', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJ2YWxpZGF0b3IiLCJKb2kiLCJvYmplY3QiLCJrZXlzIiwic3RhdHVzIiwicmVxdWlyZWQiLCJhY2Nlc3NUeXBlIiwic3RyaW5nIiwiZ3JvdXBJZCIsImhleCIsImxlbmd0aCIsImNvbnRyb2xsZXIiLCJyZXEiLCJyZXMiLCJuZXh0IiwiYm9keSIsImNvbXBhbnlJZCIsInVzZXIiLCJkYiIsIkdyb3VwIiwiZmluZE9uZSIsIl9pZCIsImRlbGV0ZWRBdCIsImdyb3VwIiwiUmVxdWVzdEVycm9yIiwiZmluZCIsImVtYWlsQWNjZXNzIiwic2VsZWN0IiwiYWN0aXZlR3JvdXBzT2ZDb21wYW55IiwiVXNlciIsImNvdW50RG9jdW1lbnRzIiwiZ3JvdXBzIiwiJGluIiwidXNlcnNDb3VudEluR3JvdXAiLCJjb25zb2xlIiwibG9nIiwiTWV0YURhdGEiLCJuYW1lIiwidXNlckxpbWl0IiwidmFsdWUiLCJ1c2VyQ291bnRGb3JHcm91cHNXaGljaEhhdmVFbWFpbEFjY2VzcyIsInJlbWFpbmluZ0xpbWl0IiwiTWF0aCIsIm1heCIsInVzZXJJZHMiLCJjb3VudE9mVXNlcnN3aGljaEFscmVhZHlCZWxvbmdUb0dyb3VwV2l0aEVtYWlsQWNjZXNzIiwiY291bnRPZk5ld1VzZXJzVGhhdE5lZWRUb0JlQWRkZWQiLCJ1cGRhdGVPbmUiLCIkc2V0IiwidXBkYXRlTWFueSIsImlzQWN0aXZlIiwiJG5pbiIsIm1lc3NlbmdlckFjY2VzcyIsInVzZXJDb3VudEZvckdyb3Vwc1doaWNoSGF2ZU1lc3NlbmdlckFjY2VzcyIsImNvdW50T2ZVc2Vyc3doaWNoQWxyZWFkeUJlbG9uZ1RvR3JvdXBXaXRoTWVzc2VuZ2VyQWNjZXNzIiwiaXNBY3RpdmVNZXNzZW5nZXIiLCJzZW5kIiwic3VjY2VzcyIsIm1lc3NhZ2UiLCJncm91cE5hbWUiLCJhcGlSb3V0ZXIiLCJleHByZXNzIiwiUm91dGVyIiwicm91dGUiLCJwb3N0Iiwiand0U3RyYXRlZ3kiLCJwZXJtaXNzaW9uIiwidmFsaWRhdGVCb2R5Il0sInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2FwaS9ncm91cHMvZ3JhbnRBY2Nlc3MuanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IEpvaSBmcm9tICdqb2knO1xuaW1wb3J0IGV4cHJlc3MgZnJvbSAnZXhwcmVzcyc7XG5cbmltcG9ydCB7IGp3dFN0cmF0ZWd5IH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvc3RyYXRlZ3knO1xuaW1wb3J0IHsgdmFsaWRhdGVCb2R5IH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvdmFsaWRhdG9yJztcbmltcG9ydCB7IHBlcm1pc3Npb24gfSBmcm9tICcuLi8uLi9taWRkbGV3YXJlcy9wZXJtaXNzaW9uJztcblxuY29uc3QgdmFsaWRhdG9yID0gSm9pLm9iamVjdCgpLmtleXMoe1xuICAgIHN0YXR1czogSm9pLmJvb2xlYW4oKS5yZXF1aXJlZCgpLFxuICAgIGFjY2Vzc1R5cGU6IEpvaS5zdHJpbmcoKS5yZXF1aXJlZCgpLFxuICAgIGdyb3VwSWQ6IEpvaS5zdHJpbmcoKS5oZXgoKS5sZW5ndGgoMjQpLnJlcXVpcmVkKClcbn0pXG5cblxuY29uc3QgY29udHJvbGxlciA9IGFzeW5jIChyZXEsIHJlcywgbmV4dCkgPT4ge1xuICAgIHRyeSB7XG4gICAgICAgIGNvbnN0IHsgYWNjZXNzVHlwZSwgZ3JvdXBJZCwgc3RhdHVzIH0gPSByZXEuYm9keTtcbiAgICAgICAgY29uc3QgeyBjb21wYW55SWQgfSA9IHJlcS51c2VyXG5cbiAgICAgICAgY29uc3QgZ3JvdXAgPSBhd2FpdCBkYi5Hcm91cC5maW5kT25lKHtfaWQ6IGdyb3VwSWQsIGNvbXBhbnlJZCwgZGVsZXRlZEF0OiBudWxsfSlcbiAgICAgICAgaWYoIWdyb3VwKSB0aHJvdyBuZXcgUmVxdWVzdEVycm9yKFwiR3JvdXAgbm90IGZvdW5kXCIsNDA0KVxuXG4gICAgICAgIGlmKGFjY2Vzc1R5cGUgPT0gXCJlbWFpbFwiKXtcbiAgICAgICAgICAgIGlmKCFzdGF0dXMpe1xuICAgICAgICAgICAgICAgIGxldCBhY3RpdmVHcm91cHNPZkNvbXBhbnkgPSBhd2FpdCBkYi5Hcm91cC5maW5kKHtjb21wYW55SWQsIGRlbGV0ZWRBdDpudWxsLCBlbWFpbEFjY2Vzczp0cnVlfSkuc2VsZWN0KFwiX2lkXCIpXG4gICAgICAgICAgICAgICAgXG4gICAgICAgICAgICAgICAgbGV0IHVzZXJzQ291bnRJbkdyb3VwID0gYXdhaXQgZGIuVXNlci5jb3VudERvY3VtZW50cyh7Y29tcGFueUlkLCBkZWxldGVkQXQ6bnVsbCwgZ3JvdXBzOnskaW46W2dyb3VwSWRdfX0pIFxuICAgICAgICAgICAgICAgIGNvbnNvbGUubG9nKHt1c2Vyc0NvdW50SW5Hcm91cH0pXG4gICAgICAgICAgICAgICAgbGV0IHVzZXJMaW1pdCA9IChhd2FpdCBkYi5NZXRhRGF0YS5maW5kT25lKHtuYW1lOlwidXNlckxpbWl0XCIsIGRlbGV0ZWRBdDpudWxsLCBjb21wYW55SWR9KSkudmFsdWVcbiAgICAgICAgICAgICAgICBjb25zb2xlLmxvZyh7dXNlckxpbWl0fSlcblxuICAgICAgICAgICAgICAgIGxldCB1c2VyQ291bnRGb3JHcm91cHNXaGljaEhhdmVFbWFpbEFjY2VzcyA9IDA7XG5cbiAgICAgICAgICAgICAgICBpZihhY3RpdmVHcm91cHNPZkNvbXBhbnkubGVuZ3RoID4gMCkgdXNlckNvdW50Rm9yR3JvdXBzV2hpY2hIYXZlRW1haWxBY2Nlc3MgPSBhd2FpdCBkYi5Vc2VyLmNvdW50RG9jdW1lbnRzKHtjb21wYW55SWQsIGRlbGV0ZWRBdDpudWxsLCBncm91cHM6eyRpbjphY3RpdmVHcm91cHNPZkNvbXBhbnl9fSkgXG4gICAgICAgICAgICAgICAgY29uc29sZS5sb2coe3VzZXJDb3VudEZvckdyb3Vwc1doaWNoSGF2ZUVtYWlsQWNjZXNzfSlcblxuICAgICAgICAgICAgICAgIGxldCByZW1haW5pbmdMaW1pdCA9IE1hdGgubWF4KDAsdXNlckxpbWl0IC0gdXNlckNvdW50Rm9yR3JvdXBzV2hpY2hIYXZlRW1haWxBY2Nlc3MpXG4gICAgICAgICAgICAgICAgY29uc29sZS5sb2coe3JlbWFpbmluZ0xpbWl0fSlcblxuICAgICAgICAgICAgICAgIGxldCB1c2VySWRzID0gYXdhaXQgZGIuVXNlci5maW5kKHtjb21wYW55SWQsIGRlbGV0ZWRBdDpudWxsLCBncm91cHM6eyAkaW46IFtncm91cElkXX19KS5zZWxlY3QoJ19pZCcpXG4gICAgICAgICAgICAgICAgY29uc29sZS5sb2coe3VzZXJJZHN9KVxuXG4gICAgICAgICAgICAgICAgbGV0IGNvdW50T2ZVc2Vyc3doaWNoQWxyZWFkeUJlbG9uZ1RvR3JvdXBXaXRoRW1haWxBY2Nlc3MgPSAwO1xuXG4gICAgICAgICAgICAgICAgaWYoYWN0aXZlR3JvdXBzT2ZDb21wYW55Lmxlbmd0aCA+IDApIGNvdW50T2ZVc2Vyc3doaWNoQWxyZWFkeUJlbG9uZ1RvR3JvdXBXaXRoRW1haWxBY2Nlc3MgPSBhd2FpdCBkYi5Vc2VyLmNvdW50RG9jdW1lbnRzKHtfaWQ6eyRpbjp1c2VySWRzfSwgY29tcGFueUlkLCBkZWxldGVkQXQ6bnVsbCwgZ3JvdXBzOnskaW46YWN0aXZlR3JvdXBzT2ZDb21wYW55fX0pIFxuICAgICAgICAgICAgICAgIGNvbnNvbGUubG9nKHtjb3VudE9mVXNlcnN3aGljaEFscmVhZHlCZWxvbmdUb0dyb3VwV2l0aEVtYWlsQWNjZXNzfSlcblxuICAgICAgICAgICAgICAgIGxldCBjb3VudE9mTmV3VXNlcnNUaGF0TmVlZFRvQmVBZGRlZCA9IE1hdGgubWF4KDAsdXNlcnNDb3VudEluR3JvdXAgLSBjb3VudE9mVXNlcnN3aGljaEFscmVhZHlCZWxvbmdUb0dyb3VwV2l0aEVtYWlsQWNjZXNzKVxuICAgICAgICAgICAgICAgIGNvbnNvbGUubG9nKHtjb3VudE9mTmV3VXNlcnNUaGF0TmVlZFRvQmVBZGRlZH0pXG5cbiAgICAgICAgICAgICAgICBpZihjb3VudE9mTmV3VXNlcnNUaGF0TmVlZFRvQmVBZGRlZCA+IHJlbWFpbmluZ0xpbWl0KSB0aHJvdyBuZXcgUmVxdWVzdEVycm9yKFwiVXNlciBMaW1pdCBFeGNlZWRlZCFcIilcbiAgICAgICAgICAgICAgICBlbHNle1xuICAgICAgICAgICAgICAgICAgICBhd2FpdCBkYi5Hcm91cC51cGRhdGVPbmUoeyBfaWQ6IGdyb3VwSWQsIGNvbXBhbnlJZH0seyRzZXQ6e2VtYWlsQWNjZXNzOiAhc3RhdHVzfX0pXG4gICAgICAgICAgICAgICAgICAgIGF3YWl0IGRiLlVzZXIudXBkYXRlTWFueSh7Z3JvdXBzOiB7JGluOiBbZ3JvdXBJZF0gfSwgY29tcGFueUlkLCBkZWxldGVkQXQ6bnVsbH0seyRzZXQ6e2lzQWN0aXZlOnRydWV9fSlcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBlbHNle1xuICAgICAgICAgICAgICAgIGF3YWl0IGRiLkdyb3VwLnVwZGF0ZU9uZSh7IF9pZDogZ3JvdXBJZCwgY29tcGFueUlkfSx7JHNldDp7ZW1haWxBY2Nlc3M6ICFzdGF0dXN9fSlcbiAgICAgICAgICAgICAgICBsZXQgYWN0aXZlR3JvdXBzT2ZDb21wYW55ID0gYXdhaXQgZGIuR3JvdXAuZmluZCh7Y29tcGFueUlkLCBkZWxldGVkQXQ6bnVsbCwgZW1haWxBY2Nlc3M6dHJ1ZX0pLnNlbGVjdChcIl9pZFwiKVxuICAgICAgICAgICAgICAgIGlmKGFjdGl2ZUdyb3Vwc09mQ29tcGFueS5sZW5ndGgpIGF3YWl0IGRiLlVzZXIudXBkYXRlTWFueSh7Z3JvdXBzOiB7JG5pbjogYWN0aXZlR3JvdXBzT2ZDb21wYW55IH0sIGNvbXBhbnlJZCwgZGVsZXRlZEF0Om51bGx9LHskc2V0Ontpc0FjdGl2ZTogZmFsc2V9fSlcbiAgICAgICAgICAgICAgICBlbHNlIGF3YWl0IGRiLlVzZXIudXBkYXRlTWFueSh7IGNvbXBhbnlJZCwgZGVsZXRlZEF0Om51bGx9LHskc2V0Ontpc0FjdGl2ZTogZmFsc2V9fSlcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgICAgICBlbHNle1xuICAgICAgICAgICAgaWYoIXN0YXR1cyl7XG4gICAgICAgICAgICAgICAgbGV0IGFjdGl2ZUdyb3Vwc09mQ29tcGFueSA9IGF3YWl0IGRiLkdyb3VwLmZpbmQoe2NvbXBhbnlJZCwgZGVsZXRlZEF0Om51bGwsIG1lc3NlbmdlckFjY2Vzczp0cnVlfSkuc2VsZWN0KFwiX2lkXCIpXG4gICAgICAgICAgICAgICAgY29uc29sZS5sb2coe2FjdGl2ZUdyb3Vwc09mQ29tcGFueX0pXG4gICAgICAgICAgICAgICAgXG4gICAgICAgICAgICAgICAgbGV0IHVzZXJzQ291bnRJbkdyb3VwID0gYXdhaXQgZGIuVXNlci5jb3VudERvY3VtZW50cyh7Y29tcGFueUlkLCBkZWxldGVkQXQ6bnVsbCwgZ3JvdXBzOnskaW46W2dyb3VwSWRdfX0pIFxuICAgICAgICAgICAgICAgIFxuICAgICAgICAgICAgICAgIGxldCB1c2VyTGltaXQgPSAoYXdhaXQgZGIuTWV0YURhdGEuZmluZE9uZSh7bmFtZTpcInVzZXJMaW1pdE1lc3NlbmdlclwiLCBjb21wYW55SWQsIGRlbGV0ZWRBdDpudWxsfSkpLnZhbHVlXG4gICAgICAgICAgICAgICAgXG4gICAgICAgICAgICAgICAgbGV0IHVzZXJDb3VudEZvckdyb3Vwc1doaWNoSGF2ZU1lc3NlbmdlckFjY2VzcyA9IDA7XG4gICAgICAgICAgICAgICAgaWYoYWN0aXZlR3JvdXBzT2ZDb21wYW55Lmxlbmd0aCA+IDApIHVzZXJDb3VudEZvckdyb3Vwc1doaWNoSGF2ZU1lc3NlbmdlckFjY2VzcyA9IGF3YWl0IGRiLlVzZXIuY291bnREb2N1bWVudHMoe2NvbXBhbnlJZCwgZGVsZXRlZEF0Om51bGwsIGdyb3Vwczp7JGluOmFjdGl2ZUdyb3Vwc09mQ29tcGFueX19KSBcbiAgICAgICAgICAgICAgICBcbiAgICAgICAgICAgICAgICBsZXQgcmVtYWluaW5nTGltaXQgPSBNYXRoLm1heCgwLHVzZXJMaW1pdCAtIHVzZXJDb3VudEZvckdyb3Vwc1doaWNoSGF2ZU1lc3NlbmdlckFjY2VzcylcblxuICAgICAgICAgICAgICAgIGxldCB1c2VySWRzID0gYXdhaXQgZGIuVXNlci5maW5kKHtjb21wYW55SWQsIGRlbGV0ZWRBdDpudWxsLCBncm91cHM6eyAkaW46IGdyb3VwSWR9fSkuc2VsZWN0KCdfaWQnKVxuXG4gICAgICAgICAgICAgICAgbGV0IGNvdW50T2ZVc2Vyc3doaWNoQWxyZWFkeUJlbG9uZ1RvR3JvdXBXaXRoTWVzc2VuZ2VyQWNjZXNzID0gMDtcbiAgICAgICAgICAgICAgICBpZihhY3RpdmVHcm91cHNPZkNvbXBhbnkubGVuZ3RoID4gMCkgY291bnRPZlVzZXJzd2hpY2hBbHJlYWR5QmVsb25nVG9Hcm91cFdpdGhNZXNzZW5nZXJBY2Nlc3MgPSBhd2FpdCBkYi5Vc2VyLmNvdW50RG9jdW1lbnRzKHtfaWQ6eyRpbjp1c2VySWRzfSwgY29tcGFueUlkLCBkZWxldGVkQXQ6bnVsbCxncm91cHM6eyRpbjphY3RpdmVHcm91cHNPZkNvbXBhbnl9fSkgXG5cbiAgICAgICAgICAgICAgICBsZXQgY291bnRPZk5ld1VzZXJzVGhhdE5lZWRUb0JlQWRkZWQgPSBNYXRoLm1heCgwLHVzZXJzQ291bnRJbkdyb3VwIC0gY291bnRPZlVzZXJzd2hpY2hBbHJlYWR5QmVsb25nVG9Hcm91cFdpdGhNZXNzZW5nZXJBY2Nlc3MpXG4gICAgICAgICAgICAgICAgY29uc29sZS5sb2coe2NvdW50T2ZOZXdVc2Vyc1RoYXROZWVkVG9CZUFkZGVkLCByZW1haW5pbmdMaW1pdH0pXG4gICAgICAgICAgICAgICAgaWYoY291bnRPZk5ld1VzZXJzVGhhdE5lZWRUb0JlQWRkZWQgPiByZW1haW5pbmdMaW1pdCkgdGhyb3cgbmV3IFJlcXVlc3RFcnJvcihcIlVzZXIgTGltaXQgRXhjZWVkZWQhXCIpXG4gICAgICAgICAgICAgICAgZWxzZXtcbiAgICAgICAgICAgICAgICAgICAgYXdhaXQgZGIuR3JvdXAudXBkYXRlT25lKHsgX2lkOiBncm91cElkLCBjb21wYW55SWR9LHskc2V0OnttZXNzZW5nZXJBY2Nlc3M6ICFzdGF0dXN9fSlcbiAgICAgICAgICAgICAgICAgICAgYXdhaXQgZGIuVXNlci51cGRhdGVNYW55KHtncm91cHM6IHskaW46IGdyb3VwSWQgfSwgY29tcGFueUlkLCBkZWxldGVkQXQ6bnVsbH0seyRzZXQ6e2lzQWN0aXZlTWVzc2VuZ2VyOnRydWV9fSlcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBlbHNle1xuICAgICAgICAgICAgICAgIGF3YWl0IGRiLkdyb3VwLnVwZGF0ZU9uZSh7IF9pZDogZ3JvdXBJZCwgY29tcGFueUlkfSx7JHNldDp7bWVzc2VuZ2VyQWNjZXNzOiAhc3RhdHVzfX0pXG4gICAgICAgICAgICAgICAgbGV0IGFjdGl2ZUdyb3Vwc09mQ29tcGFueSA9IGF3YWl0IGRiLkdyb3VwLmZpbmQoe2NvbXBhbnlJZCwgZGVsZXRlZEF0Om51bGwsIG1lc3NlbmdlckFjY2Vzczp0cnVlfSkuc2VsZWN0KFwiX2lkXCIpXG4gICAgICAgICAgICAgICAgaWYoYWN0aXZlR3JvdXBzT2ZDb21wYW55Lmxlbmd0aCkgYXdhaXQgZGIuVXNlci51cGRhdGVNYW55KHtncm91cHM6IHskbmluOiBhY3RpdmVHcm91cHNPZkNvbXBhbnkgfSwgY29tcGFueUlkLCBkZWxldGVkQXQ6bnVsbH0seyRzZXQ6e2lzQWN0aXZlTWVzc2VuZ2VyOiBmYWxzZX19KVxuICAgICAgICAgICAgICAgIGVsc2UgYXdhaXQgZGIuVXNlci51cGRhdGVNYW55KHsgY29tcGFueUlkLCBkZWxldGVkQXQ6bnVsbH0seyRzZXQ6e2lzQWN0aXZlTWVzc2VuZ2VyOiBmYWxzZX19KVxuICAgICAgICAgICAgfVxuICAgICAgICB9XG5cbiAgICAgICAgcmV0dXJuIHJlcy5zdGF0dXMoMjAwKS5zZW5kKHsgc3VjY2VzczogdHJ1ZSwgbWVzc2FnZTogYEFjY2VzcyBmb3IgJHthY2Nlc3NUeXBlfSByZXBvcnRpbmcgZm9yICR7Z3JvdXAuZ3JvdXBOYW1lfSBncm91cCBoYXMgYmVlbiBzdWNjZXNzZnVsbHkgJHshc3RhdHVzID8gJ2VuYWJsZWQnIDogJ2Rpc2FibGVkJyB9IWAgfSlcbiAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgICBjb25zb2xlLmxvZygnZXJyb3InLCBlcnJvcik7XG4gICAgICAgIG5leHQoZXJyb3IpXG4gICAgfVxufVxuXG5jb25zdCBhcGlSb3V0ZXIgPSBleHByZXNzLlJvdXRlcigpO1xuYXBpUm91dGVyLnJvdXRlKCcvJykucG9zdCggXG4gand0U3RyYXRlZ3ksXG4gcGVybWlzc2lvbignVXNlcnMnLCdXcml0ZScpLFxuIHZhbGlkYXRlQm9keSh2YWxpZGF0b3IpLCBcbiBjb250cm9sbGVyKTtcbmV4cG9ydCBkZWZhdWx0IGFwaVJvdXRlcjsiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBO0FBQ0E7QUFFQTtBQUNBO0FBQ0E7QUFFQSxJQUFNQSxTQUFTLEdBQUdDLGVBQUcsQ0FBQ0MsTUFBTSxFQUFFLENBQUNDLElBQUksQ0FBQztFQUNoQ0MsTUFBTSxFQUFFSCxlQUFHLFdBQVEsRUFBRSxDQUFDSSxRQUFRLEVBQUU7RUFDaENDLFVBQVUsRUFBRUwsZUFBRyxDQUFDTSxNQUFNLEVBQUUsQ0FBQ0YsUUFBUSxFQUFFO0VBQ25DRyxPQUFPLEVBQUVQLGVBQUcsQ0FBQ00sTUFBTSxFQUFFLENBQUNFLEdBQUcsRUFBRSxDQUFDQyxNQUFNLENBQUMsRUFBRSxDQUFDLENBQUNMLFFBQVE7QUFDbkQsQ0FBQyxDQUFDO0FBR0YsSUFBTU0sVUFBVTtFQUFBLHlGQUFHLGlCQUFPQyxHQUFHLEVBQUVDLEdBQUcsRUFBRUMsSUFBSTtJQUFBO0lBQUE7TUFBQTtRQUFBO1VBQUE7VUFBQSxZQUVRRixHQUFHLENBQUNHLElBQUksRUFBeENULFVBQVUsYUFBVkEsVUFBVSxFQUFFRSxPQUFPLGFBQVBBLE9BQU8sRUFBRUosTUFBTSxhQUFOQSxNQUFNO1VBQzNCWSxTQUFTLEdBQUtKLEdBQUcsQ0FBQ0ssSUFBSSxDQUF0QkQsU0FBUztVQUFBO1VBQUEsT0FFR0UsRUFBRSxDQUFDQyxLQUFLLENBQUNDLE9BQU8sQ0FBQztZQUFDQyxHQUFHLEVBQUViLE9BQU87WUFBRVEsU0FBUyxFQUFUQSxTQUFTO1lBQUVNLFNBQVMsRUFBRTtVQUFJLENBQUMsQ0FBQztRQUFBO1VBQTFFQyxLQUFLO1VBQUEsSUFDUEEsS0FBSztZQUFBO1lBQUE7VUFBQTtVQUFBLE1BQVEsSUFBSUMsWUFBWSxDQUFDLGlCQUFpQixFQUFDLEdBQUcsQ0FBQztRQUFBO1VBQUEsTUFFckRsQixVQUFVLElBQUksT0FBTztZQUFBO1lBQUE7VUFBQTtVQUFBLElBQ2hCRixNQUFNO1lBQUE7WUFBQTtVQUFBO1VBQUE7VUFBQSxPQUM0QmMsRUFBRSxDQUFDQyxLQUFLLENBQUNNLElBQUksQ0FBQztZQUFDVCxTQUFTLEVBQVRBLFNBQVM7WUFBRU0sU0FBUyxFQUFDLElBQUk7WUFBRUksV0FBVyxFQUFDO1VBQUksQ0FBQyxDQUFDLENBQUNDLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFBQTtVQUF4R0MscUJBQXFCO1VBQUE7VUFBQSxPQUVLVixFQUFFLENBQUNXLElBQUksQ0FBQ0MsY0FBYyxDQUFDO1lBQUNkLFNBQVMsRUFBVEEsU0FBUztZQUFFTSxTQUFTLEVBQUMsSUFBSTtZQUFFUyxNQUFNLEVBQUM7Y0FBQ0MsR0FBRyxFQUFDLENBQUN4QixPQUFPO1lBQUM7VUFBQyxDQUFDLENBQUM7UUFBQTtVQUFyR3lCLGlCQUFpQjtVQUNyQkMsT0FBTyxDQUFDQyxHQUFHLENBQUM7WUFBQ0YsaUJBQWlCLEVBQWpCQTtVQUFpQixDQUFDLENBQUM7VUFBQTtVQUFBLE9BQ1RmLEVBQUUsQ0FBQ2tCLFFBQVEsQ0FBQ2hCLE9BQU8sQ0FBQztZQUFDaUIsSUFBSSxFQUFDLFdBQVc7WUFBRWYsU0FBUyxFQUFDLElBQUk7WUFBRU4sU0FBUyxFQUFUQTtVQUFTLENBQUMsQ0FBQztRQUFBO1VBQXJGc0IsU0FBUyxpQkFBOEVDLEtBQUs7VUFDaEdMLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDO1lBQUNHLFNBQVMsRUFBVEE7VUFBUyxDQUFDLENBQUM7VUFFcEJFLHNDQUFzQyxHQUFHLENBQUM7VUFBQSxNQUUzQ1oscUJBQXFCLENBQUNsQixNQUFNLEdBQUcsQ0FBQztZQUFBO1lBQUE7VUFBQTtVQUFBO1VBQUEsT0FBaURRLEVBQUUsQ0FBQ1csSUFBSSxDQUFDQyxjQUFjLENBQUM7WUFBQ2QsU0FBUyxFQUFUQSxTQUFTO1lBQUVNLFNBQVMsRUFBQyxJQUFJO1lBQUVTLE1BQU0sRUFBQztjQUFDQyxHQUFHLEVBQUNKO1lBQXFCO1VBQUMsQ0FBQyxDQUFDO1FBQUE7VUFBdElZLHNDQUFzQztRQUFBO1VBQzNFTixPQUFPLENBQUNDLEdBQUcsQ0FBQztZQUFDSyxzQ0FBc0MsRUFBdENBO1VBQXNDLENBQUMsQ0FBQztVQUVqREMsY0FBYyxHQUFHQyxJQUFJLENBQUNDLEdBQUcsQ0FBQyxDQUFDLEVBQUNMLFNBQVMsR0FBR0Usc0NBQXNDLENBQUM7VUFDbkZOLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDO1lBQUNNLGNBQWMsRUFBZEE7VUFBYyxDQUFDLENBQUM7VUFBQTtVQUFBLE9BRVR2QixFQUFFLENBQUNXLElBQUksQ0FBQ0osSUFBSSxDQUFDO1lBQUNULFNBQVMsRUFBVEEsU0FBUztZQUFFTSxTQUFTLEVBQUMsSUFBSTtZQUFFUyxNQUFNLEVBQUM7Y0FBRUMsR0FBRyxFQUFFLENBQUN4QixPQUFPO1lBQUM7VUFBQyxDQUFDLENBQUMsQ0FBQ21CLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFBQTtVQUFqR2lCLE9BQU87VUFDWFYsT0FBTyxDQUFDQyxHQUFHLENBQUM7WUFBQ1MsT0FBTyxFQUFQQTtVQUFPLENBQUMsQ0FBQztVQUVsQkMsb0RBQW9ELEdBQUcsQ0FBQztVQUFBLE1BRXpEakIscUJBQXFCLENBQUNsQixNQUFNLEdBQUcsQ0FBQztZQUFBO1lBQUE7VUFBQTtVQUFBO1VBQUEsT0FBK0RRLEVBQUUsQ0FBQ1csSUFBSSxDQUFDQyxjQUFjLENBQUM7WUFBQ1QsR0FBRyxFQUFDO2NBQUNXLEdBQUcsRUFBQ1k7WUFBTyxDQUFDO1lBQUU1QixTQUFTLEVBQVRBLFNBQVM7WUFBRU0sU0FBUyxFQUFDLElBQUk7WUFBRVMsTUFBTSxFQUFDO2NBQUNDLEdBQUcsRUFBQ0o7WUFBcUI7VUFBQyxDQUFDLENBQUM7UUFBQTtVQUF2S2lCLG9EQUFvRDtRQUFBO1VBQ3pGWCxPQUFPLENBQUNDLEdBQUcsQ0FBQztZQUFDVSxvREFBb0QsRUFBcERBO1VBQW9ELENBQUMsQ0FBQztVQUUvREMsZ0NBQWdDLEdBQUdKLElBQUksQ0FBQ0MsR0FBRyxDQUFDLENBQUMsRUFBQ1YsaUJBQWlCLEdBQUdZLG9EQUFvRCxDQUFDO1VBQzNIWCxPQUFPLENBQUNDLEdBQUcsQ0FBQztZQUFDVyxnQ0FBZ0MsRUFBaENBO1VBQWdDLENBQUMsQ0FBQztVQUFBLE1BRTVDQSxnQ0FBZ0MsR0FBR0wsY0FBYztZQUFBO1lBQUE7VUFBQTtVQUFBLE1BQVEsSUFBSWpCLFlBQVksQ0FBQyxzQkFBc0IsQ0FBQztRQUFBO1VBQUE7VUFBQSxPQUUxRk4sRUFBRSxDQUFDQyxLQUFLLENBQUM0QixTQUFTLENBQUM7WUFBRTFCLEdBQUcsRUFBRWIsT0FBTztZQUFFUSxTQUFTLEVBQVRBO1VBQVMsQ0FBQyxFQUFDO1lBQUNnQyxJQUFJLEVBQUM7Y0FBQ3RCLFdBQVcsRUFBRSxDQUFDdEI7WUFBTTtVQUFDLENBQUMsQ0FBQztRQUFBO1VBQUE7VUFBQSxPQUM1RWMsRUFBRSxDQUFDVyxJQUFJLENBQUNvQixVQUFVLENBQUM7WUFBQ2xCLE1BQU0sRUFBRTtjQUFDQyxHQUFHLEVBQUUsQ0FBQ3hCLE9BQU87WUFBRSxDQUFDO1lBQUVRLFNBQVMsRUFBVEEsU0FBUztZQUFFTSxTQUFTLEVBQUM7VUFBSSxDQUFDLEVBQUM7WUFBQzBCLElBQUksRUFBQztjQUFDRSxRQUFRLEVBQUM7WUFBSTtVQUFDLENBQUMsQ0FBQztRQUFBO1VBQUE7VUFBQTtRQUFBO1VBQUE7VUFBQSxPQUlyR2hDLEVBQUUsQ0FBQ0MsS0FBSyxDQUFDNEIsU0FBUyxDQUFDO1lBQUUxQixHQUFHLEVBQUViLE9BQU87WUFBRVEsU0FBUyxFQUFUQTtVQUFTLENBQUMsRUFBQztZQUFDZ0MsSUFBSSxFQUFDO2NBQUN0QixXQUFXLEVBQUUsQ0FBQ3RCO1lBQU07VUFBQyxDQUFDLENBQUM7UUFBQTtVQUFBO1VBQUEsT0FDaERjLEVBQUUsQ0FBQ0MsS0FBSyxDQUFDTSxJQUFJLENBQUM7WUFBQ1QsU0FBUyxFQUFUQSxTQUFTO1lBQUVNLFNBQVMsRUFBQyxJQUFJO1lBQUVJLFdBQVcsRUFBQztVQUFJLENBQUMsQ0FBQyxDQUFDQyxNQUFNLENBQUMsS0FBSyxDQUFDO1FBQUE7VUFBeEdDLHNCQUFxQjtVQUFBLEtBQ3RCQSxzQkFBcUIsQ0FBQ2xCLE1BQU07WUFBQTtZQUFBO1VBQUE7VUFBQTtVQUFBLE9BQVFRLEVBQUUsQ0FBQ1csSUFBSSxDQUFDb0IsVUFBVSxDQUFDO1lBQUNsQixNQUFNLEVBQUU7Y0FBQ29CLElBQUksRUFBRXZCO1lBQXNCLENBQUM7WUFBRVosU0FBUyxFQUFUQSxTQUFTO1lBQUVNLFNBQVMsRUFBQztVQUFJLENBQUMsRUFBQztZQUFDMEIsSUFBSSxFQUFDO2NBQUNFLFFBQVEsRUFBRTtZQUFLO1VBQUMsQ0FBQyxDQUFDO1FBQUE7VUFBQTtVQUFBO1FBQUE7VUFBQTtVQUFBLE9BQzVJaEMsRUFBRSxDQUFDVyxJQUFJLENBQUNvQixVQUFVLENBQUM7WUFBRWpDLFNBQVMsRUFBVEEsU0FBUztZQUFFTSxTQUFTLEVBQUM7VUFBSSxDQUFDLEVBQUM7WUFBQzBCLElBQUksRUFBQztjQUFDRSxRQUFRLEVBQUU7WUFBSztVQUFDLENBQUMsQ0FBQztRQUFBO1VBQUE7VUFBQTtRQUFBO1VBQUEsSUFJcEY5QyxNQUFNO1lBQUE7WUFBQTtVQUFBO1VBQUE7VUFBQSxPQUM0QmMsRUFBRSxDQUFDQyxLQUFLLENBQUNNLElBQUksQ0FBQztZQUFDVCxTQUFTLEVBQVRBLFNBQVM7WUFBRU0sU0FBUyxFQUFDLElBQUk7WUFBRThCLGVBQWUsRUFBQztVQUFJLENBQUMsQ0FBQyxDQUFDekIsTUFBTSxDQUFDLEtBQUssQ0FBQztRQUFBO1VBQTVHQyx1QkFBcUI7VUFDekJNLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDO1lBQUNQLHFCQUFxQixFQUFyQkE7VUFBcUIsQ0FBQyxDQUFDO1VBQUE7VUFBQSxPQUVOVixFQUFFLENBQUNXLElBQUksQ0FBQ0MsY0FBYyxDQUFDO1lBQUNkLFNBQVMsRUFBVEEsU0FBUztZQUFFTSxTQUFTLEVBQUMsSUFBSTtZQUFFUyxNQUFNLEVBQUM7Y0FBQ0MsR0FBRyxFQUFDLENBQUN4QixPQUFPO1lBQUM7VUFBQyxDQUFDLENBQUM7UUFBQTtVQUFyR3lCLGtCQUFpQjtVQUFBO1VBQUEsT0FFRWYsRUFBRSxDQUFDa0IsUUFBUSxDQUFDaEIsT0FBTyxDQUFDO1lBQUNpQixJQUFJLEVBQUMsb0JBQW9CO1lBQUVyQixTQUFTLEVBQVRBLFNBQVM7WUFBRU0sU0FBUyxFQUFDO1VBQUksQ0FBQyxDQUFDO1FBQUE7VUFBOUZnQixVQUFTLGlCQUF1RkMsS0FBSztVQUVyR2MsMENBQTBDLEdBQUcsQ0FBQztVQUFBLE1BQy9DekIsdUJBQXFCLENBQUNsQixNQUFNLEdBQUcsQ0FBQztZQUFBO1lBQUE7VUFBQTtVQUFBO1VBQUEsT0FBcURRLEVBQUUsQ0FBQ1csSUFBSSxDQUFDQyxjQUFjLENBQUM7WUFBQ2QsU0FBUyxFQUFUQSxTQUFTO1lBQUVNLFNBQVMsRUFBQyxJQUFJO1lBQUVTLE1BQU0sRUFBQztjQUFDQyxHQUFHLEVBQUNKO1lBQXFCO1VBQUMsQ0FBQyxDQUFDO1FBQUE7VUFBMUl5QiwwQ0FBMEM7UUFBQTtVQUUzRVosZUFBYyxHQUFHQyxJQUFJLENBQUNDLEdBQUcsQ0FBQyxDQUFDLEVBQUNMLFVBQVMsR0FBR2UsMENBQTBDLENBQUM7VUFBQTtVQUFBLE9BRW5FbkMsRUFBRSxDQUFDVyxJQUFJLENBQUNKLElBQUksQ0FBQztZQUFDVCxTQUFTLEVBQVRBLFNBQVM7WUFBRU0sU0FBUyxFQUFDLElBQUk7WUFBRVMsTUFBTSxFQUFDO2NBQUVDLEdBQUcsRUFBRXhCO1lBQU87VUFBQyxDQUFDLENBQUMsQ0FBQ21CLE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFBQTtVQUEvRmlCLFFBQU87VUFFUFUsd0RBQXdELEdBQUcsQ0FBQztVQUFBLE1BQzdEMUIsdUJBQXFCLENBQUNsQixNQUFNLEdBQUcsQ0FBQztZQUFBO1lBQUE7VUFBQTtVQUFBO1VBQUEsT0FBbUVRLEVBQUUsQ0FBQ1csSUFBSSxDQUFDQyxjQUFjLENBQUM7WUFBQ1QsR0FBRyxFQUFDO2NBQUNXLEdBQUcsRUFBQ1k7WUFBTyxDQUFDO1lBQUU1QixTQUFTLEVBQVRBLFNBQVM7WUFBRU0sU0FBUyxFQUFDLElBQUk7WUFBQ1MsTUFBTSxFQUFDO2NBQUNDLEdBQUcsRUFBQ0o7WUFBcUI7VUFBQyxDQUFDLENBQUM7UUFBQTtVQUExSzBCLHdEQUF3RDtRQUFBO1VBRXpGUixpQ0FBZ0MsR0FBR0osSUFBSSxDQUFDQyxHQUFHLENBQUMsQ0FBQyxFQUFDVixrQkFBaUIsR0FBR3FCLHdEQUF3RCxDQUFDO1VBQy9IcEIsT0FBTyxDQUFDQyxHQUFHLENBQUM7WUFBQ1csZ0NBQWdDLEVBQWhDQSxpQ0FBZ0M7WUFBRUwsY0FBYyxFQUFkQTtVQUFjLENBQUMsQ0FBQztVQUFBLE1BQzVESyxpQ0FBZ0MsR0FBR0wsZUFBYztZQUFBO1lBQUE7VUFBQTtVQUFBLE1BQVEsSUFBSWpCLFlBQVksQ0FBQyxzQkFBc0IsQ0FBQztRQUFBO1VBQUE7VUFBQSxPQUUxRk4sRUFBRSxDQUFDQyxLQUFLLENBQUM0QixTQUFTLENBQUM7WUFBRTFCLEdBQUcsRUFBRWIsT0FBTztZQUFFUSxTQUFTLEVBQVRBO1VBQVMsQ0FBQyxFQUFDO1lBQUNnQyxJQUFJLEVBQUM7Y0FBQ0ksZUFBZSxFQUFFLENBQUNoRDtZQUFNO1VBQUMsQ0FBQyxDQUFDO1FBQUE7VUFBQTtVQUFBLE9BQ2hGYyxFQUFFLENBQUNXLElBQUksQ0FBQ29CLFVBQVUsQ0FBQztZQUFDbEIsTUFBTSxFQUFFO2NBQUNDLEdBQUcsRUFBRXhCO1lBQVEsQ0FBQztZQUFFUSxTQUFTLEVBQVRBLFNBQVM7WUFBRU0sU0FBUyxFQUFDO1VBQUksQ0FBQyxFQUFDO1lBQUMwQixJQUFJLEVBQUM7Y0FBQ08saUJBQWlCLEVBQUM7WUFBSTtVQUFDLENBQUMsQ0FBQztRQUFBO1VBQUE7VUFBQTtRQUFBO1VBQUE7VUFBQSxPQUk1R3JDLEVBQUUsQ0FBQ0MsS0FBSyxDQUFDNEIsU0FBUyxDQUFDO1lBQUUxQixHQUFHLEVBQUViLE9BQU87WUFBRVEsU0FBUyxFQUFUQTtVQUFTLENBQUMsRUFBQztZQUFDZ0MsSUFBSSxFQUFDO2NBQUNJLGVBQWUsRUFBRSxDQUFDaEQ7WUFBTTtVQUFDLENBQUMsQ0FBQztRQUFBO1VBQUE7VUFBQSxPQUNwRGMsRUFBRSxDQUFDQyxLQUFLLENBQUNNLElBQUksQ0FBQztZQUFDVCxTQUFTLEVBQVRBLFNBQVM7WUFBRU0sU0FBUyxFQUFDLElBQUk7WUFBRThCLGVBQWUsRUFBQztVQUFJLENBQUMsQ0FBQyxDQUFDekIsTUFBTSxDQUFDLEtBQUssQ0FBQztRQUFBO1VBQTVHQyx1QkFBcUI7VUFBQSxLQUN0QkEsdUJBQXFCLENBQUNsQixNQUFNO1lBQUE7WUFBQTtVQUFBO1VBQUE7VUFBQSxPQUFRUSxFQUFFLENBQUNXLElBQUksQ0FBQ29CLFVBQVUsQ0FBQztZQUFDbEIsTUFBTSxFQUFFO2NBQUNvQixJQUFJLEVBQUV2QjtZQUFzQixDQUFDO1lBQUVaLFNBQVMsRUFBVEEsU0FBUztZQUFFTSxTQUFTLEVBQUM7VUFBSSxDQUFDLEVBQUM7WUFBQzBCLElBQUksRUFBQztjQUFDTyxpQkFBaUIsRUFBRTtZQUFLO1VBQUMsQ0FBQyxDQUFDO1FBQUE7VUFBQTtVQUFBO1FBQUE7VUFBQTtVQUFBLE9BQ3JKckMsRUFBRSxDQUFDVyxJQUFJLENBQUNvQixVQUFVLENBQUM7WUFBRWpDLFNBQVMsRUFBVEEsU0FBUztZQUFFTSxTQUFTLEVBQUM7VUFBSSxDQUFDLEVBQUM7WUFBQzBCLElBQUksRUFBQztjQUFDTyxpQkFBaUIsRUFBRTtZQUFLO1VBQUMsQ0FBQyxDQUFDO1FBQUE7VUFBQSxpQ0FJOUYxQyxHQUFHLENBQUNULE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQ29ELElBQUksQ0FBQztZQUFFQyxPQUFPLEVBQUUsSUFBSTtZQUFFQyxPQUFPLHVCQUFnQnBELFVBQVUsNEJBQWtCaUIsS0FBSyxDQUFDb0MsU0FBUywwQ0FBZ0MsQ0FBQ3ZELE1BQU0sR0FBRyxTQUFTLEdBQUcsVUFBVTtVQUFLLENBQUMsQ0FBQztRQUFBO1VBQUE7VUFBQTtVQUV0TDhCLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDLE9BQU8sY0FBUTtVQUMzQnJCLElBQUksYUFBTztRQUFBO1FBQUE7VUFBQTtNQUFBO0lBQUE7RUFBQSxDQUVsQjtFQUFBLGdCQXpGS0gsVUFBVTtJQUFBO0VBQUE7QUFBQSxHQXlGZjtBQUVELElBQU1pRCxTQUFTLEdBQUdDLG1CQUFPLENBQUNDLE1BQU0sRUFBRTtBQUNsQ0YsU0FBUyxDQUFDRyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUNDLElBQUksQ0FDeEJDLHFCQUFXLEVBQ1gsSUFBQUMsc0JBQVUsRUFBQyxPQUFPLEVBQUMsT0FBTyxDQUFDLEVBQzNCLElBQUFDLHVCQUFZLEVBQUNuRSxTQUFTLENBQUMsRUFDdkJXLFVBQVUsQ0FBQztBQUFDLGVBQ0VpRCxTQUFTO0FBQUEifQ==