"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _strategy = require("../../middlewares/strategy");
var _permission = require("../../middlewares/permission");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(req, res, next) {
    var _groupsWithUserCount, _customGroupsWithUser, _req$body, search, page, _req$body$limit, limit, companyId, isTacEnabled, condition, regex, groups, customGroups, groupsWithUserCount, customGroupsWithUserCount, adminGroupsCount, customGroupsCount, allSyncingFalse, isLastSyncIdMismatchInAnyGroup, showRetrySyncing, showSyncingInProgress;
    return _regenerator["default"].wrap(function _callee3$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          _context3.prev = 0;
          _req$body = req.body, search = _req$body.search, page = _req$body.page, _req$body$limit = _req$body.limit, limit = _req$body$limit === void 0 ? 10 : _req$body$limit;
          companyId = req.user.companyId;
          _context3.next = 5;
          return db.Company.findOne({
            _id: companyId,
            deletedAt: null
          });
        case 5:
          isTacEnabled = _context3.sent.isTacEnabled;
          condition = {
            companyId: companyId,
            deletedAt: null,
            type: 'Admin'
          };
          if (search && search.length) {
            regex = new RegExp(search, "i");
            condition['$or'] = [{
              groupName: regex
            }];
          }
          _context3.next = 10;
          return db.Group.find(condition).lean().skip((page - 1) * limit).limit(limit);
        case 10:
          groups = _context3.sent;
          customGroups = [];
          if (!isTacEnabled) {
            _context3.next = 16;
            break;
          }
          _context3.next = 15;
          return db.Group.find(_objectSpread(_objectSpread({}, condition), {}, {
            type: "Custom"
          })).lean().skip((page - 1) * limit).limit(limit);
        case 15:
          customGroups = _context3.sent;
        case 16:
          _context3.next = 18;
          return Promise.all(groups.map( /*#__PURE__*/function () {
            var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(group) {
              var userCount;
              return _regenerator["default"].wrap(function _callee$(_context) {
                while (1) switch (_context.prev = _context.next) {
                  case 0:
                    _context.next = 2;
                    return db.User.countDocuments({
                      companyId: companyId,
                      groups: {
                        $in: [group._id]
                      },
                      deletedAt: null
                    });
                  case 2:
                    userCount = _context.sent;
                    return _context.abrupt("return", _objectSpread(_objectSpread({}, group), {}, {
                      userCount: userCount
                    }));
                  case 4:
                  case "end":
                    return _context.stop();
                }
              }, _callee);
            }));
            return function (_x4) {
              return _ref2.apply(this, arguments);
            };
          }()));
        case 18:
          groupsWithUserCount = _context3.sent;
          if (!customGroups.length) {
            _context3.next = 23;
            break;
          }
          _context3.next = 22;
          return Promise.all(customGroups.map( /*#__PURE__*/function () {
            var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(group) {
              var userCount;
              return _regenerator["default"].wrap(function _callee2$(_context2) {
                while (1) switch (_context2.prev = _context2.next) {
                  case 0:
                    _context2.next = 2;
                    return db.User.countDocuments({
                      companyId: companyId,
                      groups: {
                        $in: [group._id]
                      },
                      deletedAt: null
                    });
                  case 2:
                    userCount = _context2.sent;
                    return _context2.abrupt("return", _objectSpread(_objectSpread({}, group), {}, {
                      userCount: userCount
                    }));
                  case 4:
                  case "end":
                    return _context2.stop();
                }
              }, _callee2);
            }));
            return function (_x5) {
              return _ref3.apply(this, arguments);
            };
          }()));
        case 22:
          customGroupsWithUserCount = _context3.sent;
        case 23:
          _context3.next = 25;
          return db.Group.countDocuments(condition);
        case 25:
          adminGroupsCount = _context3.sent;
          _context3.next = 28;
          return db.Group.countDocuments(_objectSpread(_objectSpread({}, condition), {}, {
            type: "Custom"
          }));
        case 28:
          customGroupsCount = _context3.sent;
          allSyncingFalse = groupsWithUserCount.every(function (group) {
            return group.isSyncingUsers == false;
          });
          isLastSyncIdMismatchInAnyGroup = groupsWithUserCount.some(function (group) {
            return group.lastSyncIdMismatch === true;
          });
          showRetrySyncing = allSyncingFalse && isLastSyncIdMismatchInAnyGroup;
          showSyncingInProgress = false;
          if (groupsWithUserCount.length) showSyncingInProgress = groupsWithUserCount.every(function (group) {
            return group.isSyncingUsers == true;
          });
          groupsWithUserCount = (_groupsWithUserCount = groupsWithUserCount) === null || _groupsWithUserCount === void 0 ? void 0 : _groupsWithUserCount.filter(function (group) {
            return group.groupName !== 'Individual-Users';
          });
          customGroupsWithUserCount = (_customGroupsWithUser = customGroupsWithUserCount) === null || _customGroupsWithUser === void 0 ? void 0 : _customGroupsWithUser.filter(function (group) {
            return group.groupName !== 'Individual-Users';
          });
          res.status(200).json({
            success: true,
            adminGroups: groupsWithUserCount,
            customGroups: customGroupsWithUserCount ? customGroupsWithUserCount : [],
            adminGroupsCount: adminGroupsCount,
            customGroupsCount: customGroupsCount,
            showRetrySyncing: showRetrySyncing,
            showSyncingInProgress: showSyncingInProgress
          });
          _context3.next = 43;
          break;
        case 39:
          _context3.prev = 39;
          _context3.t0 = _context3["catch"](0);
          console.log(_context3.t0);
          next(_context3.t0);
        case 43:
        case "end":
          return _context3.stop();
      }
    }, _callee3, null, [[0, 39]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy, (0, _permission.permission)('IAM', 'Read'), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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