"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _mongoose = _interopRequireDefault(require("mongoose"));
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _permission = require("../../middlewares/permission");
var validator = _joi["default"].object().keys({
  page: _joi["default"].number().min(0).required(),
  limit: _joi["default"].number().min(1).required(),
  domains: _joi["default"].array().optional(),
  group: _joi["default"].string().optional(),
  subDomainGroups: _joi["default"].array().optional(),
  search: _joi["default"].string().optional().allow(null).empty(''),
  status: _joi["default"].string().optional().allow(null).empty('')
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, userId, groupId, companyId, group, user, updatedUser, activeGroupsOfCompanyWithEmailAccess, activeGroupsOfCompanyWithMessengerAccess, emailGroupIds, messengerGroupIds, userGroupIds, countUsersInCurrentGroup;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _req$body = req.body, userId = _req$body.userId, groupId = _req$body.groupId;
          companyId = req.user.companyId;
          _context.prev = 2;
          _context.next = 5;
          return db.Group.findOne({
            _id: groupId,
            companyId: companyId
          });
        case 5:
          group = _context.sent;
          if (group) {
            _context.next = 8;
            break;
          }
          throw new RequestError("Group not found!");
        case 8:
          _context.next = 10;
          return db.User.findOne({
            _id: userId,
            companyId: companyId
          });
        case 10:
          user = _context.sent;
          if (user) {
            _context.next = 13;
            break;
          }
          throw new RequestError("User not found!");
        case 13:
          _context.next = 15;
          return db.User.findOneAndUpdate({
            _id: userId
          }, {
            $pull: {
              groups: _mongoose["default"].Types.ObjectId(groupId)
            }
          }, {
            "new": true
          });
        case 15:
          updatedUser = _context.sent;
          if (updatedUser) {
            _context.next = 18;
            break;
          }
          throw new RequestError("User not updated!");
        case 18:
          _context.next = 20;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            emailAccess: true
          }).select("_id");
        case 20:
          activeGroupsOfCompanyWithEmailAccess = _context.sent;
          _context.next = 23;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            messengerAccess: true
          }).select("_id");
        case 23:
          activeGroupsOfCompanyWithMessengerAccess = _context.sent;
          // Map IDs to strings for comparison
          emailGroupIds = activeGroupsOfCompanyWithEmailAccess.map(function (group) {
            return group._id.toString();
          });
          messengerGroupIds = activeGroupsOfCompanyWithMessengerAccess.map(function (group) {
            return group._id.toString();
          });
          userGroupIds = updatedUser.groups.map(function (groupId) {
            return groupId.toString();
          });
          console.log({
            userGroupIds: userGroupIds
          });

          // Check and update user's email and messenger activity status
          if (!(emailGroupIds.length > 0 && !emailGroupIds.some(function (groupId) {
            return userGroupIds.includes(groupId);
          }))) {
            _context.next = 31;
            break;
          }
          _context.next = 31;
          return db.User.updateOne({
            _id: userId,
            companyId: companyId
          }, {
            $set: {
              isActive: false
            }
          });
        case 31:
          if (!(messengerGroupIds.length > 0 && !messengerGroupIds.some(function (groupId) {
            return userGroupIds.includes(groupId);
          }))) {
            _context.next = 34;
            break;
          }
          _context.next = 34;
          return db.User.updateOne({
            _id: userId,
            companyId: companyId
          }, {
            $set: {
              isActiveMessenger: false
            }
          });
        case 34:
          _context.next = 36;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: [groupId]
            }
          });
        case 36:
          countUsersInCurrentGroup = _context.sent;
          // if (!countUsersInCurrentGroup) {
          //     await db.Group.deleteOne({ _id: groupId, companyId });
          // }

          res.status(200).send({
            message: "User and group updated successfully!",
            areThereUsersInCurrentGroup: countUsersInCurrentGroup != 0
          });
          _context.next = 44;
          break;
        case 40:
          _context.prev = 40;
          _context.t0 = _context["catch"](2);
          console.error(_context.t0);
          next(_context.t0);
        case 44:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[2, 40]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post(_strategy.jwtStrategy,
// checkTaConnectionStrategy, 
(0, _permission.permission)('Users', 'Read'),
//  validateBody(validator), 
controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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