"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _hackRecord = _interopRequireDefault(require("../../service/hack-record"));
var _validator = require("../../middlewares/validator");
var validator = _joi["default"].object().keys({
  email: _joi["default"].string().email().required()
});

/**
 * @api {post} /api/v1/hack-record/get get
 * @apiName get-hackrecord
 * @apiGroup Hack Record
 * @apiDescription Get hack records
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}  email   Required Email whose hack records are to be fetched 
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  message    []
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "results": "[]"
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    results    []
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "Request failed with status code 500"
 *          ]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var email;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          email = req.body.email;
          _hackRecord["default"].getHackRecord(email).then(function (results) {
            res.status(200).json({
              succees: true,
              results: results.data
            });
          })["catch"](function (err) {
            console.log(err);
            next(err);
          });
        case 2:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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