"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  status: _joi["default"]["boolean"]().required(),
  licenceKey: _joi["default"].string().required(),
  domainId: _joi["default"].string().hex().length(24).required()
});
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var _req$body, licenceKey, domainId, _req$body$status, status, company, domain;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _req$body = req.body, licenceKey = _req$body.licenceKey, domainId = _req$body.domainId, _req$body$status = _req$body.status, status = _req$body$status === void 0 ? false : _req$body$status;
          _context.next = 4;
          return db.Company.findOne({
            licenceKey: licenceKey
          });
        case 4:
          company = _context.sent;
          if (company) {
            _context.next = 7;
            break;
          }
          throw new RequestError('invalid licence key or not find any company from this licence key');
        case 7:
          _context.next = 9;
          return db.Domain.findOne({
            _id: domainId
          });
        case 9:
          domain = _context.sent;
          if (domain) {
            _context.next = 12;
            break;
          }
          throw new RequestError('invalid domainId recieved');
        case 12:
          domain.set({
            'isVerified': status
          });
          domain.save();
          res.status(200).json({
            success: true,
            message: 'domain status changed successfully'
          });
          _context.next = 21;
          break;
        case 17:
          _context.prev = 17;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 21:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 17]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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