"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var licenceKey, company, domains;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          licenceKey = req.params.licenceKey;
          _context.next = 4;
          return db.Company.findOne({
            licenceKey: licenceKey
          });
        case 4:
          company = _context.sent;
          if (company) {
            _context.next = 7;
            break;
          }
          throw new RequestError('invalid licence key or not find any company from this licence key');
        case 7:
          _context.next = 9;
          return db.Domain.find({
            companyId: company._id,
            deletedAt: null
          });
        case 9:
          domains = _context.sent;
          res.status(200).json({
            success: true,
            domains: domains
          });
          _context.next = 17;
          break;
        case 13:
          _context.prev = 13;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 17:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 13]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/:licenceKey').get((0, _sanitizeHtml.htmlsanitize)(), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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