"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _validator = require("../../middlewares/validator");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var validator = _joi["default"].object().keys({
  userLimit: _joi["default"].number().required(),
  domainLimit: _joi["default"].number().required(),
  expiredAt: _joi["default"].date().iso().required(),
  licenceKey: _joi["default"].string().required()
});
var changeActiveStatus = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(companyId) {
    var userLimit, activatedUsersCount, count, user, i;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          _context.next = 3;
          return db.MetaData.findOne({
            companyId: companyId,
            name: "userLimit"
          });
        case 3:
          userLimit = _context.sent.value;
          _context.next = 6;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            isActive: true
          });
        case 6:
          activatedUsersCount = _context.sent;
          if (!(activatedUsersCount > userLimit)) {
            _context.next = 20;
            break;
          }
          count = activatedUsersCount - userLimit;
          _context.next = 11;
          return db.User.find({
            companyId: companyId,
            isActive: true,
            deletedAt: null
          }).sort({
            createdAt: -1
          }).limit(count);
        case 11:
          user = _context.sent;
          i = 0;
        case 13:
          if (!(i < user.length)) {
            _context.next = 20;
            break;
          }
          user[i].isActive = false;
          _context.next = 17;
          return user[i].save();
        case 17:
          i++;
          _context.next = 13;
          break;
        case 20:
          _context.next = 25;
          break;
        case 22:
          _context.prev = 22;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
        case 25:
          _context.prev = 25;
          return _context.abrupt("return");
        case 28:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 22, 25, 28]]);
  }));
  return function changeActiveStatus(_x) {
    return _ref.apply(this, arguments);
  };
}();
var controller = /*#__PURE__*/function () {
  var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(req, res, next) {
    var _req$body, licenceKey, userLimit, domainLimit, expiredAt, company, companyId, metadataUser, metadataDomain, metadataExpiretAt;
    return _regenerator["default"].wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _context2.prev = 0;
          _req$body = req.body, licenceKey = _req$body.licenceKey, userLimit = _req$body.userLimit, domainLimit = _req$body.domainLimit, expiredAt = _req$body.expiredAt;
          _context2.next = 4;
          return db.Company.findOne({
            licenceKey: licenceKey
          });
        case 4:
          company = _context2.sent;
          if (company) {
            _context2.next = 7;
            break;
          }
          throw new RequestError('invalid licence key or not find any company from this licence key');
        case 7:
          companyId = company._id;
          _context2.next = 10;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'userLimit'
          });
        case 10:
          metadataUser = _context2.sent;
          if (!metadataUser) {
            _context2.next = 19;
            break;
          }
          metadataUser.set({
            value: userLimit
          });
          _context2.next = 15;
          return metadataUser.save();
        case 15:
          _context2.next = 17;
          return changeActiveStatus(companyId);
        case 17:
          _context2.next = 21;
          break;
        case 19:
          _context2.next = 21;
          return db.MetaData.create({
            companyId: companyId,
            name: 'userLimit',
            value: userLimit
          });
        case 21:
          _context2.next = 23;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'domainLimit'
          });
        case 23:
          metadataDomain = _context2.sent;
          if (!metadataDomain) {
            _context2.next = 30;
            break;
          }
          metadataDomain.set({
            value: domainLimit
          });
          _context2.next = 28;
          return metadataDomain.save();
        case 28:
          _context2.next = 32;
          break;
        case 30:
          _context2.next = 32;
          return db.MetaData.create({
            companyId: companyId,
            name: 'domainLimit',
            value: domainLimit
          });
        case 32:
          _context2.next = 34;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'expiredAt'
          });
        case 34:
          metadataExpiretAt = _context2.sent;
          if (!metadataExpiretAt) {
            _context2.next = 41;
            break;
          }
          metadataExpiretAt.set({
            value: new Date(expiredAt)
          });
          _context2.next = 39;
          return metadataExpiretAt.save();
        case 39:
          _context2.next = 43;
          break;
        case 41:
          _context2.next = 43;
          return db.MetaData.create({
            companyId: companyId,
            name: 'expiredAt',
            value: new Date(expiredAt)
          });
        case 43:
          res.status(200).json({
            success: true,
            message: 'licence updated successfully'
          });
          _context2.next = 50;
          break;
        case 46:
          _context2.prev = 46;
          _context2.t0 = _context2["catch"](0);
          console.log(_context2.t0);
          next(_context2.t0);
        case 50:
        case "end":
          return _context2.stop();
      }
    }, _callee2, null, [[0, 46]]);
  }));
  return function controller(_x2, _x3, _x4) {
    return _ref2.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJ2YWxpZGF0b3IiLCJKb2kiLCJvYmplY3QiLCJrZXlzIiwidXNlckxpbWl0IiwibnVtYmVyIiwicmVxdWlyZWQiLCJkb21haW5MaW1pdCIsImV4cGlyZWRBdCIsImRhdGUiLCJpc28iLCJsaWNlbmNlS2V5Iiwic3RyaW5nIiwiY2hhbmdlQWN0aXZlU3RhdHVzIiwiY29tcGFueUlkIiwiZGIiLCJNZXRhRGF0YSIsImZpbmRPbmUiLCJuYW1lIiwidmFsdWUiLCJVc2VyIiwiY291bnREb2N1bWVudHMiLCJkZWxldGVkQXQiLCJpc0FjdGl2ZSIsImFjdGl2YXRlZFVzZXJzQ291bnQiLCJjb3VudCIsImZpbmQiLCJzb3J0IiwiY3JlYXRlZEF0IiwibGltaXQiLCJ1c2VyIiwiaSIsImxlbmd0aCIsInNhdmUiLCJjb25zb2xlIiwibG9nIiwiY29udHJvbGxlciIsInJlcSIsInJlcyIsIm5leHQiLCJib2R5IiwiQ29tcGFueSIsImNvbXBhbnkiLCJSZXF1ZXN0RXJyb3IiLCJfaWQiLCJtZXRhZGF0YVVzZXIiLCJzZXQiLCJjcmVhdGUiLCJtZXRhZGF0YURvbWFpbiIsIm1ldGFkYXRhRXhwaXJldEF0IiwiRGF0ZSIsInN0YXR1cyIsImpzb24iLCJzdWNjZXNzIiwibWVzc2FnZSIsImFwaVJvdXRlciIsImV4cHJlc3MiLCJSb3V0ZXIiLCJyb3V0ZSIsInBvc3QiLCJodG1sc2FuaXRpemUiLCJ2YWxpZGF0ZUJvZHkiXSwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvYXBpL2xpY2VuY2UvdXBkYXRlLWxpY2VuY2UuanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IEpvaSBmcm9tICdqb2knO1xuaW1wb3J0IGV4cHJlc3MgZnJvbSAnZXhwcmVzcyc7XG5cbmltcG9ydCB7IHNhbml0aXplIH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvc2FuaXRpemVyJztcbmltcG9ydCB7IHZhbGlkYXRlQm9keSB9IGZyb20gJy4uLy4uL21pZGRsZXdhcmVzL3ZhbGlkYXRvcic7XG5pbXBvcnQgeyBodG1sc2FuaXRpemUgfSBmcm9tICcuLi8uLi9taWRkbGV3YXJlcy9zYW5pdGl6ZUh0bWwnO1xuXG5sZXQgdmFsaWRhdG9yID0gSm9pLm9iamVjdCgpLmtleXMoe1xuICAgIHVzZXJMaW1pdDogSm9pLm51bWJlcigpLnJlcXVpcmVkKCksXG4gICAgZG9tYWluTGltaXQ6IEpvaS5udW1iZXIoKS5yZXF1aXJlZCgpLFxuICAgIGV4cGlyZWRBdDogSm9pLmRhdGUoKS5pc28oKS5yZXF1aXJlZCgpLFxuICAgIGxpY2VuY2VLZXk6IEpvaS5zdHJpbmcoKS5yZXF1aXJlZCgpLFxufSk7XG5cbmxldCBjaGFuZ2VBY3RpdmVTdGF0dXMgPSBhc3luYyAoY29tcGFueUlkKSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgICAgY29uc3QgdXNlckxpbWl0ID0gKGF3YWl0IGRiLk1ldGFEYXRhLmZpbmRPbmUoeyBjb21wYW55SWQsIG5hbWU6IFwidXNlckxpbWl0XCIgfSkpLnZhbHVlO1xuICAgICAgICBjb25zdCBhY3RpdmF0ZWRVc2Vyc0NvdW50ID0gYXdhaXQgZGIuVXNlci5jb3VudERvY3VtZW50cyh7IGNvbXBhbnlJZCwgZGVsZXRlZEF0OiBudWxsLCBpc0FjdGl2ZTogdHJ1ZSB9KTtcbiAgICAgICAgaWYgKGFjdGl2YXRlZFVzZXJzQ291bnQgPiB1c2VyTGltaXQpIHtcbiAgICAgICAgICAgIGNvbnN0IGNvdW50ID0gYWN0aXZhdGVkVXNlcnNDb3VudCAtIHVzZXJMaW1pdFxuICAgICAgICAgICAgY29uc3QgdXNlciA9IGF3YWl0IGRiLlVzZXIuZmluZCh7IGNvbXBhbnlJZCwgaXNBY3RpdmU6IHRydWUsIGRlbGV0ZWRBdDpudWxsIH0pLnNvcnQoeyBjcmVhdGVkQXQ6IC0xIH0pLmxpbWl0KGNvdW50KVxuICAgICAgICAgICAgZm9yIChsZXQgaSA9IDA7IGkgPCB1c2VyLmxlbmd0aDsgaSsrKSB7XG4gICAgICAgICAgICAgICAgdXNlcltpXS5pc0FjdGl2ZSA9IGZhbHNlXG4gICAgICAgICAgICAgICAgYXdhaXQgdXNlcltpXS5zYXZlKClcbiAgICAgICAgICAgIH1cbiAgICAgICAgfVxuICAgIH0gY2F0Y2ggKGVycm9yKSB7XG4gICAgICAgIGNvbnNvbGUubG9nKGVycm9yKTtcbiAgICB9IGZpbmFsbHkge1xuICAgICAgICByZXR1cm4gO1xuICAgIH1cbn1cbmxldCBjb250cm9sbGVyID0gYXN5bmMgKHJlcSwgcmVzLCBuZXh0KSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgICAgY29uc3QgeyBsaWNlbmNlS2V5LCB1c2VyTGltaXQsIGRvbWFpbkxpbWl0LCBleHBpcmVkQXQgfSA9IHJlcS5ib2R5O1xuICAgICAgICBjb25zdCBjb21wYW55ID0gYXdhaXQgZGIuQ29tcGFueS5maW5kT25lKHtcbiAgICAgICAgICAgIGxpY2VuY2VLZXlcbiAgICAgICAgfSlcbiAgICAgICAgaWYoIWNvbXBhbnkpe1xuICAgICAgICAgICAgdGhyb3cgbmV3IFJlcXVlc3RFcnJvcignaW52YWxpZCBsaWNlbmNlIGtleSBvciBub3QgZmluZCBhbnkgY29tcGFueSBmcm9tIHRoaXMgbGljZW5jZSBrZXknKVxuICAgICAgICB9XG4gICAgICAgIGNvbnN0IGNvbXBhbnlJZCA9IGNvbXBhbnkuX2lkO1xuXG4gICAgICAgIGNvbnN0IG1ldGFkYXRhVXNlciA9IGF3YWl0IGRiLk1ldGFEYXRhLmZpbmRPbmUoe1xuICAgICAgICAgICAgY29tcGFueUlkLFxuICAgICAgICAgICAgbmFtZTogJ3VzZXJMaW1pdCdcbiAgICAgICAgfSlcblxuICAgICAgICBpZihtZXRhZGF0YVVzZXIpe1xuICAgICAgICAgICAgbWV0YWRhdGFVc2VyLnNldCh7XG4gICAgICAgICAgICAgICAgdmFsdWU6IHVzZXJMaW1pdFxuICAgICAgICAgICAgfSlcbiAgICAgICAgICAgIGF3YWl0IG1ldGFkYXRhVXNlci5zYXZlKCk7XG4gICAgICAgICAgICBhd2FpdCBjaGFuZ2VBY3RpdmVTdGF0dXMoY29tcGFueUlkKVxuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgYXdhaXQgZGIuTWV0YURhdGEuY3JlYXRlKHtcbiAgICAgICAgICAgICAgICBjb21wYW55SWQsIFxuICAgICAgICAgICAgICAgIG5hbWU6ICd1c2VyTGltaXQnLCBcbiAgICAgICAgICAgICAgICB2YWx1ZTogdXNlckxpbWl0XG4gICAgICAgICAgICB9KVxuICAgICAgICB9XG5cbiAgICAgICAgY29uc3QgbWV0YWRhdGFEb21haW4gPSBhd2FpdCBkYi5NZXRhRGF0YS5maW5kT25lKHtcbiAgICAgICAgICAgIGNvbXBhbnlJZCxcbiAgICAgICAgICAgIG5hbWU6ICdkb21haW5MaW1pdCdcbiAgICAgICAgfSlcblxuICAgICAgICBpZihtZXRhZGF0YURvbWFpbil7XG4gICAgICAgICAgICBtZXRhZGF0YURvbWFpbi5zZXQoe1xuICAgICAgICAgICAgICAgIHZhbHVlOiBkb21haW5MaW1pdFxuICAgICAgICAgICAgfSlcbiAgICAgICAgICAgIGF3YWl0IG1ldGFkYXRhRG9tYWluLnNhdmUoKTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICAgIGF3YWl0IGRiLk1ldGFEYXRhLmNyZWF0ZSh7XG4gICAgICAgICAgICAgICAgY29tcGFueUlkLCBcbiAgICAgICAgICAgICAgICBuYW1lOiAnZG9tYWluTGltaXQnLCBcbiAgICAgICAgICAgICAgICB2YWx1ZTogZG9tYWluTGltaXRcbiAgICAgICAgICAgIH0pXG4gICAgICAgIH1cblxuICAgICAgICBjb25zdCBtZXRhZGF0YUV4cGlyZXRBdCA9IGF3YWl0IGRiLk1ldGFEYXRhLmZpbmRPbmUoe1xuICAgICAgICAgICAgY29tcGFueUlkLFxuICAgICAgICAgICAgbmFtZTogJ2V4cGlyZWRBdCdcbiAgICAgICAgfSlcblxuICAgICAgICBpZihtZXRhZGF0YUV4cGlyZXRBdCl7XG4gICAgICAgICAgICBtZXRhZGF0YUV4cGlyZXRBdC5zZXQoe1xuICAgICAgICAgICAgICAgIHZhbHVlOiBuZXcgRGF0ZShleHBpcmVkQXQpXG4gICAgICAgICAgICB9KVxuICAgICAgICAgICAgYXdhaXQgbWV0YWRhdGFFeHBpcmV0QXQuc2F2ZSgpO1xuICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgYXdhaXQgZGIuTWV0YURhdGEuY3JlYXRlKHtcbiAgICAgICAgICAgICAgICBjb21wYW55SWQsIFxuICAgICAgICAgICAgICAgIG5hbWU6ICdleHBpcmVkQXQnLCBcbiAgICAgICAgICAgICAgICB2YWx1ZTogbmV3IERhdGUoZXhwaXJlZEF0KVxuICAgICAgICAgICAgfSlcbiAgICAgICAgfVxuXG4gICAgICAgIHJlcy5zdGF0dXMoMjAwKS5qc29uKHsgc3VjY2VzczogdHJ1ZSwgbWVzc2FnZTogJ2xpY2VuY2UgdXBkYXRlZCBzdWNjZXNzZnVsbHknIH0pO1xuXG4gICAgfSBjYXRjaCAoZXJyKSB7XG4gICAgICAgIGNvbnNvbGUubG9nKGVycik7XG4gICAgICAgIG5leHQoZXJyKVxuICAgIH1cbn1cblxuY29uc3QgYXBpUm91dGVyID0gZXhwcmVzcy5Sb3V0ZXIoKTtcbmFwaVJvdXRlci5yb3V0ZSgnLycpLnBvc3QoaHRtbHNhbml0aXplKCkgLCB2YWxpZGF0ZUJvZHkodmFsaWRhdG9yKSwgY29udHJvbGxlcik7XG5leHBvcnQgZGVmYXVsdCBhcGlSb3V0ZXI7Il0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7QUFBQTtBQUNBO0FBRUE7QUFDQTtBQUNBO0FBRUEsSUFBSUEsU0FBUyxHQUFHQyxlQUFHLENBQUNDLE1BQU0sRUFBRSxDQUFDQyxJQUFJLENBQUM7RUFDOUJDLFNBQVMsRUFBRUgsZUFBRyxDQUFDSSxNQUFNLEVBQUUsQ0FBQ0MsUUFBUSxFQUFFO0VBQ2xDQyxXQUFXLEVBQUVOLGVBQUcsQ0FBQ0ksTUFBTSxFQUFFLENBQUNDLFFBQVEsRUFBRTtFQUNwQ0UsU0FBUyxFQUFFUCxlQUFHLENBQUNRLElBQUksRUFBRSxDQUFDQyxHQUFHLEVBQUUsQ0FBQ0osUUFBUSxFQUFFO0VBQ3RDSyxVQUFVLEVBQUVWLGVBQUcsQ0FBQ1csTUFBTSxFQUFFLENBQUNOLFFBQVE7QUFDckMsQ0FBQyxDQUFDO0FBRUYsSUFBSU8sa0JBQWtCO0VBQUEseUZBQUcsaUJBQU9DLFNBQVM7SUFBQTtJQUFBO01BQUE7UUFBQTtVQUFBO1VBQUE7VUFBQSxPQUVSQyxFQUFFLENBQUNDLFFBQVEsQ0FBQ0MsT0FBTyxDQUFDO1lBQUVILFNBQVMsRUFBVEEsU0FBUztZQUFFSSxJQUFJLEVBQUU7VUFBWSxDQUFDLENBQUM7UUFBQTtVQUF4RWQsU0FBUyxpQkFBaUVlLEtBQUs7VUFBQTtVQUFBLE9BQ25ESixFQUFFLENBQUNLLElBQUksQ0FBQ0MsY0FBYyxDQUFDO1lBQUVQLFNBQVMsRUFBVEEsU0FBUztZQUFFUSxTQUFTLEVBQUUsSUFBSTtZQUFFQyxRQUFRLEVBQUU7VUFBSyxDQUFDLENBQUM7UUFBQTtVQUFsR0MsbUJBQW1CO1VBQUEsTUFDckJBLG1CQUFtQixHQUFHcEIsU0FBUztZQUFBO1lBQUE7VUFBQTtVQUN6QnFCLEtBQUssR0FBR0QsbUJBQW1CLEdBQUdwQixTQUFTO1VBQUE7VUFBQSxPQUMxQlcsRUFBRSxDQUFDSyxJQUFJLENBQUNNLElBQUksQ0FBQztZQUFFWixTQUFTLEVBQVRBLFNBQVM7WUFBRVMsUUFBUSxFQUFFLElBQUk7WUFBRUQsU0FBUyxFQUFDO1VBQUssQ0FBQyxDQUFDLENBQUNLLElBQUksQ0FBQztZQUFFQyxTQUFTLEVBQUUsQ0FBQztVQUFFLENBQUMsQ0FBQyxDQUFDQyxLQUFLLENBQUNKLEtBQUssQ0FBQztRQUFBO1VBQTdHSyxJQUFJO1VBQ0RDLENBQUMsR0FBRyxDQUFDO1FBQUE7VUFBQSxNQUFFQSxDQUFDLEdBQUdELElBQUksQ0FBQ0UsTUFBTTtZQUFBO1lBQUE7VUFBQTtVQUMzQkYsSUFBSSxDQUFDQyxDQUFDLENBQUMsQ0FBQ1IsUUFBUSxHQUFHLEtBQUs7VUFBQTtVQUFBLE9BQ2xCTyxJQUFJLENBQUNDLENBQUMsQ0FBQyxDQUFDRSxJQUFJLEVBQUU7UUFBQTtVQUZTRixDQUFDLEVBQUU7VUFBQTtVQUFBO1FBQUE7VUFBQTtVQUFBO1FBQUE7VUFBQTtVQUFBO1VBTXhDRyxPQUFPLENBQUNDLEdBQUcsYUFBTztRQUFDO1VBQUE7VUFBQTtRQUFBO1FBQUE7VUFBQTtNQUFBO0lBQUE7RUFBQSxDQUkxQjtFQUFBLGdCQWpCR3RCLGtCQUFrQjtJQUFBO0VBQUE7QUFBQSxHQWlCckI7QUFDRCxJQUFJdUIsVUFBVTtFQUFBLDBGQUFHLGtCQUFPQyxHQUFHLEVBQUVDLEdBQUcsRUFBRUMsSUFBSTtJQUFBO0lBQUE7TUFBQTtRQUFBO1VBQUE7VUFBQSxZQUU0QkYsR0FBRyxDQUFDRyxJQUFJLEVBQTFEN0IsVUFBVSxhQUFWQSxVQUFVLEVBQUVQLFNBQVMsYUFBVEEsU0FBUyxFQUFFRyxXQUFXLGFBQVhBLFdBQVcsRUFBRUMsU0FBUyxhQUFUQSxTQUFTO1VBQUE7VUFBQSxPQUMvQk8sRUFBRSxDQUFDMEIsT0FBTyxDQUFDeEIsT0FBTyxDQUFDO1lBQ3JDTixVQUFVLEVBQVZBO1VBQ0osQ0FBQyxDQUFDO1FBQUE7VUFGSStCLE9BQU87VUFBQSxJQUdUQSxPQUFPO1lBQUE7WUFBQTtVQUFBO1VBQUEsTUFDRCxJQUFJQyxZQUFZLENBQUMsbUVBQW1FLENBQUM7UUFBQTtVQUV6RjdCLFNBQVMsR0FBRzRCLE9BQU8sQ0FBQ0UsR0FBRztVQUFBO1VBQUEsT0FFRjdCLEVBQUUsQ0FBQ0MsUUFBUSxDQUFDQyxPQUFPLENBQUM7WUFDM0NILFNBQVMsRUFBVEEsU0FBUztZQUNUSSxJQUFJLEVBQUU7VUFDVixDQUFDLENBQUM7UUFBQTtVQUhJMkIsWUFBWTtVQUFBLEtBS2ZBLFlBQVk7WUFBQTtZQUFBO1VBQUE7VUFDWEEsWUFBWSxDQUFDQyxHQUFHLENBQUM7WUFDYjNCLEtBQUssRUFBRWY7VUFDWCxDQUFDLENBQUM7VUFBQTtVQUFBLE9BQ0l5QyxZQUFZLENBQUNaLElBQUksRUFBRTtRQUFBO1VBQUE7VUFBQSxPQUNuQnBCLGtCQUFrQixDQUFDQyxTQUFTLENBQUM7UUFBQTtVQUFBO1VBQUE7UUFBQTtVQUFBO1VBQUEsT0FFN0JDLEVBQUUsQ0FBQ0MsUUFBUSxDQUFDK0IsTUFBTSxDQUFDO1lBQ3JCakMsU0FBUyxFQUFUQSxTQUFTO1lBQ1RJLElBQUksRUFBRSxXQUFXO1lBQ2pCQyxLQUFLLEVBQUVmO1VBQ1gsQ0FBQyxDQUFDO1FBQUE7VUFBQTtVQUFBLE9BR3VCVyxFQUFFLENBQUNDLFFBQVEsQ0FBQ0MsT0FBTyxDQUFDO1lBQzdDSCxTQUFTLEVBQVRBLFNBQVM7WUFDVEksSUFBSSxFQUFFO1VBQ1YsQ0FBQyxDQUFDO1FBQUE7VUFISThCLGNBQWM7VUFBQSxLQUtqQkEsY0FBYztZQUFBO1lBQUE7VUFBQTtVQUNiQSxjQUFjLENBQUNGLEdBQUcsQ0FBQztZQUNmM0IsS0FBSyxFQUFFWjtVQUNYLENBQUMsQ0FBQztVQUFBO1VBQUEsT0FDSXlDLGNBQWMsQ0FBQ2YsSUFBSSxFQUFFO1FBQUE7VUFBQTtVQUFBO1FBQUE7VUFBQTtVQUFBLE9BRXJCbEIsRUFBRSxDQUFDQyxRQUFRLENBQUMrQixNQUFNLENBQUM7WUFDckJqQyxTQUFTLEVBQVRBLFNBQVM7WUFDVEksSUFBSSxFQUFFLGFBQWE7WUFDbkJDLEtBQUssRUFBRVo7VUFDWCxDQUFDLENBQUM7UUFBQTtVQUFBO1VBQUEsT0FHMEJRLEVBQUUsQ0FBQ0MsUUFBUSxDQUFDQyxPQUFPLENBQUM7WUFDaERILFNBQVMsRUFBVEEsU0FBUztZQUNUSSxJQUFJLEVBQUU7VUFDVixDQUFDLENBQUM7UUFBQTtVQUhJK0IsaUJBQWlCO1VBQUEsS0FLcEJBLGlCQUFpQjtZQUFBO1lBQUE7VUFBQTtVQUNoQkEsaUJBQWlCLENBQUNILEdBQUcsQ0FBQztZQUNsQjNCLEtBQUssRUFBRSxJQUFJK0IsSUFBSSxDQUFDMUMsU0FBUztVQUM3QixDQUFDLENBQUM7VUFBQTtVQUFBLE9BQ0l5QyxpQkFBaUIsQ0FBQ2hCLElBQUksRUFBRTtRQUFBO1VBQUE7VUFBQTtRQUFBO1VBQUE7VUFBQSxPQUV4QmxCLEVBQUUsQ0FBQ0MsUUFBUSxDQUFDK0IsTUFBTSxDQUFDO1lBQ3JCakMsU0FBUyxFQUFUQSxTQUFTO1lBQ1RJLElBQUksRUFBRSxXQUFXO1lBQ2pCQyxLQUFLLEVBQUUsSUFBSStCLElBQUksQ0FBQzFDLFNBQVM7VUFDN0IsQ0FBQyxDQUFDO1FBQUE7VUFHTjhCLEdBQUcsQ0FBQ2EsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDQyxJQUFJLENBQUM7WUFBRUMsT0FBTyxFQUFFLElBQUk7WUFBRUMsT0FBTyxFQUFFO1VBQStCLENBQUMsQ0FBQztVQUFDO1VBQUE7UUFBQTtVQUFBO1VBQUE7VUFHakZwQixPQUFPLENBQUNDLEdBQUcsY0FBSztVQUNoQkksSUFBSSxjQUFLO1FBQUE7UUFBQTtVQUFBO01BQUE7SUFBQTtFQUFBLENBRWhCO0VBQUEsZ0JBeEVHSCxVQUFVO0lBQUE7RUFBQTtBQUFBLEdBd0ViO0FBRUQsSUFBTW1CLFNBQVMsR0FBR0MsbUJBQU8sQ0FBQ0MsTUFBTSxFQUFFO0FBQ2xDRixTQUFTLENBQUNHLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQ0MsSUFBSSxDQUFDLElBQUFDLDBCQUFZLEdBQUUsRUFBRyxJQUFBQyx1QkFBWSxFQUFDN0QsU0FBUyxDQUFDLEVBQUVvQyxVQUFVLENBQUM7QUFBQyxlQUNqRW1CLFNBQVM7QUFBQSJ9