"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _credentials = _interopRequireDefault(require("../../service/credentials"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _moveEmailGsuite = _interopRequireDefault(require("../../service/move-email-gsuite"));
var _moveEmailOutlook = _interopRequireDefault(require("../../service/move-email-outlook"));
var _mailer = _interopRequireDefault(require("../../mailer"));
var _permission = require("../../middlewares/permission");
var _kue = require("../../kue");
var _functions = require("../../functions");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _updateMessageId = _interopRequireDefault(require("../../service/update-messageId"));
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var validator = _joi["default"].object().keys({
  whoElseIds: _joi["default"].array().items(_joi["default"].string().hex().length(24)).optional(),
  reportedMailId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/mail-actions/move-to-trash Trash Mail
 * @apiName move-to-trash
 * @apiGroup Who-Else
 * @apiDescription Trash a particular who-else mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}  whoElseIds   Required who-else id of the mail to be trashed
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  Message    "Successfully trashed and will be update in sometime"
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "Message": "Successfully deleted and will be update in sometime"
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    messages    ["\"whoElseIds[0]\" is not allowed to be empty"]
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "\"whoElseIds[0]\" is not allowed to be empty"
 *          ]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(req, res, next) {
    var reportedMailId, companyId, emailReported, whoElseIds, user, whoElseIdsDomainWise, whoElses, gsuiteIds, _iterator, _step, _whoElse, result, i, whoElse, lastArray, domainWhoelse, count, _i, _loop, _i2;
    return _regenerator["default"].wrap(function _callee4$(_context5) {
      while (1) switch (_context5.prev = _context5.next) {
        case 0:
          _context5.prev = 0;
          reportedMailId = req.body.reportedMailId;
          companyId = req.user.companyId;
          _context5.next = 5;
          return db.ReportedMail.findOne({
            _id: reportedMailId,
            companyId: companyId
          });
        case 5:
          emailReported = _context5.sent;
          if (emailReported) {
            _context5.next = 8;
            break;
          }
          throw new RequestError('invalid reportedMailId recieved');
        case 8:
          if (!(emailReported.isWhoElseProcessing == 'true')) {
            _context5.next = 10;
            break;
          }
          throw new RequestError('Who-Else Search in Progress. Please wait and refresh before retrying.');
        case 10:
          _context5.next = 12;
          return db.WhoElse.find({
            reportedMailId: reportedMailId,
            companyId: companyId,
            isDeleted: false,
            deletedAt: null
          }).select('_id');
        case 12:
          whoElseIds = _context5.sent;
          whoElseIds = whoElseIds.map(function (whoElse) {
            return whoElse._id;
          });
          if (!(emailReported.mailType == 'Exchange')) {
            _context5.next = 29;
            break;
          }
          _context5.next = 17;
          return db.User.findOne({
            email: emailReported.to
          });
        case 17:
          user = _context5.sent;
          _mailer["default"].sendActionResultMail(user.name, emailReported.to, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "THREAT", false, "", companyId);
          if (emailReported.reporters.length != 0) {
            emailReported.reporters.forEach( /*#__PURE__*/function () {
              var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(reporter) {
                var user;
                return _regenerator["default"].wrap(function _callee$(_context) {
                  while (1) switch (_context.prev = _context.next) {
                    case 0:
                      _context.next = 2;
                      return db.User.findOne({
                        email: reporter === null || reporter === void 0 ? void 0 : reporter.email
                      });
                    case 2:
                      user = _context.sent;
                      _mailer["default"].sendActionResultMail(user.name, reporter.email, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "THREAT", false, "", companyId);
                    case 4:
                    case "end":
                      return _context.stop();
                  }
                }, _callee);
              }));
              return function (_x4) {
                return _ref2.apply(this, arguments);
              };
            }());
          }
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isTrashedEmail: "false",
            isRecoveredEmail: "false",
            isDeletedEmail: "true"
          });
          emailReported.isRecoveredEmail = false;
          emailReported.isTrashedEmail = false;
          emailReported.isDeletedEmail = true;
          _context5.next = 26;
          return emailReported.save();
        case 26:
          return _context5.abrupt("return", res.status(200).send({
            success: true,
            Message: "Successfully marked as threat!"
          }));
        case 29:
          whoElseIdsDomainWise = {};
          whoElses = [];
          gsuiteIds = [];
          _iterator = _createForOfIteratorHelper(whoElseIds);
          _context5.prev = 33;
          _iterator.s();
        case 35:
          if ((_step = _iterator.n()).done) {
            _context5.next = 43;
            break;
          }
          _whoElse = _step.value;
          _context5.next = 39;
          return db.WhoElse.findOne({
            companyId: companyId,
            _id: _whoElse
          }).populate('domainId', 'domainType _id');
        case 39:
          result = _context5.sent;
          if (result.domainId.domainType == 'Gsuite') gsuiteIds.push(result);else whoElses.push(result);
        case 41:
          _context5.next = 35;
          break;
        case 43:
          _context5.next = 48;
          break;
        case 45:
          _context5.prev = 45;
          _context5.t0 = _context5["catch"](33);
          _iterator.e(_context5.t0);
        case 48:
          _context5.prev = 48;
          _iterator.f();
          return _context5.finish(48);
        case 51:
          for (i = 0; i < whoElses.length; i++) {
            whoElse = whoElses[i];
            if (!whoElseIdsDomainWise[whoElse.domainId._id]) whoElseIdsDomainWise[whoElse.domainId._id] = [];
            if (whoElseIdsDomainWise[whoElse.domainId._id].length > 0) {
              lastArray = whoElseIdsDomainWise[whoElse.domainId._id].pop();
              if (lastArray.length < 20) lastArray.push(whoElse), whoElseIdsDomainWise[whoElse.domainId._id].push(lastArray);else whoElseIdsDomainWise[whoElse.domainId._id].push(lastArray), whoElseIdsDomainWise[whoElse.domainId._id].push([whoElse]);
            } else whoElseIdsDomainWise[whoElse.domainId._id].push([whoElse]);
          }
          for (domainWhoelse in whoElseIdsDomainWise) {
            count = 0;
            for (_i = 0; _i < whoElseIdsDomainWise[domainWhoelse].length; _i += 10) {
              _kue.queue.create('process-update-folderId-outlook', {
                whoElses: whoElseIdsDomainWise[domainWhoelse].slice(_i, Math.min(_i + 10, whoElseIdsDomainWise[domainWhoelse].length)),
                domainId: domainWhoelse,
                companyId: req.user.companyId,
                emailReported: emailReported,
                mailAction: 'Deleted'
              }).removeOnComplete(true).priority('high').save();
            }
          }
        case 53:
          if (!(gsuiteIds.length > 0)) {
            _context5.next = 61;
            break;
          }
          _loop = /*#__PURE__*/_regenerator["default"].mark(function _loop() {
            var whoElse, _yield$credentials$ge, fileName;
            return _regenerator["default"].wrap(function _loop$(_context4) {
              while (1) switch (_context4.prev = _context4.next) {
                case 0:
                  _context4.next = 2;
                  return db.WhoElse.findOne({
                    _id: gsuiteIds[_i2]
                  });
                case 2:
                  whoElse = _context4.sent;
                  if (!(whoElse.messageId && whoElse.threadId)) {
                    _context4.next = 12;
                    break;
                  }
                  _context4.next = 6;
                  return _credentials["default"].getCredentials(companyId, whoElse.domainId);
                case 6:
                  _yield$credentials$ge = _context4.sent;
                  fileName = _yield$credentials$ge.fileName;
                  _context4.next = 10;
                  return _moveEmailGsuite["default"].processMoveEmailDelete({
                    fileName: fileName,
                    email: whoElse.to,
                    threadId: whoElse.threadId,
                    messageId: whoElse.messageId
                  }).then( /*#__PURE__*/(0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2() {
                    var isReporter;
                    return _regenerator["default"].wrap(function _callee2$(_context2) {
                      while (1) switch (_context2.prev = _context2.next) {
                        case 0:
                          whoElse.isErrorWhileMoving = {
                            isError: false,
                            message: ''
                          };
                          whoElse.isDeleted = true;
                          _context2.next = 4;
                          return whoElse.save();
                        case 4:
                          isReporter = emailReported === null || emailReported === void 0 ? void 0 : emailReported.reporters.find(function (reporter) {
                            return reporter.email.toLowerCase() === whoElse.to.toLowerCase();
                          });
                          if (emailReported.to !== whoElse.to && !isReporter) _mailer["default"].sendResultMailToOtherReporters(whoElse.name, whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'Deleted', companyId);else _mailer["default"].sendActionResultMail(whoElse.name, whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'DELETED', false, null, companyId);
                          return _context2.abrupt("return");
                        case 7:
                        case "end":
                          return _context2.stop();
                      }
                    }, _callee2);
                  })))["catch"]( /*#__PURE__*/function () {
                    var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(err) {
                      return _regenerator["default"].wrap(function _callee3$(_context3) {
                        while (1) switch (_context3.prev = _context3.next) {
                          case 0:
                            whoElse.isErrorWhileMoving = {
                              isError: true,
                              message: err
                            };
                            _context3.next = 3;
                            return whoElse.save();
                          case 3:
                            return _context3.abrupt("return");
                          case 4:
                          case "end":
                            return _context3.stop();
                        }
                      }, _callee3);
                    }));
                    return function (_x5) {
                      return _ref4.apply(this, arguments);
                    };
                  }());
                case 10:
                  _context4.next = 15;
                  break;
                case 12:
                  whoElse.isErrorWhileMoving = {
                    isError: true,
                    message: 'messageId or threadId is missing'
                  };
                  _context4.next = 15;
                  return whoElse.save();
                case 15:
                case "end":
                  return _context4.stop();
              }
            }, _loop);
          });
          _i2 = 0;
        case 56:
          if (!(_i2 < gsuiteIds.length)) {
            _context5.next = 61;
            break;
          }
          return _context5.delegateYield(_loop(), "t1", 58);
        case 58:
          _i2++;
          _context5.next = 56;
          break;
        case 61:
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isTrashedEmail: "false",
            isRecoveredEmail: "false",
            isDeletedEmail: "true"
          });
          emailReported.isRecoveredEmail = false;
          emailReported.isTrashedEmail = false;
          emailReported.isDeletedEmail = true;
          _context5.next = 67;
          return emailReported.save();
        case 67:
          return _context5.abrupt("return", res.status(200).send({
            success: true,
            Message: "Successfully Deleted!"
          }));
        case 70:
          _context5.prev = 70;
          _context5.t2 = _context5["catch"](0);
          console.log("error", _context5.t2);
          next(_context5.t2);
        case 74:
        case "end":
          return _context5.stop();
      }
    }, _callee4, null, [[0, 70], [33, 45, 48, 51]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, (0, _featureBlocker["default"])("TPIR-ARTD"), (0, _permission.permission)('Emails', 'Delete'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJ2YWxpZGF0b3IiLCJKb2kiLCJvYmplY3QiLCJrZXlzIiwid2hvRWxzZUlkcyIsImFycmF5IiwiaXRlbXMiLCJzdHJpbmciLCJoZXgiLCJsZW5ndGgiLCJvcHRpb25hbCIsInJlcG9ydGVkTWFpbElkIiwicmVxdWlyZWQiLCJjb250cm9sbGVyIiwicmVxIiwicmVzIiwibmV4dCIsImJvZHkiLCJjb21wYW55SWQiLCJ1c2VyIiwiZGIiLCJSZXBvcnRlZE1haWwiLCJmaW5kT25lIiwiX2lkIiwiZW1haWxSZXBvcnRlZCIsIlJlcXVlc3RFcnJvciIsImlzV2hvRWxzZVByb2Nlc3NpbmciLCJXaG9FbHNlIiwiZmluZCIsImlzRGVsZXRlZCIsImRlbGV0ZWRBdCIsInNlbGVjdCIsIm1hcCIsIndob0Vsc2UiLCJtYWlsVHlwZSIsIlVzZXIiLCJlbWFpbCIsInRvIiwibWFpbGVyIiwic2VuZEFjdGlvblJlc3VsdE1haWwiLCJuYW1lIiwiZnJvbSIsInN1YmplY3QiLCJtYWlsUmVjaWV2ZWRUaW1lIiwicmVwb3J0ZXJzIiwiZm9yRWFjaCIsInJlcG9ydGVyIiwidXBkYXRlUmVwb3J0ZWRNYWlsQ2FjaGUiLCJpc1RyYXNoZWRFbWFpbCIsImlzUmVjb3ZlcmVkRW1haWwiLCJpc0RlbGV0ZWRFbWFpbCIsInNhdmUiLCJzdGF0dXMiLCJzZW5kIiwic3VjY2VzcyIsIk1lc3NhZ2UiLCJ3aG9FbHNlSWRzRG9tYWluV2lzZSIsIndob0Vsc2VzIiwiZ3N1aXRlSWRzIiwicG9wdWxhdGUiLCJyZXN1bHQiLCJkb21haW5JZCIsImRvbWFpblR5cGUiLCJwdXNoIiwiaSIsImxhc3RBcnJheSIsInBvcCIsImRvbWFpbldob2Vsc2UiLCJjb3VudCIsInF1ZXVlIiwiY3JlYXRlIiwic2xpY2UiLCJNYXRoIiwibWluIiwibWFpbEFjdGlvbiIsInJlbW92ZU9uQ29tcGxldGUiLCJwcmlvcml0eSIsIm1lc3NhZ2VJZCIsInRocmVhZElkIiwiY3JlZGVudGlhbHMiLCJnZXRDcmVkZW50aWFscyIsImZpbGVOYW1lIiwibW92ZUVtYWlsR3N1aXRlIiwicHJvY2Vzc01vdmVFbWFpbERlbGV0ZSIsInRoZW4iLCJpc0Vycm9yV2hpbGVNb3ZpbmciLCJpc0Vycm9yIiwibWVzc2FnZSIsImlzUmVwb3J0ZXIiLCJ0b0xvd2VyQ2FzZSIsInNlbmRSZXN1bHRNYWlsVG9PdGhlclJlcG9ydGVycyIsImVyciIsImNvbnNvbGUiLCJsb2ciLCJhcGlSb3V0ZXIiLCJleHByZXNzIiwiUm91dGVyIiwicm91dGUiLCJwb3N0IiwiaHRtbHNhbml0aXplIiwiand0U3RyYXRlZ3kiLCJjaGVja0NvbXBhbnlWYWxpZGl0eVN0cmF0ZWd5IiwicmVzdHJpY3RGZWF0dXJlIiwicGVybWlzc2lvbiIsInZhbGlkYXRlQm9keSJdLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9hcGkvbWFpbC1hY3Rpb25zL21vdmUtdG8tZGVsZXRlLXRlc3QuanMiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IEpvaSBmcm9tICdqb2knO1xuaW1wb3J0IGV4cHJlc3MgZnJvbSAnZXhwcmVzcyc7XG5cbmltcG9ydCBjcmVkZW50aWFscyBmcm9tICcuLi8uLi9zZXJ2aWNlL2NyZWRlbnRpYWxzJztcbmltcG9ydCB7IHNhbml0aXplIH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvc2FuaXRpemVyJztcbmltcG9ydCB7IGNoZWNrQ29tcGFueVZhbGlkaXR5U3RyYXRlZ3ksIGp3dFN0cmF0ZWd5IH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvc3RyYXRlZ3knO1xuaW1wb3J0IHsgdmFsaWRhdGVCb2R5IH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvdmFsaWRhdG9yJztcbmltcG9ydCBtb3ZlRW1haWxHc3VpdGUgZnJvbSAnLi4vLi4vc2VydmljZS9tb3ZlLWVtYWlsLWdzdWl0ZSc7XG5pbXBvcnQgbW92ZUVtYWlsT3V0bG9vayBmcm9tICcuLi8uLi9zZXJ2aWNlL21vdmUtZW1haWwtb3V0bG9vayc7XG5pbXBvcnQgbWFpbGVyIGZyb20gJy4uLy4uL21haWxlcic7XG5pbXBvcnQgeyBwZXJtaXNzaW9uIH0gZnJvbSAnLi4vLi4vbWlkZGxld2FyZXMvcGVybWlzc2lvbic7XG5pbXBvcnQgeyBxdWV1ZSB9IGZyb20gJy4uLy4uL2t1ZSdcbmltcG9ydCB7IHVwZGF0ZVJlcG9ydGVkTWFpbENhY2hlIH0gZnJvbSAnLi4vLi4vZnVuY3Rpb25zJztcbmltcG9ydCB7IGh0bWxzYW5pdGl6ZSB9IGZyb20gJy4uLy4uL21pZGRsZXdhcmVzL3Nhbml0aXplSHRtbCc7XG5pbXBvcnQgdXBkYXRlTWVzc2FnZUlkIGZyb20gJy4uLy4uL3NlcnZpY2UvdXBkYXRlLW1lc3NhZ2VJZCc7XG5pbXBvcnQgcmVzdHJpY3RGZWF0dXJlIGZyb20gJy4uLy4uL21pZGRsZXdhcmVzL2ZlYXR1cmVCbG9ja2VyJztcblxubGV0IHZhbGlkYXRvciA9IEpvaS5vYmplY3QoKS5rZXlzKHtcbiAgICB3aG9FbHNlSWRzOiBKb2kuYXJyYXkoKS5pdGVtcyhcbiAgICAgICAgSm9pLnN0cmluZygpLmhleCgpLmxlbmd0aCgyNCkgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICApLm9wdGlvbmFsKCksXG4gICAgcmVwb3J0ZWRNYWlsSWQ6IEpvaS5zdHJpbmcoKS5oZXgoKS5sZW5ndGgoMjQpLnJlcXVpcmVkKClcbn0pO1xuXG4vKipcbiAqIEBhcGkge3Bvc3R9IC9hcGkvdjEvbWFpbC1hY3Rpb25zL21vdmUtdG8tdHJhc2ggVHJhc2ggTWFpbFxuICogQGFwaU5hbWUgbW92ZS10by10cmFzaFxuICogQGFwaUdyb3VwIFdoby1FbHNlXG4gKiBAYXBpRGVzY3JpcHRpb24gVHJhc2ggYSBwYXJ0aWN1bGFyIHdoby1lbHNlIG1haWxcbiAqIFxuICogQGFwaVZlcnNpb24gMS4wLjBcbiAqIFxuICogQGFwaUJvZHkgICB7U3RyaW5nfSAgd2hvRWxzZUlkcyAgIFJlcXVpcmVkIHdoby1lbHNlIGlkIG9mIHRoZSBtYWlsIHRvIGJlIHRyYXNoZWRcbiAqIFxuICogQGFwaVN1Y2Nlc3Mge0Jvb2xlYW59IFN1Y2Nlc3MgICAgdHJ1ZVxuICogQGFwaVN1Y2Nlc3Mge1N0cmluZ30gIE1lc3NhZ2UgICAgXCJTdWNjZXNzZnVsbHkgdHJhc2hlZCBhbmQgd2lsbCBiZSB1cGRhdGUgaW4gc29tZXRpbWVcIlxuICogXG4gKiBAYXBpU3VjY2Vzc0V4YW1wbGUgU3VjY2Vzcy1SZXNwb25zZTpcbiAqICAgICBIVFRQLzEuMSAyMDAgT0tcbiAqICAgICAgIHtcbiAqICAgICAgICAgICBcInN1Y2Nlc3NcIjogdHJ1ZSxcbiAqICAgICAgICAgICBcIk1lc3NhZ2VcIjogXCJTdWNjZXNzZnVsbHkgZGVsZXRlZCBhbmQgd2lsbCBiZSB1cGRhdGUgaW4gc29tZXRpbWVcIlxuICogICAgICAgfVxuICogIFxuICogIEBhcGlFcnJvciAoNTAwKSAge0Jvb2xlYW59ICBzdWNjZXNzICAgIGZhbHNlXG4gKiAgQGFwaUVycm9yICg1MDApICB7QXJyYXl9ICAgIG1lc3NhZ2VzICAgIFtcIlxcXCJ3aG9FbHNlSWRzWzBdXFxcIiBpcyBub3QgYWxsb3dlZCB0byBiZSBlbXB0eVwiXVxuICogXG4gKiAgQGFwaUVycm9yRXhhbXBsZSBFcnJvci1SZXNwb25zZTpcbiAqICAgICBIVFRQLzEuMSA1MDAgTm90IEZvdW5kXG4gKiAgICAgIHtcbiAqICAgICAgICAgIFwic3VjY2Vzc1wiOiBmYWxzZSxcbiAqICAgICAgICAgIFwibWVzc2FnZXNcIjogW1xuICogICAgICAgICAgICAgIFwiXFxcIndob0Vsc2VJZHNbMF1cXFwiIGlzIG5vdCBhbGxvd2VkIHRvIGJlIGVtcHR5XCJcbiAqICAgICAgICAgIF1cbiAqICAgICAgfVxuICovXG5cbmxldCBjb250cm9sbGVyID0gYXN5bmMgKHJlcSwgcmVzLCBuZXh0KSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgICAgY29uc3QgeyByZXBvcnRlZE1haWxJZCB9ID0gcmVxLmJvZHk7XG4gICAgICAgIGNvbnN0IGNvbXBhbnlJZCA9IHJlcS51c2VyLmNvbXBhbnlJZDtcbiAgICAgICAgY29uc3QgZW1haWxSZXBvcnRlZCA9IGF3YWl0IGRiLlJlcG9ydGVkTWFpbC5maW5kT25lKHtcbiAgICAgICAgICAgIF9pZDogcmVwb3J0ZWRNYWlsSWQsXG4gICAgICAgICAgICBjb21wYW55SWRcbiAgICAgICAgfSlcblxuICAgICAgICBpZighZW1haWxSZXBvcnRlZCl7XG4gICAgICAgICAgICB0aHJvdyBuZXcgUmVxdWVzdEVycm9yKCdpbnZhbGlkIHJlcG9ydGVkTWFpbElkIHJlY2lldmVkJyk7XG4gICAgICAgIH1cbiAgICAgICAgaWYoZW1haWxSZXBvcnRlZC5pc1dob0Vsc2VQcm9jZXNzaW5nPT0ndHJ1ZScpIHRocm93IG5ldyBSZXF1ZXN0RXJyb3IoJ1doby1FbHNlIFNlYXJjaCBpbiBQcm9ncmVzcy4gUGxlYXNlIHdhaXQgYW5kIHJlZnJlc2ggYmVmb3JlIHJldHJ5aW5nLicpOyBcbiAgICAgICAgXG4gICAgICAgIGxldCB3aG9FbHNlSWRzID0gYXdhaXQgZGIuV2hvRWxzZS5maW5kKHtyZXBvcnRlZE1haWxJZCwgY29tcGFueUlkLCBpc0RlbGV0ZWQ6IGZhbHNlLCBkZWxldGVkQXQ6IG51bGx9KS5zZWxlY3QoJ19pZCcpICAgICAgICBcbiAgICAgICAgd2hvRWxzZUlkcyA9IHdob0Vsc2VJZHMubWFwKHdob0Vsc2UgPT4gd2hvRWxzZS5faWQpXG5cbiAgICAgICAgXG4gICAgICAgIGlmKGVtYWlsUmVwb3J0ZWQubWFpbFR5cGUgPT0gJ0V4Y2hhbmdlJyl7XG4gICAgICAgICAgICBjb25zdCB1c2VyID0gYXdhaXQgZGIuVXNlci5maW5kT25lKHsgZW1haWw6IGVtYWlsUmVwb3J0ZWQudG8gfSlcbiAgICAgICAgICAgIG1haWxlci5zZW5kQWN0aW9uUmVzdWx0TWFpbCh1c2VyLm5hbWUsIGVtYWlsUmVwb3J0ZWQudG8sIGVtYWlsUmVwb3J0ZWQuZnJvbSwgZW1haWxSZXBvcnRlZC5zdWJqZWN0LCBlbWFpbFJlcG9ydGVkLm1haWxSZWNpZXZlZFRpbWUsIFwiVEhSRUFUXCIsIGZhbHNlLCBcIlwiLCBjb21wYW55SWQpICAgICAgXG4gICAgICAgICAgICBpZihlbWFpbFJlcG9ydGVkLnJlcG9ydGVycy5sZW5ndGghPTAgKXtcbiAgICAgICAgICAgICAgICBlbWFpbFJlcG9ydGVkLnJlcG9ydGVycy5mb3JFYWNoKGFzeW5jIChyZXBvcnRlcik9PntcbiAgICAgICAgICAgICAgICAgICAgY29uc3QgdXNlciA9IGF3YWl0IGRiLlVzZXIuZmluZE9uZSh7IGVtYWlsOiByZXBvcnRlcj8uZW1haWwgfSlcbiAgICAgICAgICAgICAgICAgICAgbWFpbGVyLnNlbmRBY3Rpb25SZXN1bHRNYWlsKHVzZXIubmFtZSwgcmVwb3J0ZXIuZW1haWwsIGVtYWlsUmVwb3J0ZWQuZnJvbSwgZW1haWxSZXBvcnRlZC5zdWJqZWN0LCBlbWFpbFJlcG9ydGVkLm1haWxSZWNpZXZlZFRpbWUsXCJUSFJFQVRcIiwgZmFsc2UsIFwiXCIsIGNvbXBhbnlJZCkgXG4gICAgICAgICAgICAgICAgfSlcbiAgICAgICAgICAgIH1cbiAgICAgICAgICAgIHVwZGF0ZVJlcG9ydGVkTWFpbENhY2hlKHJlcG9ydGVkTWFpbElkLHtpc1RyYXNoZWRFbWFpbDpcImZhbHNlXCIsIGlzUmVjb3ZlcmVkRW1haWw6XCJmYWxzZVwiLCBpc0RlbGV0ZWRFbWFpbDpcInRydWVcIn0pXG5cbiAgICAgICAgICAgIGVtYWlsUmVwb3J0ZWQuaXNSZWNvdmVyZWRFbWFpbCA9IGZhbHNlO1xuICAgICAgICAgICAgZW1haWxSZXBvcnRlZC5pc1RyYXNoZWRFbWFpbCA9IGZhbHNlO1xuICAgICAgICAgICAgZW1haWxSZXBvcnRlZC5pc0RlbGV0ZWRFbWFpbCA9IHRydWU7XG4gICAgICAgICAgICBhd2FpdCBlbWFpbFJlcG9ydGVkLnNhdmUoKVxuICAgICAgICAgICAgcmV0dXJuIHJlcy5zdGF0dXMoMjAwKS5zZW5kKHsgc3VjY2VzczogdHJ1ZSwgTWVzc2FnZTogXCJTdWNjZXNzZnVsbHkgbWFya2VkIGFzIHRocmVhdCFcIn0pXG4gICAgICAgIH1cbiAgICAgICAgZWxzZSB7XG4gICAgICAgICAgICBsZXQgd2hvRWxzZUlkc0RvbWFpbldpc2UgPSB7fTtcblxuICAgICAgICAgICAgbGV0IHdob0Vsc2VzID0gW11cbiAgICAgICAgICAgIHZhciBnc3VpdGVJZHMgPSBbXVxuICAgICAgICAgICAgXG4gICAgICAgICAgICBmb3IoY29uc3Qgd2hvRWxzZSBvZiB3aG9FbHNlSWRzKXtcbiAgICAgICAgICAgICAgICBsZXQgcmVzdWx0ID0gYXdhaXQgZGIuV2hvRWxzZS5maW5kT25lKHtjb21wYW55SWQsIF9pZDogd2hvRWxzZX0pLnBvcHVsYXRlKCdkb21haW5JZCcgLCdkb21haW5UeXBlIF9pZCcpXG4gICAgICAgICAgICAgICAgaWYocmVzdWx0LmRvbWFpbklkLmRvbWFpblR5cGUgPT0gJ0dzdWl0ZScpIGdzdWl0ZUlkcy5wdXNoKHJlc3VsdClcbiAgICAgICAgICAgICAgICBlbHNlIHdob0Vsc2VzLnB1c2gocmVzdWx0KVxuICAgICAgICAgICAgfVxuXG4gICAgICAgICAgICBmb3IobGV0IGk9MDtpPHdob0Vsc2VzLmxlbmd0aDtpKyspe1xuICAgICAgICAgICAgICAgIGxldCB3aG9FbHNlID0gd2hvRWxzZXNbaV1cbiAgICAgICAgICAgICAgICBpZighd2hvRWxzZUlkc0RvbWFpbldpc2Vbd2hvRWxzZS5kb21haW5JZC5faWRdKSAgd2hvRWxzZUlkc0RvbWFpbldpc2Vbd2hvRWxzZS5kb21haW5JZC5faWRdID0gW11cblxuICAgICAgICAgICAgICAgIFxuICAgICAgICAgICAgICAgIGlmKHdob0Vsc2VJZHNEb21haW5XaXNlW3dob0Vsc2UuZG9tYWluSWQuX2lkXS5sZW5ndGggPiAwKXtcbiAgICAgICAgICAgICAgICAgICAgbGV0IGxhc3RBcnJheSA9IHdob0Vsc2VJZHNEb21haW5XaXNlW3dob0Vsc2UuZG9tYWluSWQuX2lkXS5wb3AoKVxuICAgICAgICAgICAgICAgICAgICBpZihsYXN0QXJyYXkubGVuZ3RoIDwgMjApIGxhc3RBcnJheS5wdXNoKHdob0Vsc2UpLCB3aG9FbHNlSWRzRG9tYWluV2lzZVt3aG9FbHNlLmRvbWFpbklkLl9pZF0ucHVzaChsYXN0QXJyYXkpXG4gICAgICAgICAgICAgICAgICAgIGVsc2Ugd2hvRWxzZUlkc0RvbWFpbldpc2Vbd2hvRWxzZS5kb21haW5JZC5faWRdLnB1c2gobGFzdEFycmF5KSwgd2hvRWxzZUlkc0RvbWFpbldpc2Vbd2hvRWxzZS5kb21haW5JZC5faWRdLnB1c2goW3dob0Vsc2VdKVxuICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICBlbHNlIHdob0Vsc2VJZHNEb21haW5XaXNlW3dob0Vsc2UuZG9tYWluSWQuX2lkXS5wdXNoKFt3aG9FbHNlXSlcbiAgICAgICAgICAgIH0gICAgICBcblxuICAgICAgICAgICAgXG4gICAgICAgICAgICBmb3IoY29uc3QgZG9tYWluV2hvZWxzZSBpbiB3aG9FbHNlSWRzRG9tYWluV2lzZSl7XG4gICAgICAgICAgICAgICAgbGV0IGNvdW50ID0gMFxuICAgICAgICAgICAgICAgIGZvcihsZXQgaT0wO2k8d2hvRWxzZUlkc0RvbWFpbldpc2VbZG9tYWluV2hvZWxzZV0ubGVuZ3RoOyBpKz0xMCl7XG4gICAgICAgICAgICAgICAgICAgIHF1ZXVlLmNyZWF0ZSgncHJvY2Vzcy11cGRhdGUtZm9sZGVySWQtb3V0bG9vaycse3dob0Vsc2VzOiB3aG9FbHNlSWRzRG9tYWluV2lzZVtkb21haW5XaG9lbHNlXS5zbGljZShpLE1hdGgubWluKGkrMTAsd2hvRWxzZUlkc0RvbWFpbldpc2VbZG9tYWluV2hvZWxzZV0ubGVuZ3RoKSksIFxuICAgICAgICAgICAgICAgICAgICAgICAgZG9tYWluSWQ6IGRvbWFpbldob2Vsc2UsIGNvbXBhbnlJZDogcmVxLnVzZXIuY29tcGFueUlkLCBcbiAgICAgICAgICAgICAgICAgICAgICAgIGVtYWlsUmVwb3J0ZWQsXG4gICAgICAgICAgICAgICAgICAgICAgICBtYWlsQWN0aW9uOidEZWxldGVkJyB9KVxuICAgICAgICAgICAgICAgICAgICAucmVtb3ZlT25Db21wbGV0ZSh0cnVlKS5wcmlvcml0eSgnaGlnaCcpLnNhdmUoKTtcbiAgICAgICAgICAgICAgICB9XG4gICAgICAgICAgICB9XG4gICAgICAgICAgICBcbiAgICAgICAgfVxuICAgICAgICBpZihnc3VpdGVJZHMubGVuZ3RoPjApe1xuICAgICAgICAgICAgZm9yKGxldCBpPTA7aTxnc3VpdGVJZHMubGVuZ3RoO2krKyl7XG4gICAgICAgICAgICAgICAgbGV0IHdob0Vsc2UgPSBhd2FpdCBkYi5XaG9FbHNlLmZpbmRPbmUoe19pZDogZ3N1aXRlSWRzW2ldfSlcbiAgICAgICAgICAgICAgICBpZih3aG9FbHNlLm1lc3NhZ2VJZCAmJiB3aG9FbHNlLnRocmVhZElkKXtcbiAgICAgICAgICAgICAgICAgICAgbGV0IHsgZmlsZU5hbWUgfSA9IGF3YWl0IGNyZWRlbnRpYWxzLmdldENyZWRlbnRpYWxzKGNvbXBhbnlJZCwgd2hvRWxzZS5kb21haW5JZClcbiAgICAgICAgICAgICAgICAgICAgYXdhaXQgbW92ZUVtYWlsR3N1aXRlLnByb2Nlc3NNb3ZlRW1haWxEZWxldGUoe1xuICAgICAgICAgICAgICAgICAgICAgICAgZmlsZU5hbWUsIFxuICAgICAgICAgICAgICAgICAgICAgICAgZW1haWw6IHdob0Vsc2UudG8sXG4gICAgICAgICAgICAgICAgICAgICAgICB0aHJlYWRJZDogd2hvRWxzZS50aHJlYWRJZCxcbiAgICAgICAgICAgICAgICAgICAgICAgIG1lc3NhZ2VJZDogd2hvRWxzZS5tZXNzYWdlSWQsIFxuICAgICAgICAgICAgICAgICAgICB9KVxuICAgICAgICAgICAgICAgICAgICAudGhlbihhc3luYyAoKSA9PiB7XG4gICAgICAgICAgICAgICAgICAgICAgICB3aG9FbHNlLmlzRXJyb3JXaGlsZU1vdmluZyA9IHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBpc0Vycm9yOiBmYWxzZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBtZXNzYWdlOiAnJ1xuICAgICAgICAgICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgICAgICAgICAgd2hvRWxzZS5pc0RlbGV0ZWQgPSB0cnVlO1xuICAgICAgICAgICAgICAgICAgICAgICAgYXdhaXQgd2hvRWxzZS5zYXZlKCk7XG4gICAgICAgICAgICAgICAgICAgICAgICBsZXQgaXNSZXBvcnRlciA9IGVtYWlsUmVwb3J0ZWQ/LnJlcG9ydGVycy5maW5kKHJlcG9ydGVyID0+IHJlcG9ydGVyLmVtYWlsLnRvTG93ZXJDYXNlKCkgPT09IHdob0Vsc2UudG8udG9Mb3dlckNhc2UoKSlcblxuICAgICAgICAgICAgICAgICAgICAgICAgaWYoZW1haWxSZXBvcnRlZC50byAhPT0gd2hvRWxzZS50byAmJiAhaXNSZXBvcnRlcikgbWFpbGVyLnNlbmRSZXN1bHRNYWlsVG9PdGhlclJlcG9ydGVycyh3aG9FbHNlLm5hbWUgLHdob0Vsc2UudG8sIHdob0Vsc2UuZnJvbSwgd2hvRWxzZS5zdWJqZWN0LCBlbWFpbFJlcG9ydGVkLm1haWxSZWNpZXZlZFRpbWUsICdEZWxldGVkJywgY29tcGFueUlkKVxuICAgICAgICAgICAgICAgICAgICAgICAgZWxzZSBtYWlsZXIuc2VuZEFjdGlvblJlc3VsdE1haWwod2hvRWxzZS5uYW1lICx3aG9FbHNlLnRvLCB3aG9FbHNlLmZyb20sIHdob0Vsc2Uuc3ViamVjdCwgZW1haWxSZXBvcnRlZC5tYWlsUmVjaWV2ZWRUaW1lLCAnREVMRVRFRCcsIGZhbHNlLCBudWxsLCBjb21wYW55SWQpXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICAgICAgICAgICAgICAgICAgICAgIHJldHVybiA7XG4gICAgICAgICAgICAgICAgICAgIH0pXG4gICAgICAgICAgICAgICAgICAgIC5jYXRjaChhc3luYyBlcnIgPT4ge1xuICAgICAgICAgICAgICAgICAgICAgICAgd2hvRWxzZS5pc0Vycm9yV2hpbGVNb3ZpbmcgPSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgaXNFcnJvcjogdHJ1ZSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBtZXNzYWdlOiBlcnJcbiAgICAgICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgICAgIGF3YWl0IHdob0Vsc2Uuc2F2ZSgpO1xuICAgICAgICAgICAgICAgICAgICAgICAgcmV0dXJuIDtcbiAgICAgICAgICAgICAgICAgICAgfSlcbiAgICAgICAgICAgICAgICB9IGVsc2Uge1xuICAgICAgICAgICAgICAgICAgICB3aG9FbHNlLmlzRXJyb3JXaGlsZU1vdmluZyA9IHtcbiAgICAgICAgICAgICAgICAgICAgICAgIGlzRXJyb3I6IHRydWUsXG4gICAgICAgICAgICAgICAgICAgICAgICBtZXNzYWdlOiAnbWVzc2FnZUlkIG9yIHRocmVhZElkIGlzIG1pc3NpbmcnXG4gICAgICAgICAgICAgICAgICAgIH1cbiAgICAgICAgICAgICAgICAgICAgYXdhaXQgd2hvRWxzZS5zYXZlKCk7XG4gICAgICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgfVxuICAgICAgICAgICAgICAgIFxuICAgICAgICBcbiAgICAgXG4gICAgICAgICAgICB1cGRhdGVSZXBvcnRlZE1haWxDYWNoZShyZXBvcnRlZE1haWxJZCx7aXNUcmFzaGVkRW1haWw6XCJmYWxzZVwiLCBpc1JlY292ZXJlZEVtYWlsOlwiZmFsc2VcIiwgaXNEZWxldGVkRW1haWw6XCJ0cnVlXCJ9KVxuICAgICAgICAgICAgZW1haWxSZXBvcnRlZC5pc1JlY292ZXJlZEVtYWlsID0gZmFsc2U7XG4gICAgICAgICAgICBlbWFpbFJlcG9ydGVkLmlzVHJhc2hlZEVtYWlsID0gZmFsc2U7XG4gICAgICAgICAgICBlbWFpbFJlcG9ydGVkLmlzRGVsZXRlZEVtYWlsID0gdHJ1ZTtcbiAgICAgICAgICAgIGF3YWl0IGVtYWlsUmVwb3J0ZWQuc2F2ZSgpXG4gICAgICAgIHJldHVybiByZXMuc3RhdHVzKDIwMCkuc2VuZCh7IHN1Y2Nlc3M6IHRydWUsIE1lc3NhZ2U6IFwiU3VjY2Vzc2Z1bGx5IERlbGV0ZWQhXCJ9KVxuICAgIH1cbiAgICBjYXRjaCAoZXJyb3IpIHtcbiAgICAgICAgY29uc29sZS5sb2coXCJlcnJvclwiLCBlcnJvcik7XG4gICAgICAgIG5leHQoZXJyb3IpO1xuICAgIH1cbn1cbmNvbnN0IGFwaVJvdXRlciA9IGV4cHJlc3MuUm91dGVyKCk7XG5hcGlSb3V0ZXIucm91dGUoJy8nKS5wb3N0KGh0bWxzYW5pdGl6ZSgpICwgand0U3RyYXRlZ3ksIGNoZWNrQ29tcGFueVZhbGlkaXR5U3RyYXRlZ3ksIHJlc3RyaWN0RmVhdHVyZShcIlRQSVItQVJURFwiKSwgcGVybWlzc2lvbignRW1haWxzJywnRGVsZXRlJyksIHZhbGlkYXRlQm9keSh2YWxpZGF0b3IpLCBjb250cm9sbGVyKTtcbmV4cG9ydCBkZWZhdWx0IGFwaVJvdXRlcjsiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBO0FBQ0E7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUErRDtBQUFBO0FBQUE7QUFFL0QsSUFBSUEsU0FBUyxHQUFHQyxlQUFHLENBQUNDLE1BQU0sRUFBRSxDQUFDQyxJQUFJLENBQUM7RUFDOUJDLFVBQVUsRUFBRUgsZUFBRyxDQUFDSSxLQUFLLEVBQUUsQ0FBQ0MsS0FBSyxDQUN6QkwsZUFBRyxDQUFDTSxNQUFNLEVBQUUsQ0FBQ0MsR0FBRyxFQUFFLENBQUNDLE1BQU0sQ0FBQyxFQUFFLENBQUMsQ0FDaEMsQ0FBQ0MsUUFBUSxFQUFFO0VBQ1pDLGNBQWMsRUFBRVYsZUFBRyxDQUFDTSxNQUFNLEVBQUUsQ0FBQ0MsR0FBRyxFQUFFLENBQUNDLE1BQU0sQ0FBQyxFQUFFLENBQUMsQ0FBQ0csUUFBUTtBQUMxRCxDQUFDLENBQUM7O0FBRUY7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7QUFFQSxJQUFJQyxVQUFVO0VBQUEseUZBQUcsa0JBQU9DLEdBQUcsRUFBRUMsR0FBRyxFQUFFQyxJQUFJO0lBQUE7SUFBQTtNQUFBO1FBQUE7VUFBQTtVQUV0QkwsY0FBYyxHQUFLRyxHQUFHLENBQUNHLElBQUksQ0FBM0JOLGNBQWM7VUFDaEJPLFNBQVMsR0FBR0osR0FBRyxDQUFDSyxJQUFJLENBQUNELFNBQVM7VUFBQTtVQUFBLE9BQ1JFLEVBQUUsQ0FBQ0MsWUFBWSxDQUFDQyxPQUFPLENBQUM7WUFDaERDLEdBQUcsRUFBRVosY0FBYztZQUNuQk8sU0FBUyxFQUFUQTtVQUNKLENBQUMsQ0FBQztRQUFBO1VBSElNLGFBQWE7VUFBQSxJQUtmQSxhQUFhO1lBQUE7WUFBQTtVQUFBO1VBQUEsTUFDUCxJQUFJQyxZQUFZLENBQUMsaUNBQWlDLENBQUM7UUFBQTtVQUFBLE1BRTFERCxhQUFhLENBQUNFLG1CQUFtQixJQUFFLE1BQU07WUFBQTtZQUFBO1VBQUE7VUFBQSxNQUFRLElBQUlELFlBQVksQ0FBQyx1RUFBdUUsQ0FBQztRQUFBO1VBQUE7VUFBQSxPQUV0SEwsRUFBRSxDQUFDTyxPQUFPLENBQUNDLElBQUksQ0FBQztZQUFDakIsY0FBYyxFQUFkQSxjQUFjO1lBQUVPLFNBQVMsRUFBVEEsU0FBUztZQUFFVyxTQUFTLEVBQUUsS0FBSztZQUFFQyxTQUFTLEVBQUU7VUFBSSxDQUFDLENBQUMsQ0FBQ0MsTUFBTSxDQUFDLEtBQUssQ0FBQztRQUFBO1VBQWhIM0IsVUFBVTtVQUNkQSxVQUFVLEdBQUdBLFVBQVUsQ0FBQzRCLEdBQUcsQ0FBQyxVQUFBQyxPQUFPO1lBQUEsT0FBSUEsT0FBTyxDQUFDVixHQUFHO1VBQUEsRUFBQztVQUFBLE1BR2hEQyxhQUFhLENBQUNVLFFBQVEsSUFBSSxVQUFVO1lBQUE7WUFBQTtVQUFBO1VBQUE7VUFBQSxPQUNoQmQsRUFBRSxDQUFDZSxJQUFJLENBQUNiLE9BQU8sQ0FBQztZQUFFYyxLQUFLLEVBQUVaLGFBQWEsQ0FBQ2E7VUFBRyxDQUFDLENBQUM7UUFBQTtVQUF6RGxCLElBQUk7VUFDVm1CLGtCQUFNLENBQUNDLG9CQUFvQixDQUFDcEIsSUFBSSxDQUFDcUIsSUFBSSxFQUFFaEIsYUFBYSxDQUFDYSxFQUFFLEVBQUViLGFBQWEsQ0FBQ2lCLElBQUksRUFBRWpCLGFBQWEsQ0FBQ2tCLE9BQU8sRUFBRWxCLGFBQWEsQ0FBQ21CLGdCQUFnQixFQUFFLFFBQVEsRUFBRSxLQUFLLEVBQUUsRUFBRSxFQUFFekIsU0FBUyxDQUFDO1VBQ25LLElBQUdNLGFBQWEsQ0FBQ29CLFNBQVMsQ0FBQ25DLE1BQU0sSUFBRSxDQUFDLEVBQUU7WUFDbENlLGFBQWEsQ0FBQ29CLFNBQVMsQ0FBQ0MsT0FBTztjQUFBLDBGQUFDLGlCQUFPQyxRQUFRO2dCQUFBO2dCQUFBO2tCQUFBO29CQUFBO3NCQUFBO3NCQUFBLE9BQ3hCMUIsRUFBRSxDQUFDZSxJQUFJLENBQUNiLE9BQU8sQ0FBQzt3QkFBRWMsS0FBSyxFQUFFVSxRQUFRLGFBQVJBLFFBQVEsdUJBQVJBLFFBQVEsQ0FBRVY7c0JBQU0sQ0FBQyxDQUFDO29CQUFBO3NCQUF4RGpCLElBQUk7c0JBQ1ZtQixrQkFBTSxDQUFDQyxvQkFBb0IsQ0FBQ3BCLElBQUksQ0FBQ3FCLElBQUksRUFBRU0sUUFBUSxDQUFDVixLQUFLLEVBQUVaLGFBQWEsQ0FBQ2lCLElBQUksRUFBRWpCLGFBQWEsQ0FBQ2tCLE9BQU8sRUFBRWxCLGFBQWEsQ0FBQ21CLGdCQUFnQixFQUFDLFFBQVEsRUFBRSxLQUFLLEVBQUUsRUFBRSxFQUFFekIsU0FBUyxDQUFDO29CQUFBO29CQUFBO3NCQUFBO2tCQUFBO2dCQUFBO2NBQUEsQ0FDbks7Y0FBQTtnQkFBQTtjQUFBO1lBQUEsSUFBQztVQUNOO1VBQ0EsSUFBQTZCLGtDQUF1QixFQUFDcEMsY0FBYyxFQUFDO1lBQUNxQyxjQUFjLEVBQUMsT0FBTztZQUFFQyxnQkFBZ0IsRUFBQyxPQUFPO1lBQUVDLGNBQWMsRUFBQztVQUFNLENBQUMsQ0FBQztVQUVqSDFCLGFBQWEsQ0FBQ3lCLGdCQUFnQixHQUFHLEtBQUs7VUFDdEN6QixhQUFhLENBQUN3QixjQUFjLEdBQUcsS0FBSztVQUNwQ3hCLGFBQWEsQ0FBQzBCLGNBQWMsR0FBRyxJQUFJO1VBQUM7VUFBQSxPQUM5QjFCLGFBQWEsQ0FBQzJCLElBQUksRUFBRTtRQUFBO1VBQUEsa0NBQ25CcEMsR0FBRyxDQUFDcUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDQyxJQUFJLENBQUM7WUFBRUMsT0FBTyxFQUFFLElBQUk7WUFBRUMsT0FBTyxFQUFFO1VBQWdDLENBQUMsQ0FBQztRQUFBO1VBR3BGQyxvQkFBb0IsR0FBRyxDQUFDLENBQUM7VUFFekJDLFFBQVEsR0FBRyxFQUFFO1VBQ2JDLFNBQVMsR0FBRyxFQUFFO1VBQUEsdUNBRUd0RCxVQUFVO1VBQUE7VUFBQTtRQUFBO1VBQUE7WUFBQTtZQUFBO1VBQUE7VUFBckI2QixRQUFPO1VBQUE7VUFBQSxPQUNNYixFQUFFLENBQUNPLE9BQU8sQ0FBQ0wsT0FBTyxDQUFDO1lBQUNKLFNBQVMsRUFBVEEsU0FBUztZQUFFSyxHQUFHLEVBQUVVO1VBQU8sQ0FBQyxDQUFDLENBQUMwQixRQUFRLENBQUMsVUFBVSxFQUFFLGdCQUFnQixDQUFDO1FBQUE7VUFBbkdDLE1BQU07VUFDVixJQUFHQSxNQUFNLENBQUNDLFFBQVEsQ0FBQ0MsVUFBVSxJQUFJLFFBQVEsRUFBRUosU0FBUyxDQUFDSyxJQUFJLENBQUNILE1BQU0sQ0FBQyxNQUM1REgsUUFBUSxDQUFDTSxJQUFJLENBQUNILE1BQU0sQ0FBQztRQUFBO1VBQUE7VUFBQTtRQUFBO1VBQUE7VUFBQTtRQUFBO1VBQUE7VUFBQTtVQUFBO1FBQUE7VUFBQTtVQUFBO1VBQUE7UUFBQTtVQUc5QixLQUFRSSxDQUFDLEdBQUMsQ0FBQyxFQUFDQSxDQUFDLEdBQUNQLFFBQVEsQ0FBQ2hELE1BQU0sRUFBQ3VELENBQUMsRUFBRSxFQUFDO1lBQzFCL0IsT0FBTyxHQUFHd0IsUUFBUSxDQUFDTyxDQUFDLENBQUM7WUFDekIsSUFBRyxDQUFDUixvQkFBb0IsQ0FBQ3ZCLE9BQU8sQ0FBQzRCLFFBQVEsQ0FBQ3RDLEdBQUcsQ0FBQyxFQUFHaUMsb0JBQW9CLENBQUN2QixPQUFPLENBQUM0QixRQUFRLENBQUN0QyxHQUFHLENBQUMsR0FBRyxFQUFFO1lBR2hHLElBQUdpQyxvQkFBb0IsQ0FBQ3ZCLE9BQU8sQ0FBQzRCLFFBQVEsQ0FBQ3RDLEdBQUcsQ0FBQyxDQUFDZCxNQUFNLEdBQUcsQ0FBQyxFQUFDO2NBQ2pEd0QsU0FBUyxHQUFHVCxvQkFBb0IsQ0FBQ3ZCLE9BQU8sQ0FBQzRCLFFBQVEsQ0FBQ3RDLEdBQUcsQ0FBQyxDQUFDMkMsR0FBRyxFQUFFO2NBQ2hFLElBQUdELFNBQVMsQ0FBQ3hELE1BQU0sR0FBRyxFQUFFLEVBQUV3RCxTQUFTLENBQUNGLElBQUksQ0FBQzlCLE9BQU8sQ0FBQyxFQUFFdUIsb0JBQW9CLENBQUN2QixPQUFPLENBQUM0QixRQUFRLENBQUN0QyxHQUFHLENBQUMsQ0FBQ3dDLElBQUksQ0FBQ0UsU0FBUyxDQUFDLE1BQ3hHVCxvQkFBb0IsQ0FBQ3ZCLE9BQU8sQ0FBQzRCLFFBQVEsQ0FBQ3RDLEdBQUcsQ0FBQyxDQUFDd0MsSUFBSSxDQUFDRSxTQUFTLENBQUMsRUFBRVQsb0JBQW9CLENBQUN2QixPQUFPLENBQUM0QixRQUFRLENBQUN0QyxHQUFHLENBQUMsQ0FBQ3dDLElBQUksQ0FBQyxDQUFDOUIsT0FBTyxDQUFDLENBQUM7WUFDL0gsQ0FBQyxNQUNJdUIsb0JBQW9CLENBQUN2QixPQUFPLENBQUM0QixRQUFRLENBQUN0QyxHQUFHLENBQUMsQ0FBQ3dDLElBQUksQ0FBQyxDQUFDOUIsT0FBTyxDQUFDLENBQUM7VUFDbkU7VUFHQSxLQUFVa0MsYUFBYSxJQUFJWCxvQkFBb0IsRUFBQztZQUN4Q1ksS0FBSyxHQUFHLENBQUM7WUFDYixLQUFRSixFQUFDLEdBQUMsQ0FBQyxFQUFDQSxFQUFDLEdBQUNSLG9CQUFvQixDQUFDVyxhQUFhLENBQUMsQ0FBQzFELE1BQU0sRUFBRXVELEVBQUMsSUFBRSxFQUFFLEVBQUM7Y0FDNURLLFVBQUssQ0FBQ0MsTUFBTSxDQUFDLGlDQUFpQyxFQUFDO2dCQUFDYixRQUFRLEVBQUVELG9CQUFvQixDQUFDVyxhQUFhLENBQUMsQ0FBQ0ksS0FBSyxDQUFDUCxFQUFDLEVBQUNRLElBQUksQ0FBQ0MsR0FBRyxDQUFDVCxFQUFDLEdBQUMsRUFBRSxFQUFDUixvQkFBb0IsQ0FBQ1csYUFBYSxDQUFDLENBQUMxRCxNQUFNLENBQUMsQ0FBQztnQkFDNUpvRCxRQUFRLEVBQUVNLGFBQWE7Z0JBQUVqRCxTQUFTLEVBQUVKLEdBQUcsQ0FBQ0ssSUFBSSxDQUFDRCxTQUFTO2dCQUN0RE0sYUFBYSxFQUFiQSxhQUFhO2dCQUNia0QsVUFBVSxFQUFDO2NBQVUsQ0FBQyxDQUFDLENBQzFCQyxnQkFBZ0IsQ0FBQyxJQUFJLENBQUMsQ0FBQ0MsUUFBUSxDQUFDLE1BQU0sQ0FBQyxDQUFDekIsSUFBSSxFQUFFO1lBQ25EO1VBQ0o7UUFBQztVQUFBLE1BR0ZPLFNBQVMsQ0FBQ2pELE1BQU0sR0FBQyxDQUFDO1lBQUE7WUFBQTtVQUFBO1VBQUE7WUFBQTtZQUFBO2NBQUE7Z0JBQUE7a0JBQUE7a0JBQUEsT0FFT1csRUFBRSxDQUFDTyxPQUFPLENBQUNMLE9BQU8sQ0FBQztvQkFBQ0MsR0FBRyxFQUFFbUMsU0FBUyxDQUFDTSxHQUFDO2tCQUFDLENBQUMsQ0FBQztnQkFBQTtrQkFBdkQvQixPQUFPO2tCQUFBLE1BQ1JBLE9BQU8sQ0FBQzRDLFNBQVMsSUFBSTVDLE9BQU8sQ0FBQzZDLFFBQVE7b0JBQUE7b0JBQUE7a0JBQUE7a0JBQUE7a0JBQUEsT0FDWEMsdUJBQVcsQ0FBQ0MsY0FBYyxDQUFDOUQsU0FBUyxFQUFFZSxPQUFPLENBQUM0QixRQUFRLENBQUM7Z0JBQUE7a0JBQUE7a0JBQTFFb0IsUUFBUSx5QkFBUkEsUUFBUTtrQkFBQTtrQkFBQSxPQUNSQywyQkFBZSxDQUFDQyxzQkFBc0IsQ0FBQztvQkFDekNGLFFBQVEsRUFBUkEsUUFBUTtvQkFDUjdDLEtBQUssRUFBRUgsT0FBTyxDQUFDSSxFQUFFO29CQUNqQnlDLFFBQVEsRUFBRTdDLE9BQU8sQ0FBQzZDLFFBQVE7b0JBQzFCRCxTQUFTLEVBQUU1QyxPQUFPLENBQUM0QztrQkFDdkIsQ0FBQyxDQUFDLENBQ0RPLElBQUksNkZBQUM7b0JBQUE7b0JBQUE7c0JBQUE7d0JBQUE7MEJBQ0ZuRCxPQUFPLENBQUNvRCxrQkFBa0IsR0FBRzs0QkFDekJDLE9BQU8sRUFBRSxLQUFLOzRCQUNkQyxPQUFPLEVBQUU7MEJBQ2IsQ0FBQzswQkFDRHRELE9BQU8sQ0FBQ0osU0FBUyxHQUFHLElBQUk7MEJBQUM7MEJBQUEsT0FDbkJJLE9BQU8sQ0FBQ2tCLElBQUksRUFBRTt3QkFBQTswQkFDaEJxQyxVQUFVLEdBQUdoRSxhQUFhLGFBQWJBLGFBQWEsdUJBQWJBLGFBQWEsQ0FBRW9CLFNBQVMsQ0FBQ2hCLElBQUksQ0FBQyxVQUFBa0IsUUFBUTs0QkFBQSxPQUFJQSxRQUFRLENBQUNWLEtBQUssQ0FBQ3FELFdBQVcsRUFBRSxLQUFLeEQsT0FBTyxDQUFDSSxFQUFFLENBQUNvRCxXQUFXLEVBQUU7MEJBQUEsRUFBQzswQkFFckgsSUFBR2pFLGFBQWEsQ0FBQ2EsRUFBRSxLQUFLSixPQUFPLENBQUNJLEVBQUUsSUFBSSxDQUFDbUQsVUFBVSxFQUFFbEQsa0JBQU0sQ0FBQ29ELDhCQUE4QixDQUFDekQsT0FBTyxDQUFDTyxJQUFJLEVBQUVQLE9BQU8sQ0FBQ0ksRUFBRSxFQUFFSixPQUFPLENBQUNRLElBQUksRUFBRVIsT0FBTyxDQUFDUyxPQUFPLEVBQUVsQixhQUFhLENBQUNtQixnQkFBZ0IsRUFBRSxTQUFTLEVBQUV6QixTQUFTLENBQUMsTUFDbE1vQixrQkFBTSxDQUFDQyxvQkFBb0IsQ0FBQ04sT0FBTyxDQUFDTyxJQUFJLEVBQUVQLE9BQU8sQ0FBQ0ksRUFBRSxFQUFFSixPQUFPLENBQUNRLElBQUksRUFBRVIsT0FBTyxDQUFDUyxPQUFPLEVBQUVsQixhQUFhLENBQUNtQixnQkFBZ0IsRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFFLElBQUksRUFBRXpCLFNBQVMsQ0FBQzswQkFBQTt3QkFBQTt3QkFBQTswQkFBQTtzQkFBQTtvQkFBQTtrQkFBQSxDQUcvSixHQUFDLFNBQ0k7b0JBQUEsMEZBQUMsa0JBQU15RSxHQUFHO3NCQUFBO3dCQUFBOzBCQUFBOzRCQUNaMUQsT0FBTyxDQUFDb0Qsa0JBQWtCLEdBQUc7OEJBQ3pCQyxPQUFPLEVBQUUsSUFBSTs4QkFDYkMsT0FBTyxFQUFFSTs0QkFDYixDQUFDOzRCQUFBOzRCQUFBLE9BQ0sxRCxPQUFPLENBQUNrQixJQUFJLEVBQUU7MEJBQUE7NEJBQUE7MEJBQUE7MEJBQUE7NEJBQUE7d0JBQUE7c0JBQUE7b0JBQUEsQ0FFdkI7b0JBQUE7c0JBQUE7b0JBQUE7a0JBQUEsSUFBQztnQkFBQTtrQkFBQTtrQkFBQTtnQkFBQTtrQkFFRmxCLE9BQU8sQ0FBQ29ELGtCQUFrQixHQUFHO29CQUN6QkMsT0FBTyxFQUFFLElBQUk7b0JBQ2JDLE9BQU8sRUFBRTtrQkFDYixDQUFDO2tCQUFBO2tCQUFBLE9BQ0t0RCxPQUFPLENBQUNrQixJQUFJLEVBQUU7Z0JBQUE7Z0JBQUE7a0JBQUE7Y0FBQTtZQUFBO1VBQUE7VUFyQ3BCYSxHQUFDLEdBQUMsQ0FBQztRQUFBO1VBQUEsTUFBQ0EsR0FBQyxHQUFDTixTQUFTLENBQUNqRCxNQUFNO1lBQUE7WUFBQTtVQUFBO1VBQUE7UUFBQTtVQUFDdUQsR0FBQyxFQUFFO1VBQUE7VUFBQTtRQUFBO1VBNENsQyxJQUFBakIsa0NBQXVCLEVBQUNwQyxjQUFjLEVBQUM7WUFBQ3FDLGNBQWMsRUFBQyxPQUFPO1lBQUVDLGdCQUFnQixFQUFDLE9BQU87WUFBRUMsY0FBYyxFQUFDO1VBQU0sQ0FBQyxDQUFDO1VBQ2pIMUIsYUFBYSxDQUFDeUIsZ0JBQWdCLEdBQUcsS0FBSztVQUN0Q3pCLGFBQWEsQ0FBQ3dCLGNBQWMsR0FBRyxLQUFLO1VBQ3BDeEIsYUFBYSxDQUFDMEIsY0FBYyxHQUFHLElBQUk7VUFBQztVQUFBLE9BQzlCMUIsYUFBYSxDQUFDMkIsSUFBSSxFQUFFO1FBQUE7VUFBQSxrQ0FDdkJwQyxHQUFHLENBQUNxQyxNQUFNLENBQUMsR0FBRyxDQUFDLENBQUNDLElBQUksQ0FBQztZQUFFQyxPQUFPLEVBQUUsSUFBSTtZQUFFQyxPQUFPLEVBQUU7VUFBdUIsQ0FBQyxDQUFDO1FBQUE7VUFBQTtVQUFBO1VBRy9FcUMsT0FBTyxDQUFDQyxHQUFHLENBQUMsT0FBTyxlQUFRO1VBQzNCN0UsSUFBSSxjQUFPO1FBQUM7UUFBQTtVQUFBO01BQUE7SUFBQTtFQUFBLENBRW5CO0VBQUEsZ0JBaklHSCxVQUFVO0lBQUE7RUFBQTtBQUFBLEdBaUliO0FBQ0QsSUFBTWlGLFNBQVMsR0FBR0MsbUJBQU8sQ0FBQ0MsTUFBTSxFQUFFO0FBQ2xDRixTQUFTLENBQUNHLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQ0MsSUFBSSxDQUFDLElBQUFDLDBCQUFZLEdBQUUsRUFBR0MscUJBQVcsRUFBRUMsc0NBQTRCLEVBQUUsSUFBQUMsMEJBQWUsRUFBQyxXQUFXLENBQUMsRUFBRSxJQUFBQyxzQkFBVSxFQUFDLFFBQVEsRUFBQyxRQUFRLENBQUMsRUFBRSxJQUFBQyx1QkFBWSxFQUFDeEcsU0FBUyxDQUFDLEVBQUVhLFVBQVUsQ0FBQztBQUFDLGVBQ3pLaUYsU0FBUztBQUFBIn0=