"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _credentials = _interopRequireDefault(require("../../service/credentials"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _moveEmailGsuite = _interopRequireDefault(require("../../service/move-email-gsuite"));
var _moveEmailOutlook = _interopRequireDefault(require("../../service/move-email-outlook"));
var _mailer = _interopRequireDefault(require("../../mailer"));
var _permission = require("../../middlewares/permission");
var _kue = require("../../kue");
var _functions = require("../../functions");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _updateMessageId = _interopRequireDefault(require("../../service/update-messageId"));
var validator = _joi["default"].object().keys({
  whoElseIds: _joi["default"].array().items(_joi["default"].string().hex().length(24)),
  reportedMailId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/mail-actions/move-to-delete Delete Mail
 * @apiName move-to-delete
 * @apiGroup Who-Else
 * @apiDescription Delete a particular who-else mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}  whoElseIds   Required who-else id of the mail to be deleted
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  Message    "Successfully deleted and will be update in sometime"
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "Message": "Successfully deleted and will be update in sometime"
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    messages    ["\"whoElseIds[0]\" is not allowed to be empty"]
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "\"whoElseIds[0]\" is not allowed to be empty"
 *          ]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee8(req, res, next) {
    var _req$body, _req$body$whoElseIds, whoElseIds, reportedMailId, companyId, emailReported, domain, user, whoElseBatches, _yield$credentials$ge, token, update, _loop, i, _ret;
    return _regenerator["default"].wrap(function _callee8$(_context9) {
      while (1) switch (_context9.prev = _context9.next) {
        case 0:
          _context9.prev = 0;
          _req$body = req.body, _req$body$whoElseIds = _req$body.whoElseIds, whoElseIds = _req$body$whoElseIds === void 0 ? [] : _req$body$whoElseIds, reportedMailId = _req$body.reportedMailId;
          companyId = req.user.companyId;
          _context9.next = 5;
          return db.ReportedMail.findOne({
            _id: reportedMailId,
            companyId: companyId
          });
        case 5:
          emailReported = _context9.sent;
          if (emailReported) {
            _context9.next = 8;
            break;
          }
          throw new RequestError('invalid reportedMailId recieved');
        case 8:
          _context9.next = 10;
          return db.Domain.findOne({
            _id: emailReported.domainId,
            deletedAt: null
          });
        case 10:
          domain = _context9.sent;
          if (domain) {
            _context9.next = 13;
            break;
          }
          throw new RequestError('invalid domain or deleted');
        case 13:
          if (!(emailReported.mailType !== 'Exchange')) {
            _context9.next = 16;
            break;
          }
          if (!(domain.isCredential == false)) {
            _context9.next = 16;
            break;
          }
          throw new RequestError('Domain credentials not set');
        case 16:
          if (!(emailReported.mailType == 'Exchange')) {
            _context9.next = 31;
            break;
          }
          _context9.next = 19;
          return db.User.findOne({
            email: emailReported.to
          });
        case 19:
          user = _context9.sent;
          _mailer["default"].sendActionResultMail(user.name, emailReported.to, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "THREAT", false, "", companyId);
          if (emailReported.reporters.length != 0) {
            emailReported.reporters.forEach( /*#__PURE__*/function () {
              var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(email) {
                var user;
                return _regenerator["default"].wrap(function _callee$(_context) {
                  while (1) switch (_context.prev = _context.next) {
                    case 0:
                      _context.next = 2;
                      return db.User.findOne({
                        email: email
                      });
                    case 2:
                      user = _context.sent;
                      _mailer["default"].sendActionResultMail(user.name, email, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "THREAT", false, "", companyId);
                    case 4:
                    case "end":
                      return _context.stop();
                  }
                }, _callee);
              }));
              return function (_x4) {
                return _ref2.apply(this, arguments);
              };
            }());
          }
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isTrashedEmail: "false",
            isRecoveredEmail: "false",
            isDeletedEmail: "true"
          });
          emailReported.isRecoveredEmail = false;
          emailReported.isTrashedEmail = false;
          emailReported.isDeletedEmail = true;
          _context9.next = 28;
          return emailReported.save();
        case 28:
          return _context9.abrupt("return", res.status(200).send({
            success: true,
            Message: "Successfully marked as deleted!"
          }));
        case 31:
          whoElseBatches = [];
          _context9.next = 34;
          return _credentials["default"].getCredentials(companyId, domain._id);
        case 34:
          _yield$credentials$ge = _context9.sent;
          token = _yield$credentials$ge.token;
          _context9.next = 38;
          return _updateMessageId["default"].processUpdateMessageId(whoElseIds, token);
        case 38:
          update = _context9.sent;
          _loop = /*#__PURE__*/_regenerator["default"].mark(function _loop() {
            var whoElse, _yield$credentials$ge2, fileName;
            return _regenerator["default"].wrap(function _loop$(_context8) {
              while (1) switch (_context8.prev = _context8.next) {
                case 0:
                  _context8.next = 2;
                  return db.WhoElse.findById(whoElseIds[i]);
                case 2:
                  whoElse = _context8.sent;
                  if (whoElse) {
                    _context8.next = 5;
                    break;
                  }
                  return _context8.abrupt("return", "continue");
                case 5:
                  if (!(domain.domainType == 'Outlook')) {
                    _context8.next = 13;
                    break;
                  }
                  whoElseBatches.push({
                    id: whoElse._id.toHexString(),
                    email: whoElse.to,
                    token: token.access_token,
                    messageId: whoElse.messageId
                  });
                  if (!(whoElseBatches.length == 20)) {
                    _context8.next = 11;
                    break;
                  }
                  _context8.next = 10;
                  return _moveEmailOutlook["default"].processMoveEmailDelete(whoElseBatches).then( /*#__PURE__*/function () {
                    var _ref5 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(responses) {
                      return _regenerator["default"].wrap(function _callee4$(_context4) {
                        while (1) switch (_context4.prev = _context4.next) {
                          case 0:
                            _kue.queue.create('process-who-else-trash-batches-outlook', {
                              responses: responses,
                              emailReported: emailReported,
                              Trash: false,
                              Recover: false,
                              Delete: true,
                              companyId: companyId
                            }).removeOnComplete(true).priority('high').save();
                            return _context4.abrupt("return");
                          case 2:
                          case "end":
                            return _context4.stop();
                        }
                      }, _callee4);
                    }));
                    return function (_x7) {
                      return _ref5.apply(this, arguments);
                    };
                  }())["catch"]( /*#__PURE__*/function () {
                    var _ref6 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(err) {
                      return _regenerator["default"].wrap(function _callee5$(_context5) {
                        while (1) switch (_context5.prev = _context5.next) {
                          case 0:
                            console.log(err);
                            return _context5.abrupt("return");
                          case 2:
                          case "end":
                            return _context5.stop();
                        }
                      }, _callee5);
                    }));
                    return function (_x8) {
                      return _ref6.apply(this, arguments);
                    };
                  }());
                case 10:
                  whoElseBatches = [];
                case 11:
                  _context8.next = 25;
                  break;
                case 13:
                  if (!(whoElse.messageId && whoElse.threadId)) {
                    _context8.next = 22;
                    break;
                  }
                  _context8.next = 16;
                  return _credentials["default"].getCredentials(companyId, domain._id);
                case 16:
                  _yield$credentials$ge2 = _context8.sent;
                  fileName = _yield$credentials$ge2.fileName;
                  _context8.next = 20;
                  return _moveEmailGsuite["default"].processMoveEmailDelete({
                    fileName: fileName,
                    email: whoElse.to,
                    threadId: whoElse.threadId,
                    messageId: whoElse.messageId
                  }).then( /*#__PURE__*/(0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee6() {
                    return _regenerator["default"].wrap(function _callee6$(_context6) {
                      while (1) switch (_context6.prev = _context6.next) {
                        case 0:
                          whoElse.isErrorWhileMoving = {
                            isError: false,
                            message: ''
                          };
                          whoElse.isDeleted = true;
                          _context6.next = 4;
                          return whoElse.save();
                        case 4:
                          if (emailReported.to !== whoElse.to) _mailer["default"].sendResultMailToOtherReporters(whoElse.name, whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'Deleted', companyId);else _mailer["default"].sendActionResultMail(whoElse.name, whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'DELETED', false, null, companyId);
                          return _context6.abrupt("return");
                        case 6:
                        case "end":
                          return _context6.stop();
                      }
                    }, _callee6);
                  })))["catch"]( /*#__PURE__*/function () {
                    var _ref8 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee7(err) {
                      return _regenerator["default"].wrap(function _callee7$(_context7) {
                        while (1) switch (_context7.prev = _context7.next) {
                          case 0:
                            whoElse.isErrorWhileMoving = {
                              isError: true,
                              message: err
                            };
                            _context7.next = 3;
                            return whoElse.save();
                          case 3:
                            return _context7.abrupt("return");
                          case 4:
                          case "end":
                            return _context7.stop();
                        }
                      }, _callee7);
                    }));
                    return function (_x9) {
                      return _ref8.apply(this, arguments);
                    };
                  }());
                case 20:
                  _context8.next = 25;
                  break;
                case 22:
                  whoElse.isErrorWhileMoving = {
                    isError: true,
                    message: 'messageId or threadId is missing'
                  };
                  _context8.next = 25;
                  return whoElse.save();
                case 25:
                case "end":
                  return _context8.stop();
              }
            }, _loop);
          });
          i = 0;
        case 41:
          if (!(i < whoElseIds.length)) {
            _context9.next = 49;
            break;
          }
          return _context9.delegateYield(_loop(), "t0", 43);
        case 43:
          _ret = _context9.t0;
          if (!(_ret === "continue")) {
            _context9.next = 46;
            break;
          }
          return _context9.abrupt("continue", 46);
        case 46:
          i++;
          _context9.next = 41;
          break;
        case 49:
          if (!whoElseBatches.length) {
            _context9.next = 53;
            break;
          }
          _context9.next = 52;
          return _moveEmailOutlook["default"].processMoveEmailDelete(whoElseBatches).then( /*#__PURE__*/function () {
            var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(responses) {
              return _regenerator["default"].wrap(function _callee2$(_context2) {
                while (1) switch (_context2.prev = _context2.next) {
                  case 0:
                    _kue.queue.create('process-who-else-trash-batches-outlook', {
                      responses: responses,
                      emailReported: emailReported,
                      Trash: false,
                      Recover: false,
                      Delete: true,
                      companyId: companyId
                    }).removeOnComplete(true).priority('high').save();
                    return _context2.abrupt("return");
                  case 2:
                  case "end":
                    return _context2.stop();
                }
              }, _callee2);
            }));
            return function (_x5) {
              return _ref3.apply(this, arguments);
            };
          }())["catch"]( /*#__PURE__*/function () {
            var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(err) {
              return _regenerator["default"].wrap(function _callee3$(_context3) {
                while (1) switch (_context3.prev = _context3.next) {
                  case 0:
                    console.log(err);
                    return _context3.abrupt("return");
                  case 2:
                  case "end":
                    return _context3.stop();
                }
              }, _callee3);
            }));
            return function (_x6) {
              return _ref4.apply(this, arguments);
            };
          }());
        case 52:
          whoElseBatches = [];
        case 53:
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isTrashedEmail: "false",
            isRecoveredEmail: "false",
            isDeletedEmail: "true"
          });
          emailReported.isRecoveredEmail = false;
          emailReported.isTrashedEmail = false;
          emailReported.isDeletedEmail = true;
          _context9.next = 59;
          return emailReported.save();
        case 59:
          return _context9.abrupt("return", res.status(200).send({
            success: true,
            Message: "Successfully deleted!"
          }));
        case 60:
          _context9.next = 66;
          break;
        case 62:
          _context9.prev = 62;
          _context9.t1 = _context9["catch"](0);
          console.log("error", _context9.t1);
          next(_context9.t1);
        case 66:
        case "end":
          return _context9.stop();
      }
    }, _callee8, null, [[0, 62]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _permission.permission)('Emails', 'Delete'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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