"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _credentials = _interopRequireDefault(require("../../service/credentials"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _moveEmailGsuite = _interopRequireDefault(require("../../service/move-email-gsuite"));
var _moveEmailOutlook = _interopRequireDefault(require("../../service/move-email-outlook"));
var _mailer = _interopRequireDefault(require("../../mailer"));
var _permission = require("../../middlewares/permission");
var _kue = require("../../kue");
var _functions = require("../../functions");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _updateMessageId = _interopRequireDefault(require("../../service/update-messageId"));
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var validator = _joi["default"].object().keys({
  whoElseIds: _joi["default"].array().items(_joi["default"].string().hex().length(24)).optional(),
  reportedMailId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/mail-actions/move-to-trash Trash Mail
 * @apiName move-to-trash
 * @apiGroup Who-Else
 * @apiDescription Trash a particular who-else mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}  whoElseIds   Required who-else id of the mail to be trashed
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  Message    "Successfully trashed and will be update in sometime"
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "Message": "Successfully deleted and will be update in sometime"
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    messages    ["\"whoElseIds[0]\" is not allowed to be empty"]
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "\"whoElseIds[0]\" is not allowed to be empty"
 *          ]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(req, res, next) {
    var reportedMailId, companyId, emailReported, whoElseIds, user, whoElseIdsDomainWise, whoElses, gsuiteIds, _iterator, _step, _whoElse, result, i, whoElse, lastArray, domainWhoelse, _i, _loop, _i2;
    return _regenerator["default"].wrap(function _callee4$(_context5) {
      while (1) switch (_context5.prev = _context5.next) {
        case 0:
          _context5.prev = 0;
          reportedMailId = req.body.reportedMailId;
          companyId = req.user.companyId;
          _context5.next = 5;
          return db.ReportedMail.findOne({
            _id: reportedMailId,
            companyId: companyId
          });
        case 5:
          emailReported = _context5.sent;
          if (emailReported) {
            _context5.next = 8;
            break;
          }
          throw new RequestError('invalid reportedMailId recieved');
        case 8:
          if (!(emailReported.isWhoElseProcessing == 'true')) {
            _context5.next = 10;
            break;
          }
          throw new RequestError('Who-Else Search in Progress. Please wait and refresh before retrying.');
        case 10:
          _context5.next = 12;
          return db.WhoElse.find({
            reportedMailId: reportedMailId,
            companyId: companyId,
            isDeleted: false,
            deletedAt: null
          }).select('_id');
        case 12:
          whoElseIds = _context5.sent;
          whoElseIds = whoElseIds.map(function (whoElse) {
            return whoElse._id;
          });
          if (!(emailReported.mailType == 'Exchange')) {
            _context5.next = 30;
            break;
          }
          _context5.next = 17;
          return db.User.findOne({
            email: emailReported.to
          });
        case 17:
          user = _context5.sent;
          _context5.next = 20;
          return _mailer["default"].sendActionResultMail(user.name, emailReported.to, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "SPAM", false, "", companyId);
        case 20:
          console.log('Reporterss-----------------', emailReported.reporters);
          if (emailReported.reporters.length != 0) {
            emailReported.reporters.forEach( /*#__PURE__*/function () {
              var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(reporter) {
                var user;
                return _regenerator["default"].wrap(function _callee$(_context) {
                  while (1) switch (_context.prev = _context.next) {
                    case 0:
                      _context.next = 2;
                      return db.User.findOne({
                        email: reporter === null || reporter === void 0 ? void 0 : reporter.email
                      });
                    case 2:
                      user = _context.sent;
                      _context.next = 5;
                      return _mailer["default"].sendActionResultMail(user.name, reporter.email, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "SPAM", false, "", companyId);
                    case 5:
                    case "end":
                      return _context.stop();
                  }
                }, _callee);
              }));
              return function (_x4) {
                return _ref2.apply(this, arguments);
              };
            }());
          }
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isTrashedEmail: "true",
            isRecoveredEmail: "false"
          });
          emailReported.isRecoveredEmail = false;
          emailReported.isTrashedEmail = true;
          _context5.next = 27;
          return emailReported.save();
        case 27:
          return _context5.abrupt("return", res.status(200).send({
            success: true,
            Message: "Successfully marked as Spam!"
          }));
        case 30:
          whoElseIdsDomainWise = {};
          whoElses = [];
          gsuiteIds = [];
          _iterator = _createForOfIteratorHelper(whoElseIds);
          _context5.prev = 34;
          _iterator.s();
        case 36:
          if ((_step = _iterator.n()).done) {
            _context5.next = 44;
            break;
          }
          _whoElse = _step.value;
          _context5.next = 40;
          return db.WhoElse.findOne({
            companyId: companyId,
            _id: _whoElse
          }).populate('domainId', 'domainType _id');
        case 40:
          result = _context5.sent;
          // console.log(result)
          if (result.domainId.domainType == 'Gsuite') gsuiteIds.push(result);else whoElses.push(result);
        case 42:
          _context5.next = 36;
          break;
        case 44:
          _context5.next = 49;
          break;
        case 46:
          _context5.prev = 46;
          _context5.t0 = _context5["catch"](34);
          _iterator.e(_context5.t0);
        case 49:
          _context5.prev = 49;
          _iterator.f();
          return _context5.finish(49);
        case 52:
          for (i = 0; i < whoElses.length; i++) {
            whoElse = whoElses[i];
            if (!whoElseIdsDomainWise[whoElse.domainId._id]) whoElseIdsDomainWise[whoElse.domainId._id] = [];
            if (whoElseIdsDomainWise[whoElse.domainId._id].length > 0) {
              lastArray = whoElseIdsDomainWise[whoElse.domainId._id].pop();
              if (lastArray.length < 20) lastArray.push(whoElse), whoElseIdsDomainWise[whoElse.domainId._id].push(lastArray);else whoElseIdsDomainWise[whoElse.domainId._id].push(lastArray), whoElseIdsDomainWise[whoElse.domainId._id].push([whoElse]);
            } else whoElseIdsDomainWise[whoElse.domainId._id].push([whoElse]);
          }
          for (domainWhoelse in whoElseIdsDomainWise) {
            for (_i = 0; _i < whoElseIdsDomainWise[domainWhoelse].length; _i += 10) {
              _kue.queue.create('process-update-folderId-outlook', {
                whoElses: whoElseIdsDomainWise[domainWhoelse].slice(_i, Math.min(_i + 10, whoElseIdsDomainWise[domainWhoelse].length)),
                domainId: domainWhoelse,
                companyId: req.user.companyId,
                emailReported: emailReported,
                mailAction: 'Trashed'
              }).removeOnComplete(true).priority('high').save();
            }
          }
        case 54:
          if (!(gsuiteIds.length > 0)) {
            _context5.next = 62;
            break;
          }
          _loop = /*#__PURE__*/_regenerator["default"].mark(function _loop() {
            var whoElse, _yield$credentials$ge, fileName;
            return _regenerator["default"].wrap(function _loop$(_context4) {
              while (1) switch (_context4.prev = _context4.next) {
                case 0:
                  _context4.next = 2;
                  return db.WhoElse.findOne({
                    _id: gsuiteIds[_i2]
                  });
                case 2:
                  whoElse = _context4.sent;
                  if (!(whoElse.messageId && whoElse.threadId)) {
                    _context4.next = 12;
                    break;
                  }
                  _context4.next = 6;
                  return _credentials["default"].getCredentials(companyId, whoElse.domainId);
                case 6:
                  _yield$credentials$ge = _context4.sent;
                  fileName = _yield$credentials$ge.fileName;
                  _context4.next = 10;
                  return _moveEmailGsuite["default"].processMoveEmailTrash({
                    fileName: fileName,
                    email: whoElse.to,
                    threadId: whoElse.threadId,
                    messageId: whoElse.messageId
                  }).then( /*#__PURE__*/(0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2() {
                    var isReporter;
                    return _regenerator["default"].wrap(function _callee2$(_context2) {
                      while (1) switch (_context2.prev = _context2.next) {
                        case 0:
                          whoElse.isErrorWhileMoving = {
                            isError: false,
                            message: ''
                          };
                          whoElse.isTrashed = true;
                          _context2.next = 4;
                          return whoElse.save();
                        case 4:
                          isReporter = emailReported === null || emailReported === void 0 ? void 0 : emailReported.reporters.find(function (reporter) {
                            return reporter.email.toLowerCase() === whoElse.to.toLowerCase();
                          });
                          if (emailReported.to !== whoElse.to && !isReporter) _mailer["default"].sendResultMailToOtherReporters(whoElse.name, whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'Trashed', companyId);else _mailer["default"].sendActionResultMail(whoElse.name, whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'TRASHED', false, null, companyId);
                          return _context2.abrupt("return");
                        case 7:
                        case "end":
                          return _context2.stop();
                      }
                    }, _callee2);
                  })))["catch"]( /*#__PURE__*/function () {
                    var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(err) {
                      return _regenerator["default"].wrap(function _callee3$(_context3) {
                        while (1) switch (_context3.prev = _context3.next) {
                          case 0:
                            whoElse.isErrorWhileMoving = {
                              isError: true,
                              message: err
                            };
                            _context3.next = 3;
                            return whoElse.save();
                          case 3:
                            return _context3.abrupt("return");
                          case 4:
                          case "end":
                            return _context3.stop();
                        }
                      }, _callee3);
                    }));
                    return function (_x5) {
                      return _ref4.apply(this, arguments);
                    };
                  }());
                case 10:
                  _context4.next = 15;
                  break;
                case 12:
                  whoElse.isErrorWhileMoving = {
                    isError: true,
                    message: 'messageId or threadId is missing'
                  };
                  _context4.next = 15;
                  return whoElse.save();
                case 15:
                case "end":
                  return _context4.stop();
              }
            }, _loop);
          });
          _i2 = 0;
        case 57:
          if (!(_i2 < gsuiteIds.length)) {
            _context5.next = 62;
            break;
          }
          return _context5.delegateYield(_loop(), "t1", 59);
        case 59:
          _i2++;
          _context5.next = 57;
          break;
        case 62:
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isTrashedEmail: "true",
            isRecoveredEmail: "false"
          });
          emailReported.isRecoveredEmail = false;
          emailReported.isTrashedEmail = true;
          _context5.next = 67;
          return emailReported.save();
        case 67:
          return _context5.abrupt("return", res.status(200).send({
            success: true,
            Message: "Successfully trashed!"
          }));
        case 70:
          _context5.prev = 70;
          _context5.t2 = _context5["catch"](0);
          console.log("error", _context5.t2);
          next(_context5.t2);
        case 74:
        case "end":
          return _context5.stop();
      }
    }, _callee4, null, [[0, 70], [34, 46, 49, 52]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _featureBlocker["default"])("TPIR-ARTD"), _strategy.checkCompanyValidityStrategy, (0, _permission.permission)('Emails', 'Delete'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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