"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _credentials = _interopRequireDefault(require("../../service/credentials"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _moveEmailGsuite = _interopRequireDefault(require("../../service/move-email-gsuite"));
var _moveEmailOutlook = _interopRequireDefault(require("../../service/move-email-outlook"));
var _mailer = _interopRequireDefault(require("../../mailer"));
var _permission = require("../../middlewares/permission");
var _kue = require("../../kue");
var _functions = require("../../functions");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _updateMessageId = _interopRequireDefault(require("../../service/update-messageId"));
var validator = _joi["default"].object().keys({
  whoElseIds: _joi["default"].array().items(_joi["default"].string().hex().length(24)).optional(),
  reportedMailId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/mail-actions/move-to-trash Trash Mail
 * @apiName move-to-trash
 * @apiGroup Who-Else
 * @apiDescription Trash a particular who-else mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}  whoElseIds   Required who-else id of the mail to be trashed
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  Message    "Successfully trashed and will be update in sometime"
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "Message": "Successfully deleted and will be update in sometime"
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    messages    ["\"whoElseIds[0]\" is not allowed to be empty"]
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "\"whoElseIds[0]\" is not allowed to be empty"
 *          ]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee8(req, res, next) {
    var _req$body, _req$body$whoElseIds, whoElseIds, reportedMailId, companyId, emailReported, domain, user, whoElseBatches, _yield$credentials$ge, token, update, _loop, i, _ret;
    return _regenerator["default"].wrap(function _callee8$(_context9) {
      while (1) switch (_context9.prev = _context9.next) {
        case 0:
          _context9.prev = 0;
          _req$body = req.body, _req$body$whoElseIds = _req$body.whoElseIds, whoElseIds = _req$body$whoElseIds === void 0 ? [] : _req$body$whoElseIds, reportedMailId = _req$body.reportedMailId;
          companyId = req.user.companyId;
          _context9.next = 5;
          return db.ReportedMail.findOne({
            _id: reportedMailId,
            companyId: companyId
          });
        case 5:
          emailReported = _context9.sent;
          if (emailReported) {
            _context9.next = 8;
            break;
          }
          throw new RequestError('invalid reportedMailId recieved');
        case 8:
          if (!(emailReported.isWhoElseProcessing == 'true')) {
            _context9.next = 10;
            break;
          }
          throw new RequestError('Who-Else Search in Progress. Please wait and refresh before retrying.');
        case 10:
          _context9.next = 12;
          return db.Domain.findOne({
            _id: emailReported.domainId,
            deletedAt: null
          });
        case 12:
          domain = _context9.sent;
          if (domain) {
            _context9.next = 15;
            break;
          }
          throw new RequestError('invalid domain or deleted');
        case 15:
          if (!(emailReported.mailType !== 'Exchange')) {
            _context9.next = 18;
            break;
          }
          if (!(domain.isCredential == false)) {
            _context9.next = 18;
            break;
          }
          throw new RequestError('Domain credentials not set');
        case 18:
          if (!(emailReported.mailType == 'Exchange')) {
            _context9.next = 32;
            break;
          }
          _context9.next = 21;
          return db.User.findOne({
            email: emailReported.to
          });
        case 21:
          user = _context9.sent;
          _mailer["default"].sendActionResultMail(user.name, emailReported.to, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "SPAM", false, "", companyId);
          if (emailReported.reporters.length != 0) {
            emailReported.reporters.forEach( /*#__PURE__*/function () {
              var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(email) {
                var user;
                return _regenerator["default"].wrap(function _callee$(_context) {
                  while (1) switch (_context.prev = _context.next) {
                    case 0:
                      _context.next = 2;
                      return db.User.findOne({
                        email: email
                      });
                    case 2:
                      user = _context.sent;
                      _mailer["default"].sendActionResultMail(user.name, email, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "SPAM", false, "", companyId);
                    case 4:
                    case "end":
                      return _context.stop();
                  }
                }, _callee);
              }));
              return function (_x4) {
                return _ref2.apply(this, arguments);
              };
            }());
          }
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isTrashedEmail: "true",
            isRecoveredEmail: "false"
          });
          emailReported.isRecoveredEmail = false;
          emailReported.isTrashedEmail = true;
          _context9.next = 29;
          return emailReported.save();
        case 29:
          return _context9.abrupt("return", res.status(200).send({
            success: true,
            Message: "Successfully marked as Spam!"
          }));
        case 32:
          whoElseBatches = [];
          _context9.next = 35;
          return _credentials["default"].getCredentials(companyId, domain._id);
        case 35:
          _yield$credentials$ge = _context9.sent;
          token = _yield$credentials$ge.token;
          _context9.next = 39;
          return _updateMessageId["default"].processUpdateMessageId(whoElseIds, token);
        case 39:
          update = _context9.sent;
          _loop = /*#__PURE__*/_regenerator["default"].mark(function _loop() {
            var whoElse, _yield$credentials$ge2, fileName;
            return _regenerator["default"].wrap(function _loop$(_context8) {
              while (1) switch (_context8.prev = _context8.next) {
                case 0:
                  _context8.next = 2;
                  return db.WhoElse.findById(whoElseIds[i]);
                case 2:
                  whoElse = _context8.sent;
                  if (whoElse) {
                    _context8.next = 5;
                    break;
                  }
                  return _context8.abrupt("return", "continue");
                case 5:
                  if (!(domain.domainType == 'Outlook')) {
                    _context8.next = 13;
                    break;
                  }
                  whoElseBatches.push({
                    id: whoElse._id.toHexString(),
                    email: whoElse.to,
                    token: token.access_token,
                    messageId: whoElse.messageId
                  });
                  if (!(whoElseBatches.length == 20)) {
                    _context8.next = 11;
                    break;
                  }
                  _context8.next = 10;
                  return _moveEmailOutlook["default"].processMoveEmailTrash(whoElseBatches).then( /*#__PURE__*/function () {
                    var _ref5 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(responses) {
                      return _regenerator["default"].wrap(function _callee4$(_context4) {
                        while (1) switch (_context4.prev = _context4.next) {
                          case 0:
                            _kue.queue.create('process-who-else-trash-batches-outlook', {
                              responses: responses,
                              emailReported: emailReported,
                              Trash: true,
                              Recover: false,
                              Delete: false,
                              companyId: companyId
                            }).removeOnComplete(true).priority('high').save();
                            return _context4.abrupt("return");
                          case 2:
                          case "end":
                            return _context4.stop();
                        }
                      }, _callee4);
                    }));
                    return function (_x7) {
                      return _ref5.apply(this, arguments);
                    };
                  }())["catch"]( /*#__PURE__*/function () {
                    var _ref6 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(err) {
                      return _regenerator["default"].wrap(function _callee5$(_context5) {
                        while (1) switch (_context5.prev = _context5.next) {
                          case 0:
                            console.log(err);
                            return _context5.abrupt("return");
                          case 2:
                          case "end":
                            return _context5.stop();
                        }
                      }, _callee5);
                    }));
                    return function (_x8) {
                      return _ref6.apply(this, arguments);
                    };
                  }());
                case 10:
                  whoElseBatches = [];
                case 11:
                  _context8.next = 25;
                  break;
                case 13:
                  if (!(whoElse.messageId && whoElse.threadId)) {
                    _context8.next = 22;
                    break;
                  }
                  _context8.next = 16;
                  return _credentials["default"].getCredentials(companyId, domain._id);
                case 16:
                  _yield$credentials$ge2 = _context8.sent;
                  fileName = _yield$credentials$ge2.fileName;
                  _context8.next = 20;
                  return _moveEmailGsuite["default"].processMoveEmailTrash({
                    fileName: fileName,
                    email: whoElse.to,
                    threadId: whoElse.threadId,
                    messageId: whoElse.messageId
                  }).then( /*#__PURE__*/(0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee6() {
                    return _regenerator["default"].wrap(function _callee6$(_context6) {
                      while (1) switch (_context6.prev = _context6.next) {
                        case 0:
                          whoElse.isErrorWhileMoving = {
                            isError: false,
                            message: ''
                          };
                          whoElse.isTrashed = true;
                          _context6.next = 4;
                          return whoElse.save();
                        case 4:
                          if (emailReported.to !== whoElse.to) _mailer["default"].sendResultMailToOtherReporters(whoElse.name, whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'Trashed', companyId);else _mailer["default"].sendActionResultMail(whoElse.name, whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'TRASHED', false, null, companyId);
                          return _context6.abrupt("return");
                        case 6:
                        case "end":
                          return _context6.stop();
                      }
                    }, _callee6);
                  })))["catch"]( /*#__PURE__*/function () {
                    var _ref8 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee7(err) {
                      return _regenerator["default"].wrap(function _callee7$(_context7) {
                        while (1) switch (_context7.prev = _context7.next) {
                          case 0:
                            whoElse.isErrorWhileMoving = {
                              isError: true,
                              message: err
                            };
                            _context7.next = 3;
                            return whoElse.save();
                          case 3:
                            return _context7.abrupt("return");
                          case 4:
                          case "end":
                            return _context7.stop();
                        }
                      }, _callee7);
                    }));
                    return function (_x9) {
                      return _ref8.apply(this, arguments);
                    };
                  }());
                case 20:
                  _context8.next = 25;
                  break;
                case 22:
                  whoElse.isErrorWhileMoving = {
                    isError: true,
                    message: 'messageId or threadId is missing'
                  };
                  _context8.next = 25;
                  return whoElse.save();
                case 25:
                case "end":
                  return _context8.stop();
              }
            }, _loop);
          });
          i = 0;
        case 42:
          if (!(i < whoElseIds.length)) {
            _context9.next = 50;
            break;
          }
          return _context9.delegateYield(_loop(), "t0", 44);
        case 44:
          _ret = _context9.t0;
          if (!(_ret === "continue")) {
            _context9.next = 47;
            break;
          }
          return _context9.abrupt("continue", 47);
        case 47:
          i++;
          _context9.next = 42;
          break;
        case 50:
          if (!whoElseBatches.length) {
            _context9.next = 54;
            break;
          }
          _context9.next = 53;
          return _moveEmailOutlook["default"].processMoveEmailTrash(whoElseBatches).then( /*#__PURE__*/function () {
            var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(responses) {
              return _regenerator["default"].wrap(function _callee2$(_context2) {
                while (1) switch (_context2.prev = _context2.next) {
                  case 0:
                    _kue.queue.create('process-who-else-trash-batches-outlook', {
                      responses: responses,
                      emailReported: emailReported,
                      Trash: true,
                      Recover: false,
                      Delete: false,
                      companyId: companyId
                    }).removeOnComplete(true).priority('high').save();
                    return _context2.abrupt("return");
                  case 2:
                  case "end":
                    return _context2.stop();
                }
              }, _callee2);
            }));
            return function (_x5) {
              return _ref3.apply(this, arguments);
            };
          }())["catch"]( /*#__PURE__*/function () {
            var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(err) {
              return _regenerator["default"].wrap(function _callee3$(_context3) {
                while (1) switch (_context3.prev = _context3.next) {
                  case 0:
                    console.log(err);
                    return _context3.abrupt("return");
                  case 2:
                  case "end":
                    return _context3.stop();
                }
              }, _callee3);
            }));
            return function (_x6) {
              return _ref4.apply(this, arguments);
            };
          }());
        case 53:
          whoElseBatches = [];
        case 54:
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isTrashedEmail: "true",
            isRecoveredEmail: "false"
          });
          emailReported.isRecoveredEmail = false;
          emailReported.isTrashedEmail = true;
          _context9.next = 59;
          return emailReported.save();
        case 59:
          return _context9.abrupt("return", res.status(200).send({
            success: true,
            Message: "Successfully trashed!"
          }));
        case 60:
          _context9.next = 66;
          break;
        case 62:
          _context9.prev = 62;
          _context9.t1 = _context9["catch"](0);
          console.log("error", _context9.t1);
          next(_context9.t1);
        case 66:
        case "end":
          return _context9.stop();
      }
    }, _callee8, null, [[0, 62]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _permission.permission)('Emails', 'Delete'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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