"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _credentials = _interopRequireDefault(require("../../service/credentials"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _moveEmailGsuite = _interopRequireDefault(require("../../service/move-email-gsuite"));
var _moveEmailOutlook = _interopRequireDefault(require("../../service/move-email-outlook"));
var _mailer = _interopRequireDefault(require("../../mailer"));
var _permission = require("../../middlewares/permission");
var _kue = require("../../kue");
var _functions = require("../../functions");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _updateMessageId = _interopRequireDefault(require("../../service/update-messageId"));
var _featureBlocker = _interopRequireDefault(require("../../middlewares/featureBlocker"));
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
var validator = _joi["default"].object().keys({
  whoElseIds: _joi["default"].array().items(_joi["default"].string().hex().length(24)).optional(),
  reportedMailId: _joi["default"].string().hex().length(24).required()
});

/**
 * @api {post} /api/v1/mail-actions/move-to-trash Trash Mail
 * @apiName move-to-trash
 * @apiGroup Who-Else
 * @apiDescription Trash a particular who-else mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiBody   {String}  whoElseIds   Required who-else id of the mail to be trashed
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  Message    "Successfully trashed and will be update in sometime"
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "Message": "Successfully deleted and will be update in sometime"
 *       }
 *  
 *  @apiError (500)  {Boolean}  success    false
 *  @apiError (500)  {Array}    messages    ["\"whoElseIds[0]\" is not allowed to be empty"]
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "\"whoElseIds[0]\" is not allowed to be empty"
 *          ]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(req, res, next) {
    var reportedMailId, companyId, emailReported, whoElseIds, user, whoElseIdsDomainWise, whoElses, gsuiteIds, _iterator, _step, _whoElse, result, i, whoElse, lastArray, domainWhoelse, _i, _loop, _i2;
    return _regenerator["default"].wrap(function _callee4$(_context5) {
      while (1) switch (_context5.prev = _context5.next) {
        case 0:
          _context5.prev = 0;
          reportedMailId = req.body.reportedMailId;
          companyId = req.user.companyId;
          _context5.next = 5;
          return db.ReportedMail.findOne({
            _id: reportedMailId,
            companyId: companyId
          });
        case 5:
          emailReported = _context5.sent;
          if (emailReported) {
            _context5.next = 8;
            break;
          }
          throw new RequestError('invalid reportedMailId recieved');
        case 8:
          if (!(emailReported.isWhoElseProcessing == 'true')) {
            _context5.next = 10;
            break;
          }
          throw new RequestError('Who-Else Search in Progress. Please wait and refresh before retrying.');
        case 10:
          _context5.next = 12;
          return db.WhoElse.find({
            reportedMailId: reportedMailId,
            companyId: companyId,
            isDeleted: false,
            deletedAt: null
          }).select('_id');
        case 12:
          whoElseIds = _context5.sent;
          whoElseIds = whoElseIds.map(function (whoElse) {
            return whoElse._id;
          });
          if (!(emailReported.mailType == 'Exchange')) {
            _context5.next = 28;
            break;
          }
          _context5.next = 17;
          return db.User.findOne({
            email: emailReported.to
          });
        case 17:
          user = _context5.sent;
          _mailer["default"].sendActionResultMail(user.name, emailReported.to, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "RECOVERED", false, "", companyId);
          if (emailReported.reporters.length != 0) {
            emailReported.reporters.forEach( /*#__PURE__*/function () {
              var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(reporter) {
                var user;
                return _regenerator["default"].wrap(function _callee$(_context) {
                  while (1) switch (_context.prev = _context.next) {
                    case 0:
                      _context.next = 2;
                      return db.User.findOne({
                        email: reporter === null || reporter === void 0 ? void 0 : reporter.email
                      });
                    case 2:
                      user = _context.sent;
                      _mailer["default"].sendActionResultMail(user.name, reporter.email, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "RECOVERED", false, "", companyId);
                    case 4:
                    case "end":
                      return _context.stop();
                  }
                }, _callee);
              }));
              return function (_x4) {
                return _ref2.apply(this, arguments);
              };
            }());
          }
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isTrashedEmail: "false",
            isRecoveredEmail: "true"
          });
          emailReported.isRecoveredEmail = true;
          emailReported.isTrashedEmail = false;
          _context5.next = 25;
          return emailReported.save();
        case 25:
          return _context5.abrupt("return", res.status(200).send({
            success: true,
            Message: "Successfully marked as safe!"
          }));
        case 28:
          whoElseIdsDomainWise = {};
          whoElses = [];
          gsuiteIds = [];
          _iterator = _createForOfIteratorHelper(whoElseIds);
          _context5.prev = 32;
          _iterator.s();
        case 34:
          if ((_step = _iterator.n()).done) {
            _context5.next = 42;
            break;
          }
          _whoElse = _step.value;
          _context5.next = 38;
          return db.WhoElse.findOne({
            companyId: companyId,
            _id: _whoElse
          }).populate('domainId', 'domainType _id');
        case 38:
          result = _context5.sent;
          if (result.domainId.domainType == 'Gsuite') gsuiteIds.push(result);else whoElses.push(result);
        case 40:
          _context5.next = 34;
          break;
        case 42:
          _context5.next = 47;
          break;
        case 44:
          _context5.prev = 44;
          _context5.t0 = _context5["catch"](32);
          _iterator.e(_context5.t0);
        case 47:
          _context5.prev = 47;
          _iterator.f();
          return _context5.finish(47);
        case 50:
          for (i = 0; i < whoElses.length; i++) {
            whoElse = whoElses[i];
            if (!whoElseIdsDomainWise[whoElse.domainId._id]) whoElseIdsDomainWise[whoElse.domainId._id] = [];
            if (whoElseIdsDomainWise[whoElse.domainId._id].length > 0) {
              lastArray = whoElseIdsDomainWise[whoElse.domainId._id].pop();
              if (lastArray.length < 20) lastArray.push(whoElse), whoElseIdsDomainWise[whoElse.domainId._id].push(lastArray);else whoElseIdsDomainWise[whoElse.domainId._id].push(lastArray), whoElseIdsDomainWise[whoElse.domainId._id].push([whoElse]);
            } else whoElseIdsDomainWise[whoElse.domainId._id].push([whoElse]);
          }
          for (domainWhoelse in whoElseIdsDomainWise) {
            for (_i = 0; _i < whoElseIdsDomainWise[domainWhoelse].length; _i += 10) {
              _kue.queue.create('process-update-folderId-outlook', {
                whoElses: whoElseIdsDomainWise[domainWhoelse].slice(_i, Math.min(_i + 10, whoElseIdsDomainWise[domainWhoelse].length)),
                domainId: domainWhoelse,
                companyId: req.user.companyId,
                emailReported: emailReported,
                mailAction: 'Recovered'
              }).removeOnComplete(true).priority('high').save();
            }
          }
        case 52:
          if (!(gsuiteIds.length > 0)) {
            _context5.next = 60;
            break;
          }
          _loop = /*#__PURE__*/_regenerator["default"].mark(function _loop() {
            var whoElse, _yield$credentials$ge, fileName;
            return _regenerator["default"].wrap(function _loop$(_context4) {
              while (1) switch (_context4.prev = _context4.next) {
                case 0:
                  _context4.next = 2;
                  return db.WhoElse.findOne({
                    _id: gsuiteIds[_i2]
                  });
                case 2:
                  whoElse = _context4.sent;
                  if (!(whoElse.messageId && whoElse.threadId)) {
                    _context4.next = 12;
                    break;
                  }
                  _context4.next = 6;
                  return _credentials["default"].getCredentials(companyId, whoElse.domainId);
                case 6:
                  _yield$credentials$ge = _context4.sent;
                  fileName = _yield$credentials$ge.fileName;
                  _context4.next = 10;
                  return _moveEmailGsuite["default"].processMoveEmailInbox({
                    fileName: fileName,
                    email: whoElse.to,
                    threadId: whoElse.threadId,
                    messageId: whoElse.messageId
                  }).then( /*#__PURE__*/(0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2() {
                    var isReporter;
                    return _regenerator["default"].wrap(function _callee2$(_context2) {
                      while (1) switch (_context2.prev = _context2.next) {
                        case 0:
                          whoElse.isErrorWhileMoving = {
                            isError: false,
                            message: ''
                          };
                          whoElse.isTrashed = false;
                          _context2.next = 4;
                          return whoElse.save();
                        case 4:
                          isReporter = emailReported === null || emailReported === void 0 ? void 0 : emailReported.reporters.find(function (reporter) {
                            return reporter.email.toLowerCase() === whoElse.to.toLowerCase();
                          });
                          if (emailReported.to !== whoElse.to && !isReporter) _mailer["default"].sendResultMailToOtherReporters(whoElse.name, whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'Recovered', companyId);else _mailer["default"].sendActionResultMail(whoElse.name, whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'RECOVERED', false, null, companyId);
                          return _context2.abrupt("return");
                        case 7:
                        case "end":
                          return _context2.stop();
                      }
                    }, _callee2);
                  })))["catch"]( /*#__PURE__*/function () {
                    var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(err) {
                      return _regenerator["default"].wrap(function _callee3$(_context3) {
                        while (1) switch (_context3.prev = _context3.next) {
                          case 0:
                            whoElse.isErrorWhileMoving = {
                              isError: true,
                              message: err
                            };
                            _context3.next = 3;
                            return whoElse.save();
                          case 3:
                            return _context3.abrupt("return");
                          case 4:
                          case "end":
                            return _context3.stop();
                        }
                      }, _callee3);
                    }));
                    return function (_x5) {
                      return _ref4.apply(this, arguments);
                    };
                  }());
                case 10:
                  _context4.next = 15;
                  break;
                case 12:
                  whoElse.isErrorWhileMoving = {
                    isError: true,
                    message: 'messageId or threadId is missing'
                  };
                  _context4.next = 15;
                  return whoElse.save();
                case 15:
                case "end":
                  return _context4.stop();
              }
            }, _loop);
          });
          _i2 = 0;
        case 55:
          if (!(_i2 < gsuiteIds.length)) {
            _context5.next = 60;
            break;
          }
          return _context5.delegateYield(_loop(), "t1", 57);
        case 57:
          _i2++;
          _context5.next = 55;
          break;
        case 60:
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isTrashedEmail: "false",
            isRecoveredEmail: "true"
          });
          emailReported.isRecoveredEmail = true;
          emailReported.isTrashedEmail = false;
          _context5.next = 65;
          return emailReported.save();
        case 65:
          return _context5.abrupt("return", res.status(200).send({
            success: true,
            Message: "Successfully Recovered!"
          }));
        case 68:
          _context5.prev = 68;
          _context5.t2 = _context5["catch"](0);
          console.log("error", _context5.t2);
          next(_context5.t2);
        case 72:
        case "end":
          return _context5.stop();
      }
    }, _callee4, null, [[0, 68], [32, 44, 47, 50]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, _strategy.checkCompanyValidityStrategy, (0, _featureBlocker["default"])("TPIR-ARTD"), (0, _permission.permission)('Emails', 'Delete'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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