"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _joi = _interopRequireDefault(require("joi"));
var _express = _interopRequireDefault(require("express"));
var _credentials = _interopRequireDefault(require("../../service/credentials"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _validator = require("../../middlewares/validator");
var _moveEmailGsuite = _interopRequireDefault(require("../../service/move-email-gsuite"));
var _moveEmailOutlook = _interopRequireDefault(require("../../service/move-email-outlook"));
var _mailer = _interopRequireDefault(require("../../mailer"));
var _permission = require("../../middlewares/permission");
var _kue = require("../../kue");
var _functions = require("../../functions");
var _sanitizeHtml = require("../../middlewares/sanitizeHtml");
var _updateMessageId = _interopRequireDefault(require("../../service/update-messageId"));
var validator = _joi["default"].object().keys({
  whoElseIds: _joi["default"].array().items(_joi["default"].string().hex().length(24)),
  reportedMailId: _joi["default"].string().hex().length(24).required()
});
/**
 * @api {post} /api/v1/mail-actions/recover Recover Mail
 * @apiName recover
 * @apiGroup Who-Else
 * @apiDescription Recover a trashed mail
 * 
 * @apiVersion 1.0.0
 * 
 * @apiQuery   {String}  reportedMailId   Required id of the reported mail
 * 
 * @apiSuccess {Boolean} Success    true
 * @apiSuccess {String}  Message    "Successfully recoverd"
 * 
 * @apiSuccessExample Success-Response:
 *     HTTP/1.1 200 OK
 *       {
 *           "success": true,
 *           "Message": "Successfully recovered"
 *       }
 *  
 *  @apiError (402)  {Boolean}  success-1    false
 *  @apiError (402)  {Array}    messages-1   ["invalid reportedMailId recieved"]
 *  
 *  @apiError (402)  {Boolean}  success-2    false
 *  @apiError (402)  {Array}    results-2    ["Invalid domain credentials"]
 * 
 *  @apiErrorExample Error-Response:
 *     HTTP/1.1 402 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "invalid reportedMailId recieved"
 *          ]
 *      }
 * 
 *   @apiErrorExample Error-Response:
 *     HTTP/1.1 500 Not Found
 *      {
 *          "success": false,
 *          "messages": [
 *              "invalid domain credentials"
 *          ]
 *      }
 */

var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee8(req, res, next) {
    var _req$body, _req$body$whoElseIds, whoElseIds, reportedMailId, companyId, emailReported, domain, user, whoElseBatches, _yield$credentials$ge, token, update, _loop, i, folderId, _ret;
    return _regenerator["default"].wrap(function _callee8$(_context9) {
      while (1) switch (_context9.prev = _context9.next) {
        case 0:
          _context9.prev = 0;
          _req$body = req.body, _req$body$whoElseIds = _req$body.whoElseIds, whoElseIds = _req$body$whoElseIds === void 0 ? [] : _req$body$whoElseIds, reportedMailId = _req$body.reportedMailId;
          companyId = req.user.companyId;
          _context9.next = 5;
          return db.ReportedMail.findOne({
            _id: reportedMailId,
            companyId: companyId
          });
        case 5:
          emailReported = _context9.sent;
          if (emailReported) {
            _context9.next = 8;
            break;
          }
          throw new RequestError('invalid reportedMailId recieved');
        case 8:
          _context9.next = 10;
          return db.Domain.findOne({
            _id: emailReported.domainId,
            deletedAt: null
          });
        case 10:
          domain = _context9.sent;
          if (domain) {
            _context9.next = 13;
            break;
          }
          throw new RequestError('invalid domain or deleted');
        case 13:
          if (!(emailReported.mailType !== 'Exchange')) {
            _context9.next = 16;
            break;
          }
          if (!(domain.isCredential == false)) {
            _context9.next = 16;
            break;
          }
          throw new RequestError('Domain credentials not set');
        case 16:
          if (!(emailReported.mailType == 'Exchange')) {
            _context9.next = 30;
            break;
          }
          _context9.next = 19;
          return db.User.findOne({
            email: emailReported.to
          });
        case 19:
          user = _context9.sent;
          if (emailReported.fileName == null) _mailer["default"].sendActionResultMail(user.name, emailReported.to, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "SAFE", false, "", companyId);else _mailer["default"].sendActionResultMail(user.name, emailReported.to, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "SAFE", true, emailReported.fileName, companyId);
          if (emailReported.reporters.length != 0) {
            emailReported.reporters.forEach( /*#__PURE__*/function () {
              var _ref2 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(email) {
                var user;
                return _regenerator["default"].wrap(function _callee$(_context) {
                  while (1) switch (_context.prev = _context.next) {
                    case 0:
                      _context.next = 2;
                      return db.User.findOne({
                        email: email
                      });
                    case 2:
                      user = _context.sent;
                      if (emailReported.fileName == null) _mailer["default"].sendActionResultMail(user.name, email, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "SAFE", false, "", companyId);else _mailer["default"].sendActionResultMail(user.name, email, emailReported.from, emailReported.subject, emailReported.mailRecievedTime, "SAFE", true, emailReported.fileName, companyId);
                    case 4:
                    case "end":
                      return _context.stop();
                  }
                }, _callee);
              }));
              return function (_x4) {
                return _ref2.apply(this, arguments);
              };
            }());
          }
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isTrashedEmail: "false",
            isRecoveredEmail: "true"
          });
          emailReported.isRecoveredEmail = true;
          emailReported.isTrashedEmail = false;
          _context9.next = 27;
          return emailReported.save();
        case 27:
          return _context9.abrupt("return", res.status(200).send({
            success: true,
            Message: "Successfully recovered!"
          }));
        case 30:
          whoElseBatches = [];
          if (!(domain.domainType == 'Outlook')) {
            _context9.next = 39;
            break;
          }
          _context9.next = 34;
          return _credentials["default"].getCredentials(companyId, domain._id);
        case 34:
          _yield$credentials$ge = _context9.sent;
          token = _yield$credentials$ge.token;
          _context9.next = 38;
          return _updateMessageId["default"].processUpdateMessageId(whoElseIds, token);
        case 38:
          update = _context9.sent;
        case 39:
          _loop = /*#__PURE__*/_regenerator["default"].mark(function _loop() {
            var whoElse, findFolderIdInReporters, _yield$credentials$ge2, _token, _yield$credentials$ge3, fileName;
            return _regenerator["default"].wrap(function _loop$(_context8) {
              while (1) switch (_context8.prev = _context8.next) {
                case 0:
                  _context8.next = 2;
                  return db.WhoElse.findById(whoElseIds[i]);
                case 2:
                  whoElse = _context8.sent;
                  if (whoElse) {
                    _context8.next = 5;
                    break;
                  }
                  return _context8.abrupt("return", "continue");
                case 5:
                  if (!(domain.domainType == 'Outlook')) {
                    _context8.next = 19;
                    break;
                  }
                  folderId = null;
                  if (emailReported.to === whoElse.to) {
                    folderId = emailReported.reporterFolderId;
                  } else {
                    findFolderIdInReporters = emailReported.reporters.find(function (reporter) {
                      return reporter.email.toLowerCase() === whoElse.to.toLowerCase();
                    });
                    if (findFolderIdInReporters) {
                      folderId = findFolderIdInReporters.folderId;
                    } else {
                      folderId = whoElse.folderId;
                    }
                  }
                  _context8.next = 10;
                  return _credentials["default"].getCredentials(companyId, domain._id);
                case 10:
                  _yield$credentials$ge2 = _context8.sent;
                  _token = _yield$credentials$ge2.token;
                  whoElseBatches.push({
                    id: whoElse._id.toHexString(),
                    email: whoElse.to,
                    token: _token.access_token,
                    messageId: whoElse.messageId,
                    folderId: folderId
                  });
                  if (!(whoElseBatches.length == 20)) {
                    _context8.next = 17;
                    break;
                  }
                  _context8.next = 16;
                  return _moveEmailOutlook["default"].processMoveEmailInbox(whoElseBatches).then( /*#__PURE__*/function () {
                    var _ref5 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee4(responses) {
                      return _regenerator["default"].wrap(function _callee4$(_context4) {
                        while (1) switch (_context4.prev = _context4.next) {
                          case 0:
                            _kue.queue.create('process-who-else-trash-batches-outlook', {
                              responses: responses,
                              emailReported: emailReported,
                              Trash: false,
                              Recover: true,
                              Delete: false,
                              companyId: companyId
                            }).removeOnComplete(true).priority('high').save();
                            return _context4.abrupt("return");
                          case 2:
                          case "end":
                            return _context4.stop();
                        }
                      }, _callee4);
                    }));
                    return function (_x7) {
                      return _ref5.apply(this, arguments);
                    };
                  }())["catch"]( /*#__PURE__*/function () {
                    var _ref6 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee5(err) {
                      return _regenerator["default"].wrap(function _callee5$(_context5) {
                        while (1) switch (_context5.prev = _context5.next) {
                          case 0:
                            console.log(err);
                            return _context5.abrupt("return");
                          case 2:
                          case "end":
                            return _context5.stop();
                        }
                      }, _callee5);
                    }));
                    return function (_x8) {
                      return _ref6.apply(this, arguments);
                    };
                  }());
                case 16:
                  whoElseBatches = [];
                case 17:
                  _context8.next = 31;
                  break;
                case 19:
                  if (!(whoElse.messageId && whoElse.threadId)) {
                    _context8.next = 28;
                    break;
                  }
                  _context8.next = 22;
                  return _credentials["default"].getCredentials(companyId, domain._id);
                case 22:
                  _yield$credentials$ge3 = _context8.sent;
                  fileName = _yield$credentials$ge3.fileName;
                  _context8.next = 26;
                  return _moveEmailGsuite["default"].processMoveEmailInbox({
                    fileName: fileName,
                    email: whoElse.to,
                    threadId: whoElse.threadId,
                    messageId: whoElse.messageId
                  }).then( /*#__PURE__*/(0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee6() {
                    return _regenerator["default"].wrap(function _callee6$(_context6) {
                      while (1) switch (_context6.prev = _context6.next) {
                        case 0:
                          whoElse.isErrorWhileMoving = {
                            isError: false,
                            message: ''
                          };
                          whoElse.isTrashed = false;
                          _context6.next = 4;
                          return whoElse.save();
                        case 4:
                          if (emailReported.to !== whoElse.to) _mailer["default"].sendResultMailToOtherReporters(whoElse.name, whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'Recovered', companyId);else _mailer["default"].sendActionResultMail(whoElse.name, whoElse.to, whoElse.from, whoElse.subject, emailReported.mailRecievedTime, 'RECOVERED', false, null, companyId);
                          return _context6.abrupt("return");
                        case 6:
                        case "end":
                          return _context6.stop();
                      }
                    }, _callee6);
                  })))["catch"]( /*#__PURE__*/function () {
                    var _ref8 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee7(err) {
                      return _regenerator["default"].wrap(function _callee7$(_context7) {
                        while (1) switch (_context7.prev = _context7.next) {
                          case 0:
                            whoElse.isErrorWhileMoving = {
                              isError: true,
                              message: err
                            };
                            _context7.next = 3;
                            return whoElse.save();
                          case 3:
                            return _context7.abrupt("return");
                          case 4:
                          case "end":
                            return _context7.stop();
                        }
                      }, _callee7);
                    }));
                    return function (_x9) {
                      return _ref8.apply(this, arguments);
                    };
                  }());
                case 26:
                  _context8.next = 31;
                  break;
                case 28:
                  whoElse.isErrorWhileMoving = {
                    isError: true,
                    message: 'messageId or threadId is missing'
                  };
                  _context8.next = 31;
                  return whoElse.save();
                case 31:
                case "end":
                  return _context8.stop();
              }
            }, _loop);
          });
          i = 0;
        case 41:
          if (!(i < whoElseIds.length)) {
            _context9.next = 49;
            break;
          }
          return _context9.delegateYield(_loop(), "t0", 43);
        case 43:
          _ret = _context9.t0;
          if (!(_ret === "continue")) {
            _context9.next = 46;
            break;
          }
          return _context9.abrupt("continue", 46);
        case 46:
          i++;
          _context9.next = 41;
          break;
        case 49:
          if (!whoElseBatches.length) {
            _context9.next = 53;
            break;
          }
          _context9.next = 52;
          return _moveEmailOutlook["default"].processMoveEmailInbox(whoElseBatches).then( /*#__PURE__*/function () {
            var _ref3 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee2(responses) {
              return _regenerator["default"].wrap(function _callee2$(_context2) {
                while (1) switch (_context2.prev = _context2.next) {
                  case 0:
                    _kue.queue.create('process-who-else-trash-batches-outlook', {
                      responses: responses,
                      emailReported: emailReported,
                      Trash: false,
                      Recover: true,
                      Delete: false,
                      companyId: companyId
                    }).removeOnComplete(true).priority('high').save();
                    return _context2.abrupt("return");
                  case 2:
                  case "end":
                    return _context2.stop();
                }
              }, _callee2);
            }));
            return function (_x5) {
              return _ref3.apply(this, arguments);
            };
          }())["catch"]( /*#__PURE__*/function () {
            var _ref4 = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee3(err) {
              return _regenerator["default"].wrap(function _callee3$(_context3) {
                while (1) switch (_context3.prev = _context3.next) {
                  case 0:
                    console.log(err);
                    return _context3.abrupt("return");
                  case 2:
                  case "end":
                    return _context3.stop();
                }
              }, _callee3);
            }));
            return function (_x6) {
              return _ref4.apply(this, arguments);
            };
          }());
        case 52:
          whoElseBatches = [];
        case 53:
          (0, _functions.updateReportedMailCache)(reportedMailId, {
            isTrashedEmail: "false",
            isRecoveredEmail: "true"
          });
          emailReported.isRecoveredEmail = true;
          emailReported.isTrashedEmail = false;
          _context9.next = 58;
          return emailReported.save();
        case 58:
          return _context9.abrupt("return", res.status(200).send({
            success: true,
            Message: "Successfully recovered!"
          }));
        case 59:
          _context9.next = 65;
          break;
        case 61:
          _context9.prev = 61;
          _context9.t1 = _context9["catch"](0);
          console.log("error", _context9.t1);
          next(_context9.t1);
        case 65:
        case "end":
          return _context9.stop();
      }
    }, _callee8, null, [[0, 61]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').post((0, _sanitizeHtml.htmlsanitize)(), _strategy.jwtStrategy, (0, _permission.permission)('Emails', 'Write'), (0, _validator.validateBody)(validator), controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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