"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var _licenceCheck = require("../../service/licence-check");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var user, domain, expiry, messenger, companyId, userLimit, userLimitMessenger, domainLimit, expiredAt, addedUsersCount, remainingUserLimit, userCountForGroupsWhichHaveEmailAccess, activeGroupsOfCompanyForEmail, userCountForGroupsWhichHaveMessengerAccess, activeGroupsOfCompanyForMessenger;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          user = 0, domain = 0, expiry = new Date(), messenger = 0;
          companyId = req.user.companyId;
          _context.next = 5;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'userLimit'
          });
        case 5:
          userLimit = _context.sent;
          _context.next = 8;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'userLimitMessenger'
          });
        case 8:
          userLimitMessenger = _context.sent;
          _context.next = 11;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'domainLimit'
          });
        case 11:
          domainLimit = _context.sent;
          _context.next = 14;
          return db.MetaData.findOne({
            companyId: companyId,
            name: 'expiredAt'
          });
        case 14:
          expiredAt = _context.sent;
          _context.next = 17;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null
          });
        case 17:
          addedUsersCount = _context.sent;
          remainingUserLimit = parseInt(userLimit === null || userLimit === void 0 ? void 0 : userLimit.value) + parseInt(userLimitMessenger === null || userLimitMessenger === void 0 ? void 0 : userLimitMessenger.value) - addedUsersCount;
          userCountForGroupsWhichHaveEmailAccess = 0;
          _context.next = 22;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            emailAccess: true
          }).select("_id");
        case 22:
          activeGroupsOfCompanyForEmail = _context.sent;
          if (!(activeGroupsOfCompanyForEmail.length > 0)) {
            _context.next = 27;
            break;
          }
          _context.next = 26;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: activeGroupsOfCompanyForEmail.map(function (group) {
                return group._id;
              })
            }
          });
        case 26:
          userCountForGroupsWhichHaveEmailAccess = _context.sent;
        case 27:
          userCountForGroupsWhichHaveMessengerAccess = 0;
          _context.next = 30;
          return db.Group.find({
            companyId: companyId,
            deletedAt: null,
            messengerAccess: true
          }).select("_id");
        case 30:
          activeGroupsOfCompanyForMessenger = _context.sent;
          if (!(activeGroupsOfCompanyForMessenger.length > 0)) {
            _context.next = 35;
            break;
          }
          _context.next = 34;
          return db.User.countDocuments({
            companyId: companyId,
            deletedAt: null,
            groups: {
              $in: activeGroupsOfCompanyForMessenger.map(function (group) {
                return group._id;
              })
            }
          });
        case 34:
          userCountForGroupsWhichHaveMessengerAccess = _context.sent;
        case 35:
          if (userLimit && userLimitMessenger && domainLimit && expiredAt) {
            user = userLimit.value;
            domain = domainLimit.value;
            messenger = userLimitMessenger.value;
            expiry = new Date(expiredAt.value);
          }
          console.log({
            user: user,
            domain: domain,
            messenger: messenger,
            expiry: expiry
          });
          // else {
          //     const company = await db.Company.findOne({
          //         _id: companyId
          //     })
          //     let license = {
          //         user: "10",
          //         domain: "1",
          //         expiry: 
          //     }

          //     user = license.userLimit
          //     domain = license.domainLimit
          //     expiry = license.expiresAt
          //     await db.MetaData.create({
          //         companyId, 
          //         name: 'userLimit', 
          //         value: "10"
          //     })
          //     await db.MetaData.create({
          //         companyId, 
          //         name: 'domainLimit', 
          //         value: "1"
          //     })
          //     await db.MetaData.create({
          //         companyId, 
          //         name: 'expiredAt', 
          //         value: new Date(new Date(date).setDate(new Date(date).getDate()+14))
          //     })
          // }

          if (!expiry) expiry = new Date(new Date(companyId.createdAt).setDate(new Date(companyId.createdAt).getDate() + 14));
          res.status(200).json({
            success: true,
            user: parseInt(user),
            messenger: parseInt(messenger),
            expiry: expiry,
            utilisedEmailLimit: userCountForGroupsWhichHaveEmailAccess,
            utilisedMessengerLimit: userCountForGroupsWhichHaveMessengerAccess,
            remainingUserLimit: remainingUserLimit
          });
          _context.next = 45;
          break;
        case 41:
          _context.prev = 41;
          _context.t0 = _context["catch"](0);
          console.log(_context.t0);
          next(_context.t0);
        case 45:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 41]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route('/').get((0, _sanitizer.sanitize)(), _strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJuYW1lcyI6WyJjb250cm9sbGVyIiwicmVxIiwicmVzIiwibmV4dCIsInVzZXIiLCJkb21haW4iLCJleHBpcnkiLCJEYXRlIiwibWVzc2VuZ2VyIiwiY29tcGFueUlkIiwiZGIiLCJNZXRhRGF0YSIsImZpbmRPbmUiLCJuYW1lIiwidXNlckxpbWl0IiwidXNlckxpbWl0TWVzc2VuZ2VyIiwiZG9tYWluTGltaXQiLCJleHBpcmVkQXQiLCJVc2VyIiwiY291bnREb2N1bWVudHMiLCJkZWxldGVkQXQiLCJhZGRlZFVzZXJzQ291bnQiLCJyZW1haW5pbmdVc2VyTGltaXQiLCJwYXJzZUludCIsInZhbHVlIiwidXNlckNvdW50Rm9yR3JvdXBzV2hpY2hIYXZlRW1haWxBY2Nlc3MiLCJHcm91cCIsImZpbmQiLCJlbWFpbEFjY2VzcyIsInNlbGVjdCIsImFjdGl2ZUdyb3Vwc09mQ29tcGFueUZvckVtYWlsIiwibGVuZ3RoIiwiZ3JvdXBzIiwiJGluIiwibWFwIiwiZ3JvdXAiLCJfaWQiLCJ1c2VyQ291bnRGb3JHcm91cHNXaGljaEhhdmVNZXNzZW5nZXJBY2Nlc3MiLCJtZXNzZW5nZXJBY2Nlc3MiLCJhY3RpdmVHcm91cHNPZkNvbXBhbnlGb3JNZXNzZW5nZXIiLCJjb25zb2xlIiwibG9nIiwiY3JlYXRlZEF0Iiwic2V0RGF0ZSIsImdldERhdGUiLCJzdGF0dXMiLCJqc29uIiwic3VjY2VzcyIsInV0aWxpc2VkRW1haWxMaW1pdCIsInV0aWxpc2VkTWVzc2VuZ2VyTGltaXQiLCJhcGlSb3V0ZXIiLCJleHByZXNzIiwiUm91dGVyIiwicm91dGUiLCJnZXQiLCJzYW5pdGl6ZSIsImp3dFN0cmF0ZWd5Il0sInNvdXJjZXMiOlsiLi4vLi4vLi4vc3JjL2FwaS9vdmVydmlldy9jaGVjay1saWNlbmNlLmpzIl0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBleHByZXNzIGZyb20gJ2V4cHJlc3MnO1xuXG5pbXBvcnQgeyBzYW5pdGl6ZSB9IGZyb20gJy4uLy4uL21pZGRsZXdhcmVzL3Nhbml0aXplcic7XG5pbXBvcnQgeyBqd3RTdHJhdGVneSB9IGZyb20gJy4uLy4uL21pZGRsZXdhcmVzL3N0cmF0ZWd5JztcbmltcG9ydCB7IGxpY2VuY2VDaGVjayB9IGZyb20gJy4uLy4uL3NlcnZpY2UvbGljZW5jZS1jaGVjayc7XG5cbmxldCBjb250cm9sbGVyID0gYXN5bmMgKHJlcSwgcmVzLCBuZXh0KSA9PiB7XG4gICAgdHJ5IHtcbiAgICAgICAgbGV0IHVzZXIgPSAwLCBkb21haW4gPSAwLCBleHBpcnkgPSBuZXcgRGF0ZSgpLCBtZXNzZW5nZXIgPSAwO1xuXG4gICAgICAgIGNvbnN0IGNvbXBhbnlJZCA9IHJlcS51c2VyLmNvbXBhbnlJZDtcbiAgICAgICAgY29uc3QgdXNlckxpbWl0ID0gYXdhaXQgZGIuTWV0YURhdGEuZmluZE9uZSh7XG4gICAgICAgICAgICBjb21wYW55SWQsXG4gICAgICAgICAgICBuYW1lOiAndXNlckxpbWl0J1xuICAgICAgICB9KVxuICAgICAgICBjb25zdCB1c2VyTGltaXRNZXNzZW5nZXIgPSBhd2FpdCBkYi5NZXRhRGF0YS5maW5kT25lKHtcbiAgICAgICAgICAgIGNvbXBhbnlJZCxcbiAgICAgICAgICAgIG5hbWU6ICd1c2VyTGltaXRNZXNzZW5nZXInXG4gICAgICAgIH0pXG4gICAgICAgIGNvbnN0IGRvbWFpbkxpbWl0ID0gYXdhaXQgZGIuTWV0YURhdGEuZmluZE9uZSh7XG4gICAgICAgICAgICBjb21wYW55SWQsXG4gICAgICAgICAgICBuYW1lOiAnZG9tYWluTGltaXQnXG4gICAgICAgIH0pXG4gICAgICAgIGNvbnN0IGV4cGlyZWRBdCA9IGF3YWl0IGRiLk1ldGFEYXRhLmZpbmRPbmUoe1xuICAgICAgICAgICAgY29tcGFueUlkLFxuICAgICAgICAgICAgbmFtZTogJ2V4cGlyZWRBdCdcbiAgICAgICAgfSlcblxuICAgICAgICBjb25zdCBhZGRlZFVzZXJzQ291bnQgPSBhd2FpdCBkYi5Vc2VyLmNvdW50RG9jdW1lbnRzKHtjb21wYW55SWQsIGRlbGV0ZWRBdDpudWxsfSlcbiAgICAgICAgY29uc3QgcmVtYWluaW5nVXNlckxpbWl0ID0gKHBhcnNlSW50KHVzZXJMaW1pdD8udmFsdWUpICsgcGFyc2VJbnQodXNlckxpbWl0TWVzc2VuZ2VyPy52YWx1ZSkpIC0gYWRkZWRVc2Vyc0NvdW50XG5cbiAgICAgICAgbGV0IHVzZXJDb3VudEZvckdyb3Vwc1doaWNoSGF2ZUVtYWlsQWNjZXNzID0gMFxuICAgICAgICBsZXQgYWN0aXZlR3JvdXBzT2ZDb21wYW55Rm9yRW1haWwgPSBhd2FpdCBkYi5Hcm91cC5maW5kKHtjb21wYW55SWQsIGRlbGV0ZWRBdDpudWxsLCBlbWFpbEFjY2Vzczp0cnVlfSkuc2VsZWN0KFwiX2lkXCIpXG4gICAgICAgIGlmKGFjdGl2ZUdyb3Vwc09mQ29tcGFueUZvckVtYWlsLmxlbmd0aCA+IDApIHVzZXJDb3VudEZvckdyb3Vwc1doaWNoSGF2ZUVtYWlsQWNjZXNzID0gYXdhaXQgZGIuVXNlci5jb3VudERvY3VtZW50cyh7Y29tcGFueUlkLCBkZWxldGVkQXQ6bnVsbCwgZ3JvdXBzOnskaW46YWN0aXZlR3JvdXBzT2ZDb21wYW55Rm9yRW1haWwubWFwKGdyb3VwPT5ncm91cC5faWQpfX0pIFxuXG4gICAgICAgIGxldCB1c2VyQ291bnRGb3JHcm91cHNXaGljaEhhdmVNZXNzZW5nZXJBY2Nlc3MgPSAwXG4gICAgICAgIGxldCBhY3RpdmVHcm91cHNPZkNvbXBhbnlGb3JNZXNzZW5nZXIgPSBhd2FpdCBkYi5Hcm91cC5maW5kKHtjb21wYW55SWQsIGRlbGV0ZWRBdDpudWxsLCBtZXNzZW5nZXJBY2Nlc3M6dHJ1ZX0pLnNlbGVjdChcIl9pZFwiKVxuICAgICAgICBpZihhY3RpdmVHcm91cHNPZkNvbXBhbnlGb3JNZXNzZW5nZXIubGVuZ3RoID4gMCkgdXNlckNvdW50Rm9yR3JvdXBzV2hpY2hIYXZlTWVzc2VuZ2VyQWNjZXNzID0gYXdhaXQgZGIuVXNlci5jb3VudERvY3VtZW50cyh7Y29tcGFueUlkLCBkZWxldGVkQXQ6bnVsbCwgZ3JvdXBzOnskaW46YWN0aXZlR3JvdXBzT2ZDb21wYW55Rm9yTWVzc2VuZ2VyLm1hcChncm91cD0+Z3JvdXAuX2lkKX19KVxuXG5cbiAgICAgICAgaWYodXNlckxpbWl0ICYmIHVzZXJMaW1pdE1lc3NlbmdlciAmJiAgZG9tYWluTGltaXQgJiYgZXhwaXJlZEF0KXtcbiAgICAgICAgICAgIHVzZXIgPSB1c2VyTGltaXQudmFsdWVcbiAgICAgICAgICAgIGRvbWFpbiA9IGRvbWFpbkxpbWl0LnZhbHVlXG4gICAgICAgICAgICBtZXNzZW5nZXIgPSAgdXNlckxpbWl0TWVzc2VuZ2VyLnZhbHVlXG4gICAgICAgICAgICBleHBpcnkgPSBuZXcgRGF0ZShleHBpcmVkQXQudmFsdWUpXG4gICAgICAgIH0gXG4gICAgICAgIGNvbnNvbGUubG9nKHtcbiAgICAgICAgICAgIHVzZXIsIGRvbWFpbiwgbWVzc2VuZ2VyLCBleHBpcnlcbiAgICAgICAgfSlcbiAgICAgICAgLy8gZWxzZSB7XG4gICAgICAgIC8vICAgICBjb25zdCBjb21wYW55ID0gYXdhaXQgZGIuQ29tcGFueS5maW5kT25lKHtcbiAgICAgICAgLy8gICAgICAgICBfaWQ6IGNvbXBhbnlJZFxuICAgICAgICAvLyAgICAgfSlcbiAgICAgICAgLy8gICAgIGxldCBsaWNlbnNlID0ge1xuICAgICAgICAvLyAgICAgICAgIHVzZXI6IFwiMTBcIixcbiAgICAgICAgLy8gICAgICAgICBkb21haW46IFwiMVwiLFxuICAgICAgICAvLyAgICAgICAgIGV4cGlyeTogXG4gICAgICAgIC8vICAgICB9XG5cbiAgICAgICAgLy8gICAgIHVzZXIgPSBsaWNlbnNlLnVzZXJMaW1pdFxuICAgICAgICAvLyAgICAgZG9tYWluID0gbGljZW5zZS5kb21haW5MaW1pdFxuICAgICAgICAvLyAgICAgZXhwaXJ5ID0gbGljZW5zZS5leHBpcmVzQXRcbiAgICAgICAgLy8gICAgIGF3YWl0IGRiLk1ldGFEYXRhLmNyZWF0ZSh7XG4gICAgICAgIC8vICAgICAgICAgY29tcGFueUlkLCBcbiAgICAgICAgLy8gICAgICAgICBuYW1lOiAndXNlckxpbWl0JywgXG4gICAgICAgIC8vICAgICAgICAgdmFsdWU6IFwiMTBcIlxuICAgICAgICAvLyAgICAgfSlcbiAgICAgICAgLy8gICAgIGF3YWl0IGRiLk1ldGFEYXRhLmNyZWF0ZSh7XG4gICAgICAgIC8vICAgICAgICAgY29tcGFueUlkLCBcbiAgICAgICAgLy8gICAgICAgICBuYW1lOiAnZG9tYWluTGltaXQnLCBcbiAgICAgICAgLy8gICAgICAgICB2YWx1ZTogXCIxXCJcbiAgICAgICAgLy8gICAgIH0pXG4gICAgICAgIC8vICAgICBhd2FpdCBkYi5NZXRhRGF0YS5jcmVhdGUoe1xuICAgICAgICAvLyAgICAgICAgIGNvbXBhbnlJZCwgXG4gICAgICAgIC8vICAgICAgICAgbmFtZTogJ2V4cGlyZWRBdCcsIFxuICAgICAgICAvLyAgICAgICAgIHZhbHVlOiBuZXcgRGF0ZShuZXcgRGF0ZShkYXRlKS5zZXREYXRlKG5ldyBEYXRlKGRhdGUpLmdldERhdGUoKSsxNCkpXG4gICAgICAgIC8vICAgICB9KVxuICAgICAgICAvLyB9XG5cbiAgICAgICAgaWYoIWV4cGlyeSkgZXhwaXJ5ID0gbmV3IERhdGUobmV3IERhdGUoY29tcGFueUlkLmNyZWF0ZWRBdCkuc2V0RGF0ZShuZXcgRGF0ZShjb21wYW55SWQuY3JlYXRlZEF0KS5nZXREYXRlKCkrMTQpKTtcbiAgICAgICAgXG5cbiAgICAgICAgcmVzLnN0YXR1cygyMDApLmpzb24oeyBzdWNjZXNzOiB0cnVlLCB1c2VyOiBwYXJzZUludCh1c2VyKSwgbWVzc2VuZ2VyOiBwYXJzZUludChtZXNzZW5nZXIpLCBleHBpcnksIHV0aWxpc2VkRW1haWxMaW1pdDogdXNlckNvdW50Rm9yR3JvdXBzV2hpY2hIYXZlRW1haWxBY2Nlc3MsIHV0aWxpc2VkTWVzc2VuZ2VyTGltaXQ6IHVzZXJDb3VudEZvckdyb3Vwc1doaWNoSGF2ZU1lc3NlbmdlckFjY2VzcywgcmVtYWluaW5nVXNlckxpbWl0IH0pO1xuICAgIH0gY2F0Y2goZXJyKXtcbiAgICAgICAgY29uc29sZS5sb2coZXJyKTtcbiAgICAgICAgbmV4dChlcnIpO1xuICAgIH1cbn1cbmNvbnN0IGFwaVJvdXRlciA9IGV4cHJlc3MuUm91dGVyKCk7XG5hcGlSb3V0ZXIucm91dGUoJy8nKS5nZXQoc2FuaXRpemUoKSwgand0U3RyYXRlZ3ksIGNvbnRyb2xsZXIpO1xuZXhwb3J0IGRlZmF1bHQgYXBpUm91dGVyOyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBQUE7QUFFQTtBQUNBO0FBQ0E7QUFFQSxJQUFJQSxVQUFVO0VBQUEseUZBQUcsaUJBQU9DLEdBQUcsRUFBRUMsR0FBRyxFQUFFQyxJQUFJO0lBQUE7SUFBQTtNQUFBO1FBQUE7VUFBQTtVQUUxQkMsSUFBSSxHQUFHLENBQUMsRUFBRUMsTUFBTSxHQUFHLENBQUMsRUFBRUMsTUFBTSxHQUFHLElBQUlDLElBQUksRUFBRSxFQUFFQyxTQUFTLEdBQUcsQ0FBQztVQUV0REMsU0FBUyxHQUFHUixHQUFHLENBQUNHLElBQUksQ0FBQ0ssU0FBUztVQUFBO1VBQUEsT0FDWkMsRUFBRSxDQUFDQyxRQUFRLENBQUNDLE9BQU8sQ0FBQztZQUN4Q0gsU0FBUyxFQUFUQSxTQUFTO1lBQ1RJLElBQUksRUFBRTtVQUNWLENBQUMsQ0FBQztRQUFBO1VBSElDLFNBQVM7VUFBQTtVQUFBLE9BSWtCSixFQUFFLENBQUNDLFFBQVEsQ0FBQ0MsT0FBTyxDQUFDO1lBQ2pESCxTQUFTLEVBQVRBLFNBQVM7WUFDVEksSUFBSSxFQUFFO1VBQ1YsQ0FBQyxDQUFDO1FBQUE7VUFISUUsa0JBQWtCO1VBQUE7VUFBQSxPQUlFTCxFQUFFLENBQUNDLFFBQVEsQ0FBQ0MsT0FBTyxDQUFDO1lBQzFDSCxTQUFTLEVBQVRBLFNBQVM7WUFDVEksSUFBSSxFQUFFO1VBQ1YsQ0FBQyxDQUFDO1FBQUE7VUFISUcsV0FBVztVQUFBO1VBQUEsT0FJT04sRUFBRSxDQUFDQyxRQUFRLENBQUNDLE9BQU8sQ0FBQztZQUN4Q0gsU0FBUyxFQUFUQSxTQUFTO1lBQ1RJLElBQUksRUFBRTtVQUNWLENBQUMsQ0FBQztRQUFBO1VBSElJLFNBQVM7VUFBQTtVQUFBLE9BS2VQLEVBQUUsQ0FBQ1EsSUFBSSxDQUFDQyxjQUFjLENBQUM7WUFBQ1YsU0FBUyxFQUFUQSxTQUFTO1lBQUVXLFNBQVMsRUFBQztVQUFJLENBQUMsQ0FBQztRQUFBO1VBQTNFQyxlQUFlO1VBQ2ZDLGtCQUFrQixHQUFJQyxRQUFRLENBQUNULFNBQVMsYUFBVEEsU0FBUyx1QkFBVEEsU0FBUyxDQUFFVSxLQUFLLENBQUMsR0FBR0QsUUFBUSxDQUFDUixrQkFBa0IsYUFBbEJBLGtCQUFrQix1QkFBbEJBLGtCQUFrQixDQUFFUyxLQUFLLENBQUMsR0FBSUgsZUFBZTtVQUUzR0ksc0NBQXNDLEdBQUcsQ0FBQztVQUFBO1VBQUEsT0FDSmYsRUFBRSxDQUFDZ0IsS0FBSyxDQUFDQyxJQUFJLENBQUM7WUFBQ2xCLFNBQVMsRUFBVEEsU0FBUztZQUFFVyxTQUFTLEVBQUMsSUFBSTtZQUFFUSxXQUFXLEVBQUM7VUFBSSxDQUFDLENBQUMsQ0FBQ0MsTUFBTSxDQUFDLEtBQUssQ0FBQztRQUFBO1VBQWhIQyw2QkFBNkI7VUFBQSxNQUM5QkEsNkJBQTZCLENBQUNDLE1BQU0sR0FBRyxDQUFDO1lBQUE7WUFBQTtVQUFBO1VBQUE7VUFBQSxPQUFpRHJCLEVBQUUsQ0FBQ1EsSUFBSSxDQUFDQyxjQUFjLENBQUM7WUFBQ1YsU0FBUyxFQUFUQSxTQUFTO1lBQUVXLFNBQVMsRUFBQyxJQUFJO1lBQUVZLE1BQU0sRUFBQztjQUFDQyxHQUFHLEVBQUNILDZCQUE2QixDQUFDSSxHQUFHLENBQUMsVUFBQUMsS0FBSztnQkFBQSxPQUFFQSxLQUFLLENBQUNDLEdBQUc7Y0FBQTtZQUFDO1VBQUMsQ0FBQyxDQUFDO1FBQUE7VUFBcEtYLHNDQUFzQztRQUFBO1VBRS9FWSwwQ0FBMEMsR0FBRyxDQUFDO1VBQUE7VUFBQSxPQUNKM0IsRUFBRSxDQUFDZ0IsS0FBSyxDQUFDQyxJQUFJLENBQUM7WUFBQ2xCLFNBQVMsRUFBVEEsU0FBUztZQUFFVyxTQUFTLEVBQUMsSUFBSTtZQUFFa0IsZUFBZSxFQUFDO1VBQUksQ0FBQyxDQUFDLENBQUNULE1BQU0sQ0FBQyxLQUFLLENBQUM7UUFBQTtVQUF4SFUsaUNBQWlDO1VBQUEsTUFDbENBLGlDQUFpQyxDQUFDUixNQUFNLEdBQUcsQ0FBQztZQUFBO1lBQUE7VUFBQTtVQUFBO1VBQUEsT0FBcURyQixFQUFFLENBQUNRLElBQUksQ0FBQ0MsY0FBYyxDQUFDO1lBQUNWLFNBQVMsRUFBVEEsU0FBUztZQUFFVyxTQUFTLEVBQUMsSUFBSTtZQUFFWSxNQUFNLEVBQUM7Y0FBQ0MsR0FBRyxFQUFDTSxpQ0FBaUMsQ0FBQ0wsR0FBRyxDQUFDLFVBQUFDLEtBQUs7Z0JBQUEsT0FBRUEsS0FBSyxDQUFDQyxHQUFHO2NBQUE7WUFBQztVQUFDLENBQUMsQ0FBQztRQUFBO1VBQTVLQywwQ0FBMEM7UUFBQTtVQUczRixJQUFHdkIsU0FBUyxJQUFJQyxrQkFBa0IsSUFBS0MsV0FBVyxJQUFJQyxTQUFTLEVBQUM7WUFDNURiLElBQUksR0FBR1UsU0FBUyxDQUFDVSxLQUFLO1lBQ3RCbkIsTUFBTSxHQUFHVyxXQUFXLENBQUNRLEtBQUs7WUFDMUJoQixTQUFTLEdBQUlPLGtCQUFrQixDQUFDUyxLQUFLO1lBQ3JDbEIsTUFBTSxHQUFHLElBQUlDLElBQUksQ0FBQ1UsU0FBUyxDQUFDTyxLQUFLLENBQUM7VUFDdEM7VUFDQWdCLE9BQU8sQ0FBQ0MsR0FBRyxDQUFDO1lBQ1JyQyxJQUFJLEVBQUpBLElBQUk7WUFBRUMsTUFBTSxFQUFOQSxNQUFNO1lBQUVHLFNBQVMsRUFBVEEsU0FBUztZQUFFRixNQUFNLEVBQU5BO1VBQzdCLENBQUMsQ0FBQztVQUNGO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTs7VUFFQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTtVQUNBO1VBQ0E7VUFDQTs7VUFFQSxJQUFHLENBQUNBLE1BQU0sRUFBRUEsTUFBTSxHQUFHLElBQUlDLElBQUksQ0FBQyxJQUFJQSxJQUFJLENBQUNFLFNBQVMsQ0FBQ2lDLFNBQVMsQ0FBQyxDQUFDQyxPQUFPLENBQUMsSUFBSXBDLElBQUksQ0FBQ0UsU0FBUyxDQUFDaUMsU0FBUyxDQUFDLENBQUNFLE9BQU8sRUFBRSxHQUFDLEVBQUUsQ0FBQyxDQUFDO1VBR2hIMUMsR0FBRyxDQUFDMkMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDQyxJQUFJLENBQUM7WUFBRUMsT0FBTyxFQUFFLElBQUk7WUFBRTNDLElBQUksRUFBRW1CLFFBQVEsQ0FBQ25CLElBQUksQ0FBQztZQUFFSSxTQUFTLEVBQUVlLFFBQVEsQ0FBQ2YsU0FBUyxDQUFDO1lBQUVGLE1BQU0sRUFBTkEsTUFBTTtZQUFFMEMsa0JBQWtCLEVBQUV2QixzQ0FBc0M7WUFBRXdCLHNCQUFzQixFQUFFWiwwQ0FBMEM7WUFBRWYsa0JBQWtCLEVBQWxCQTtVQUFtQixDQUFDLENBQUM7VUFBQztVQUFBO1FBQUE7VUFBQTtVQUFBO1VBRTFQa0IsT0FBTyxDQUFDQyxHQUFHLGFBQUs7VUFDaEJ0QyxJQUFJLGFBQUs7UUFBQztRQUFBO1VBQUE7TUFBQTtJQUFBO0VBQUEsQ0FFakI7RUFBQSxnQkFqRkdILFVBQVU7SUFBQTtFQUFBO0FBQUEsR0FpRmI7QUFDRCxJQUFNa0QsU0FBUyxHQUFHQyxtQkFBTyxDQUFDQyxNQUFNLEVBQUU7QUFDbENGLFNBQVMsQ0FBQ0csS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDQyxHQUFHLENBQUMsSUFBQUMsbUJBQVEsR0FBRSxFQUFFQyxxQkFBVyxFQUFFeEQsVUFBVSxDQUFDO0FBQUMsZUFDL0NrRCxTQUFTO0FBQUEifQ==