"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _asyncToGenerator2 = _interopRequireDefault(require("@babel/runtime/helpers/asyncToGenerator"));
var _express = _interopRequireDefault(require("express"));
var _sanitizer = require("../../middlewares/sanitizer");
var _strategy = require("../../middlewares/strategy");
var controller = /*#__PURE__*/function () {
  var _ref = (0, _asyncToGenerator2["default"])( /*#__PURE__*/_regenerator["default"].mark(function _callee(req, res, next) {
    var companyId, domainsOfCurrentCompany, uniqueDomains, namesOfdomains, uniqueDomainNames, reportedEmails, domains, emailChecked, users, contacts, whatsappReportings;
    return _regenerator["default"].wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.prev = 0;
          companyId = req.user.companyId;
          _context.next = 4;
          return db.Domain.find({
            companyId: companyId,
            deletedAt: null
          }).select("domainType domainTypeForOutlook");
        case 4:
          domainsOfCurrentCompany = _context.sent;
          uniqueDomains = new Set();
          domainsOfCurrentCompany.map(function (currentDomain) {
            uniqueDomains.add(currentDomain._id);
          });
          namesOfdomains = [];
          domainsOfCurrentCompany.map(function (value) {
            if (value.domainType === "Gsuite") {
              namesOfdomains.push("Gsuite");
            } else {
              namesOfdomains.push("Outlook");
              namesOfdomains.push(value.domainTypeForOutlook === "EXCHANGE" ? "Exchange" : value.domainTypeForOutlook);
            }
          });
          domainsOfCurrentCompany = (0, _toConsumableArray2["default"])(uniqueDomains);
          uniqueDomainNames = new Set();
          namesOfdomains.map(function (value) {
            console.log(value);
            uniqueDomainNames.add(value);
          });
          namesOfdomains = (0, _toConsumableArray2["default"])(uniqueDomainNames);
          domainsOfCurrentCompany = domainsOfCurrentCompany.map(function (value) {
            return value._id;
          });
          _context.next = 16;
          return db.ReportedMail.countDocuments({
            companyId: companyId,
            domainId: {
              $in: domainsOfCurrentCompany
            },
            mailType: {
              $in: namesOfdomains
            }
          });
        case 16:
          reportedEmails = _context.sent;
          _context.next = 19;
          return db.Domain.countDocuments({
            companyId: companyId,
            deletedAt: null
          });
        case 19:
          domains = _context.sent;
          _context.next = 22;
          return db.CheckEmailScoreEvent.countDocuments({
            companyId: companyId
          });
        case 22:
          emailChecked = _context.sent;
          _context.next = 25;
          return db.User.countDocuments({
            companyId: companyId,
            email: {
              $ne: null
            },
            deletedAt: null,
            isActive: true
          });
        case 25:
          users = _context.sent;
          _context.next = 28;
          return db.User.countDocuments({
            companyId: companyId,
            phoneNumber: {
              $ne: null
            },
            deletedAt: null
          });
        case 28:
          contacts = _context.sent;
          _context.next = 31;
          return db.whatsapp.countDocuments({
            companyId: companyId,
            deletedAt: null
          });
        case 31:
          whatsappReportings = _context.sent;
          return _context.abrupt("return", res.status(200).send({
            success: true,
            reportedEmails: reportedEmails,
            domains: domains,
            emailChecked: emailChecked,
            users: users,
            whatsappReportings: whatsappReportings,
            contacts: contacts
          }));
        case 35:
          _context.prev = 35;
          _context.t0 = _context["catch"](0);
          console.log("error", _context.t0);
          next(_context.t0);
        case 39:
        case "end":
          return _context.stop();
      }
    }, _callee, null, [[0, 35]]);
  }));
  return function controller(_x, _x2, _x3) {
    return _ref.apply(this, arguments);
  };
}();
var apiRouter = _express["default"].Router();
apiRouter.route("/").get((0, _sanitizer.sanitize)(), _strategy.jwtStrategy, controller);
var _default = apiRouter;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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